/*
 * Decompiled with CFR 0.152.
 */
package com.majruszsenchantments.enchantments;

import com.majruszlibrary.annotation.AutoInstance;
import com.majruszlibrary.data.Reader;
import com.majruszlibrary.entity.AttributeHandler;
import com.majruszlibrary.events.OnItemEquipped;
import com.majruszlibrary.events.base.Condition;
import com.majruszlibrary.item.CustomEnchantment;
import com.majruszlibrary.item.EnchantmentHelper;
import com.majruszlibrary.item.EquipmentSlots;
import com.majruszlibrary.math.Range;
import com.majruszsenchantments.MajruszsEnchantments;
import com.majruszsenchantments.common.Handler;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.item.enchantment.Enchantment;

@AutoInstance
public class HorseProtectionEnchantment
extends Handler {
    final AttributeHandler attribute = new AttributeHandler("%s_armor".formatted(this.enchantment.getId()), () -> Attributes.f_22284_, AttributeModifier.Operation.ADDITION);
    float armor = 2.0f;

    public static CustomEnchantment create() {
        return new CustomEnchantment().rarity(Enchantment.Rarity.RARE).category(MajruszsEnchantments.IS_HORSE_ARMOR).slots((List)EquipmentSlots.ARMOR).maxLevel(4).minLevelCost(level -> level * 6 - 5).maxLevelCost(level -> level * 6 + 5);
    }

    public HorseProtectionEnchantment() {
        super(MajruszsEnchantments.HORSE_PROTECTION, HorseProtectionEnchantment.class, false);
        OnItemEquipped.listen(this::updateArmor).addCondition(Condition.isLogicalServer()).addCondition(data -> data.entity instanceof Animal);
        this.config.define("armor_bonus_per_level", Reader.number(), s -> Float.valueOf(this.armor), (s, v) -> {
            this.armor = ((Float)Range.of((Number)Float.valueOf(0.0f), (Number)Float.valueOf(100.0f)).clamp((Number)v)).floatValue();
        });
    }

    private void updateArmor(OnItemEquipped data) {
        this.attribute.setValue((double)(this.armor * (float)EnchantmentHelper.getLevelSum((Supplier)this.enchantment, (LivingEntity)data.entity))).apply(data.entity);
    }
}

