/*
 * Decompiled with CFR 0.152.
 */
package com.majruszsenchantments.curses;

import com.majruszlibrary.annotation.AutoInstance;
import com.majruszlibrary.data.Reader;
import com.majruszlibrary.events.OnEntityTicked;
import com.majruszlibrary.events.base.Condition;
import com.majruszlibrary.item.CustomEnchantment;
import com.majruszlibrary.item.EnchantmentHelper;
import com.majruszlibrary.item.EquipmentSlots;
import com.majruszlibrary.level.LevelHelper;
import com.majruszlibrary.math.Range;
import com.majruszsenchantments.MajruszsEnchantments;
import com.majruszsenchantments.common.Handler;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.minecraft.world.level.Level;

@AutoInstance
public class CorrosionCurse
extends Handler {
    float damage = 0.25f;
    float cooldown = 3.0f;

    public static CustomEnchantment create() {
        return new CustomEnchantment().rarity(Enchantment.Rarity.RARE).category(EnchantmentCategory.ARMOR).slots((List)EquipmentSlots.ARMOR).curse().minLevelCost(level -> 10).maxLevelCost(level -> 50);
    }

    public CorrosionCurse() {
        super(MajruszsEnchantments.CORROSION, CorrosionCurse.class, true);
        OnEntityTicked.listen(this::dealDamage).addCondition(Condition.isLogicalServer()).addCondition(Condition.cooldown(() -> Float.valueOf(this.cooldown))).addCondition(data -> EnchantmentHelper.has((Supplier)this.enchantment, (LivingEntity)data.entity)).addCondition(data -> LevelHelper.isRainingAt((Level)data.getLevel(), (BlockPos)data.entity.m_20183_()) || data.entity.m_20069_());
        this.config.define("damage_dealt_per_level", Reader.number(), s -> Float.valueOf(this.damage), (s, v) -> {
            this.damage = ((Float)Range.of((Number)Float.valueOf(0.0f), (Number)Float.valueOf(10.0f)).clamp((Number)v)).floatValue();
        }).define("damage_cooldown", Reader.number(), s -> Float.valueOf(this.cooldown), (s, v) -> {
            this.cooldown = ((Float)Range.of((Number)Float.valueOf(0.05f), (Number)Float.valueOf(60.0f)).clamp((Number)v)).floatValue();
        });
    }

    private void dealDamage(OnEntityTicked data) {
        this.damageOwner(data);
        this.damageArmor(data);
    }

    private void damageOwner(OnEntityTicked data) {
        int levels = EnchantmentHelper.getLevelSum((Supplier)this.enchantment, (LivingEntity)data.entity);
        float damage = (float)levels * this.damage;
        if (damage > 0.0f) {
            data.entity.m_6469_(data.getLevel().m_269111_().m_269425_(), damage);
        }
    }

    private void damageArmor(OnEntityTicked data) {
        for (EquipmentSlot slot : ((CustomEnchantment)this.enchantment.get()).m_44684_(data.entity).keySet()) {
            ItemStack itemStack = data.entity.m_6844_(slot);
            if (!EnchantmentHelper.has((Supplier)this.enchantment, (ItemStack)itemStack)) continue;
            itemStack.m_41622_(1, data.entity, owner -> owner.m_21166_(slot));
        }
    }
}

