/*
 * Decompiled with CFR 0.152.
 */
package xxrexraptorxx.ageofweapons.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.world.item.Items;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber
public class Config {
    public static final String CATEGORY_GENERAL = "general";
    public static final String CATEGORY_NEXUS = "nexus";
    public static final String CATEGORY_ITEMS = "items";
    public static ForgeConfigSpec SERVER_CONFIG;
    public static ForgeConfigSpec CLIENT_CONFIG;
    public static ForgeConfigSpec.BooleanValue UPDATE_CHECKER;
    public static ForgeConfigSpec.BooleanValue ADD_VANILLA_ITEMS_TO_MOD_TABS;
    public static ForgeConfigSpec.BooleanValue BEDROCK_MINING_WITH_PULVERIZER;
    public static ForgeConfigSpec.BooleanValue NEXUS_EFFECT_WHEN_RIGHT_CLICKED;
    public static ForgeConfigSpec.BooleanValue ENCHANTABLE_LEGENDARY_WEAPONS;
    public static ForgeConfigSpec.BooleanValue REPAIRABLE_LEGENDARY_WEAPONS;
    public static ForgeConfigSpec.BooleanValue DISABLE_MODERN_AGES;
    public static ForgeConfigSpec.IntValue NEXUS_XP_AMOUNT;
    public static ForgeConfigSpec.IntValue NEXUS_XP_STAGE_AMOUNT;
    public static ForgeConfigSpec.ConfigValue<List<String>> NEXUS_REWARDS;
    public static ForgeConfigSpec.BooleanValue SHOW_PERKS;
    public static ForgeConfigSpec.BooleanValue SHOW_PERKS_IN_JEI;
    public static ForgeConfigSpec.BooleanValue PATREON_REWARDS;
    public static ForgeConfigSpec.IntValue BLEEDING;
    public static ForgeConfigSpec.BooleanValue SPECTATOR_MODE_AFTER_LOST_NEXUS;

    public static void init() {
        Config.initServer();
        Config.initClient();
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, (IConfigSpec)SERVER_CONFIG);
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)CLIENT_CONFIG);
    }

    public static void initClient() {
        ForgeConfigSpec.Builder builder = new ForgeConfigSpec.Builder();
        builder.comment("General").push(CATEGORY_GENERAL);
        UPDATE_CHECKER = builder.comment("Activate the Update-Checker").define("update-checker", true);
        ADD_VANILLA_ITEMS_TO_MOD_TABS = builder.comment("Enable that tools/weapons to be added to the mod tabs of the correct epoch").define("add_vanilla_items_to_mod_tabs", true);
        builder.pop();
        builder.comment("Items").push(CATEGORY_ITEMS);
        SHOW_PERKS = builder.comment("Should the weapon perks be displayed on the item tooltips?").define("show_perks", true);
        SHOW_PERKS_IN_JEI = builder.comment("Should the weapon perks be displayed in JEI?").define("show_perks_in_jei", true);
        builder.pop();
        CLIENT_CONFIG = builder.build();
    }

    public static void initServer() {
        ForgeConfigSpec.Builder builder = new ForgeConfigSpec.Builder();
        builder.comment("General").push(CATEGORY_GENERAL);
        PATREON_REWARDS = builder.comment("Enables ingame rewards on first spawn for Patreons").define("patreon_rewards", true);
        DISABLE_MODERN_AGES = builder.comment("This option disables 'modern age' and 'future' -content").define("disale_modern_ages", false);
        BLEEDING = builder.comment("The chance that normal weapons can cause the 'Bleeding'-effect [higher = rarer | 0 = disabled | 1 = everytime]").defineInRange("bleeding_chance", 20, 0, 100);
        builder.pop();
        builder.comment("Items").push(CATEGORY_ITEMS);
        BEDROCK_MINING_WITH_PULVERIZER = builder.comment("Should the Industrial Pulverizer be able to mine bedrock?").define("bedrock_mining_with_pulverizer", true);
        ENCHANTABLE_LEGENDARY_WEAPONS = builder.comment("Should Legendary weapons are enchantable?").define("enchantable_legendary_weapons", true);
        REPAIRABLE_LEGENDARY_WEAPONS = builder.comment("Should Legendary weapons are repairable?").define("repairable_legendary_weapons", false);
        builder.pop();
        builder.comment("Nexus").push(CATEGORY_NEXUS);
        NEXUS_EFFECT_WHEN_RIGHT_CLICKED = builder.comment("Should the Nexus spawn a area effect cloud with damage boost when right clicked?").define("nexus_effect_when_right_clicked", true);
        NEXUS_XP_AMOUNT = builder.comment("How many XP the Nexus drop").defineInRange("nexus_xp_amount", 500, 0, 1000);
        NEXUS_XP_STAGE_AMOUNT = builder.comment("How many XP the Nexus drop if it switches to another destruction level").defineInRange("nexus_stage_xp_amount", 50, 0, 1000);
        NEXUS_REWARDS = builder.comment("A list with all the rewards that drop when a Nexus is destroyed [amount*modid:item]").define("nexus_rewards", new ArrayList<String>(Arrays.asList("1*" + ForgeRegistries.ITEMS.getKey((Object)Items.f_42686_).toString())));
        SPECTATOR_MODE_AFTER_LOST_NEXUS = builder.comment("Should the players of a lost team put into spectator mode?").define("spectator_mode_after_lost_nexus", true);
        builder.pop();
        SERVER_CONFIG = builder.build();
    }
}

