/*
 * Decompiled with CFR 0.152.
 */
package xxrexraptorxx.ageofweapons.blocks;

import java.util.List;
import java.util.Random;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.commands.CommandSource;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.ChatType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.PlayerChatMessage;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;
import xxrexraptorxx.ageofweapons.main.AgeOfWeapons;
import xxrexraptorxx.ageofweapons.utils.Config;
import xxrexraptorxx.ageofweapons.utils.enums.NexusColors;

public class Nexus
extends Block {
    public static final Integer MAX_DESTRUCTION_LEVEL = 3;
    public static final IntegerProperty DESTRUCTION_LEVEL = IntegerProperty.m_61631_((String)"level", (int)0, (int)(MAX_DESTRUCTION_LEVEL + 1));
    public static final EnumProperty<NexusColors> COLOR = EnumProperty.m_61587_((String)"color", NexusColors.class);
    public static final EnumProperty<DoubleBlockHalf> HALF = BlockStateProperties.f_61401_;
    protected static final VoxelShape CUSTOM_SHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)32.0, (double)16.0);

    public Nexus() {
        super(BlockBehaviour.Properties.m_284310_().m_60913_(100.0f, 5000.0f).m_60918_(SoundType.f_56743_).m_284180_(MapColor.f_283821_).m_60953_(value -> 10).m_60955_().m_60999_().m_280658_(NoteBlockInstrument.DRAGON).m_278166_(PushReaction.BLOCK));
    }

    public void m_5871_(ItemStack stack, @Nullable BlockGetter level, List<Component> list, TooltipFlag flag) {
        if (!Screen.m_96638_()) {
            list.add((Component)Component.m_237115_((String)"message.ageofweapons.nexus.desc").m_130940_(ChatFormatting.GOLD));
            list.add((Component)Component.m_237115_((String)"message.ageofweapons.hold_shift.desc").m_130940_(ChatFormatting.GREEN));
        } else {
            list.add((Component)Component.m_237115_((String)"message.ageofweapons.gamemode_line_1").m_130940_(ChatFormatting.GOLD).m_130940_(ChatFormatting.UNDERLINE));
            list.add((Component)Component.m_237115_((String)"message.ageofweapons.gamemode_line_2").m_130940_(ChatFormatting.GRAY));
            list.add((Component)Component.m_237115_((String)"message.ageofweapons.gamemode_line_3").m_130940_(ChatFormatting.GRAY));
            list.add((Component)Component.m_237115_((String)"message.ageofweapons.gamemode_line_4").m_130940_(ChatFormatting.GRAY));
            list.add((Component)Component.m_237115_((String)"message.ageofweapons.gamemode_line_5").m_130940_(ChatFormatting.GRAY));
            list.add((Component)Component.m_237115_((String)"message.ageofweapons.gamemode_line_6").m_130940_(ChatFormatting.GRAY));
        }
    }

    public int getExpDrop(BlockState state, LevelReader level, RandomSource random, BlockPos pos, int fortuneLevel, int silkTouchLevel) {
        return (Integer)Config.NEXUS_XP_AMOUNT.get();
    }

    public boolean onDestroyedByPlayer(BlockState state, Level level, BlockPos pos, Player player, boolean willHarvest, FluidState fluid) {
        Random random = new Random();
        String nexusColor = ForgeRegistries.BLOCKS.getKey((Object)this).toString().substring(19);
        ItemStack stack = player.m_21211_();
        if (!level.f_46443_) {
            if (player.m_7500_()) {
                Nexus.changeNexusBlockstates(level, pos, state, null, true);
                if (level.m_6188_().m_83474_().contains(nexusColor.toUpperCase() + "_NEXUS")) {
                    level.m_6188_().m_83502_(level.m_6188_().m_83477_(nexusColor.toUpperCase() + "_NEXUS"));
                }
            } else {
                Nexus.nexusLevelChange(false, level, state, pos, stack, player);
                if (state.m_61143_((Property)DESTRUCTION_LEVEL) == MAX_DESTRUCTION_LEVEL) {
                    Nexus.changeNexusBlockstates(level, pos, state, null, true);
                    level.m_6263_((Player)null, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), SoundEvents.f_11664_, SoundSource.BLOCKS, 0.5f, 0.4f / (random.nextFloat() * 0.4f + 0.8f));
                    level.m_6263_((Player)null, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), SoundEvents.f_11891_, SoundSource.BLOCKS, 0.5f, 0.4f / (random.nextFloat() * 0.4f + 0.8f));
                    this.m_49805_(level.m_7654_().m_129880_(player.m_9236_().m_46472_()), pos, (Integer)Config.NEXUS_XP_AMOUNT.get());
                    player.m_36246_(Stats.f_12949_.m_12902_((Object)state.m_60734_()));
                    CommandSourceStack source = new CommandSourceStack(CommandSource.f_80164_, Vec3.m_82512_((Vec3i)pos), Vec2.f_82462_, (ServerLevel)level, 2, "nexus", (Component)Component.m_237113_((String)"Nexus").m_130940_(ChatFormatting.m_126657_((String)nexusColor)), level.m_7654_(), (Entity)player);
                    if (player.m_5647_() != null && player.m_5647_().m_7414_() != null) {
                        level.m_7654_().m_6846_().m_240416_((Component)Component.m_237113_((String)(player.m_5446_().getString() + " ")).m_130940_(player.m_5647_().m_7414_()).m_7220_((Component)Component.m_237115_((String)"message.ageofweapons.nexus_destruction").m_130940_(ChatFormatting.m_126657_((String)nexusColor))), true);
                        level.m_7654_().m_6846_().m_243063_(PlayerChatMessage.m_247306_((String)Component.m_237113_((String)(player.m_5446_().getString() + " ")).m_130940_(player.m_5647_().m_7414_()).m_7220_((Component)Component.m_237115_((String)"message.ageofweapons.nexus_destruction").m_130940_(ChatFormatting.m_126657_((String)nexusColor))).getString()), source, ChatType.m_241073_((ResourceKey)ChatType.f_130598_, (CommandSourceStack)source));
                    } else {
                        level.m_7654_().m_6846_().m_240416_((Component)Component.m_237113_((String)(player.m_5446_().getString() + " ")).m_7220_((Component)Component.m_237115_((String)"message.ageofweapons.nexus_destruction").m_130940_(ChatFormatting.m_126657_((String)nexusColor))), true);
                        level.m_7654_().m_6846_().m_243063_(PlayerChatMessage.m_247306_((String)Component.m_237113_((String)(player.m_5446_().getString() + " ")).m_7220_((Component)Component.m_237115_((String)"message.ageofweapons.nexus_destruction").m_130940_(ChatFormatting.m_126657_((String)nexusColor))).getString()), source, ChatType.m_241073_((ResourceKey)ChatType.f_130598_, (CommandSourceStack)source));
                    }
                    if (((Boolean)Config.SPECTATOR_MODE_AFTER_LOST_NEXUS.get()).booleanValue()) {
                        try {
                            List players = level.m_7654_().m_6846_().m_11314_();
                            for (ServerPlayer serverPlayer : players) {
                                if (serverPlayer.m_5647_().m_7414_() != ChatFormatting.m_126657_((String)nexusColor)) continue;
                                serverPlayer.m_143403_(GameType.SPECTATOR);
                            }
                        }
                        catch (Exception e) {
                            AgeOfWeapons.LOGGER.error((Object)e);
                            AgeOfWeapons.LOGGER.error("To avoid this error, please add all players to a team and assign compatible colors to the teams!");
                        }
                    }
                    if (((List)Config.NEXUS_REWARDS.get()).size() > 0) {
                        for (String item : (List)Config.NEXUS_REWARDS.get()) {
                            try {
                                ItemEntity drop = new ItemEntity(level, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 1.5, (double)pos.m_123343_() + 0.5, new ItemStack((ItemLike)ForgeRegistries.ITEMS.getValue(new ResourceLocation(item.substring(item.indexOf(42) + 1, item.indexOf(58)), item.substring(item.indexOf(58) + 1))), Integer.parseInt(item.substring(0, item.indexOf(42)))));
                                level.m_7967_((Entity)drop);
                            }
                            catch (Exception e) {
                                AgeOfWeapons.LOGGER.error("Invalid item entry in the Age of Weapons Mod 'nexus_rewards' config option!");
                            }
                        }
                    }
                    if (level.m_6188_().m_83474_().contains(nexusColor.toUpperCase() + "_NEXUS")) {
                        level.m_6188_().m_83502_(level.m_6188_().m_83477_(nexusColor.toUpperCase() + "_NEXUS"));
                    }
                }
            }
        }
        return false;
    }

    public static void nexusLevelChange(Boolean positive, Level level, BlockState state, BlockPos pos, ItemStack stack, Player player) {
        String nexusColor = ForgeRegistries.BLOCKS.getKey((Object)state.m_60734_()).toString().substring(19);
        Random random = new Random();
        if (!positive.booleanValue()) {
            Nexus.changeNexusBlockstates(level, pos, state, false, false);
            level.m_6263_((Player)null, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), SoundEvents.f_11665_, SoundSource.BLOCKS, 0.5f, 0.4f / (random.nextFloat() * 0.4f + 0.8f));
            state.m_60734_().m_49805_(level.m_7654_().m_129880_(player.m_9236_().m_46472_()), pos, ((Integer)Config.NEXUS_XP_STAGE_AMOUNT.get()).intValue());
            player.m_36246_(Stats.f_12983_.m_12902_((Object)state.m_60734_().m_5456_()));
            if (state.m_61143_((Property)DESTRUCTION_LEVEL) != MAX_DESTRUCTION_LEVEL) {
                CommandSourceStack source = new CommandSourceStack(CommandSource.f_80164_, Vec3.m_82512_((Vec3i)pos), Vec2.f_82462_, (ServerLevel)level, 2, "nexus", (Component)Component.m_237113_((String)"Nexus").m_130940_(ChatFormatting.m_126657_((String)nexusColor)), level.m_7654_(), (Entity)player);
                level.m_7654_().m_6846_().m_240416_((Component)Component.m_237115_((String)("message.ageofweapons.nexus_level_" + ((Integer)state.m_61143_((Property)DESTRUCTION_LEVEL) + 1))).m_130940_(ChatFormatting.m_126657_((String)nexusColor)), true);
                level.m_7654_().m_6846_().m_243063_(PlayerChatMessage.m_247306_((String)Component.m_237115_((String)("message.ageofweapons.nexus_level_" + ((Integer)state.m_61143_((Property)DESTRUCTION_LEVEL) + 1))).m_130940_(ChatFormatting.m_126657_((String)nexusColor)).getString()), source, ChatType.m_241073_((ResourceKey)ChatType.f_130598_, (CommandSourceStack)source));
            }
        }
    }

    private static void changeNexusBlockstates(Level level, BlockPos pos, BlockState state, @Nullable Boolean positive, Boolean destroyed) {
        if (destroyed.booleanValue()) {
            if (state.m_61143_(HALF) == DoubleBlockHalf.LOWER) {
                level.m_7731_(pos, Blocks.f_50016_.m_49966_(), 11);
                level.m_7731_(pos.m_7494_(), Blocks.f_50016_.m_49966_(), 11);
            } else {
                level.m_7731_(pos, Blocks.f_50016_.m_49966_(), 11);
                level.m_7731_(pos.m_7495_(), Blocks.f_50016_.m_49966_(), 11);
            }
        } else if (positive.booleanValue()) {
            if (state.m_61143_(HALF) == DoubleBlockHalf.LOWER) {
                level.m_7731_(pos, (BlockState)((BlockState)state.m_61124_((Property)DESTRUCTION_LEVEL, (Comparable)Integer.valueOf((Integer)state.m_61143_((Property)DESTRUCTION_LEVEL) - 1))).m_61124_(HALF, (Comparable)DoubleBlockHalf.LOWER), 11);
                level.m_7731_(pos.m_7494_(), (BlockState)((BlockState)state.m_61124_((Property)DESTRUCTION_LEVEL, (Comparable)Integer.valueOf((Integer)state.m_61143_((Property)DESTRUCTION_LEVEL) - 1))).m_61124_(HALF, (Comparable)DoubleBlockHalf.UPPER), 11);
            } else {
                level.m_7731_(pos, (BlockState)((BlockState)state.m_61124_((Property)DESTRUCTION_LEVEL, (Comparable)Integer.valueOf((Integer)state.m_61143_((Property)DESTRUCTION_LEVEL) - 1))).m_61124_(HALF, (Comparable)DoubleBlockHalf.UPPER), 11);
                level.m_7731_(pos.m_7495_(), (BlockState)((BlockState)state.m_61124_((Property)DESTRUCTION_LEVEL, (Comparable)Integer.valueOf((Integer)state.m_61143_((Property)DESTRUCTION_LEVEL) - 1))).m_61124_(HALF, (Comparable)DoubleBlockHalf.LOWER), 11);
            }
        } else if (state.m_61143_(HALF) == DoubleBlockHalf.LOWER) {
            level.m_7731_(pos, (BlockState)((BlockState)state.m_61124_((Property)DESTRUCTION_LEVEL, (Comparable)Integer.valueOf((Integer)state.m_61143_((Property)DESTRUCTION_LEVEL) + 1))).m_61124_(HALF, (Comparable)DoubleBlockHalf.LOWER), 11);
            level.m_7731_(pos.m_7494_(), (BlockState)((BlockState)state.m_61124_((Property)DESTRUCTION_LEVEL, (Comparable)Integer.valueOf((Integer)state.m_61143_((Property)DESTRUCTION_LEVEL) + 1))).m_61124_(HALF, (Comparable)DoubleBlockHalf.UPPER), 11);
        } else {
            level.m_7731_(pos, (BlockState)((BlockState)state.m_61124_((Property)DESTRUCTION_LEVEL, (Comparable)Integer.valueOf((Integer)state.m_61143_((Property)DESTRUCTION_LEVEL) + 1))).m_61124_(HALF, (Comparable)DoubleBlockHalf.UPPER), 11);
            level.m_7731_(pos.m_7495_(), (BlockState)((BlockState)state.m_61124_((Property)DESTRUCTION_LEVEL, (Comparable)Integer.valueOf((Integer)state.m_61143_((Property)DESTRUCTION_LEVEL) + 1))).m_61124_(HALF, (Comparable)DoubleBlockHalf.LOWER), 11);
        }
    }

    private static ChatFormatting getTeamColor(Player player) {
        if (player.m_5647_() != null) {
            return player.m_5647_().m_7414_();
        }
        return ChatFormatting.WHITE;
    }

    public VoxelShape m_5939_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return CUSTOM_SHAPE;
    }

    public void m_214162_(BlockState state, Level level, BlockPos pos, RandomSource random) {
        if (random.m_188500_() < 0.15) {
            level.m_7785_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), SoundEvents.f_12053_, SoundSource.BLOCKS, 0.8f, 1.0f, false);
        }
        for (int i = 0; i < 3; ++i) {
            double x0 = (double)pos.m_123341_() + random.m_188500_();
            double x1 = (double)pos.m_123342_() + random.m_188500_() * 0.5 + 1.8;
            double x2 = (double)pos.m_123343_() + random.m_188500_();
            double d0 = (double)pos.m_123341_() + random.m_188500_();
            double d1 = (double)pos.m_123342_() + random.m_188500_() * 0.5 + 0.5;
            double d2 = (double)pos.m_123343_() + random.m_188500_();
            if (((Integer)state.m_61143_((Property)DESTRUCTION_LEVEL)).equals(1)) {
                level.m_7106_((ParticleOptions)ParticleTypes.f_123762_, d0, d1, d2, 0.0, 0.0, 0.0);
            } else if (((Integer)state.m_61143_((Property)DESTRUCTION_LEVEL)).equals(2)) {
                level.m_7106_((ParticleOptions)ParticleTypes.f_123762_, d0, d1, d2, 0.0, 0.0, 0.0);
                level.m_7106_((ParticleOptions)ParticleTypes.f_123755_, d0, d1, d2, 0.0, 0.0, 0.0);
            } else if (((Integer)state.m_61143_((Property)DESTRUCTION_LEVEL)).equals(3)) {
                level.m_7106_((ParticleOptions)ParticleTypes.f_123755_, d0, d1, d2, 0.0, 0.0, 0.0);
            }
            level.m_7106_((ParticleOptions)ParticleTypes.f_123797_, x0, x1, x2, 0.0, 0.0, 0.0);
        }
        double d0 = (double)pos.m_123341_() - 4.0 + (double)random.m_188503_(8);
        double d1 = (double)pos.m_123342_() + (double)random.m_188503_(5);
        double d2 = (double)pos.m_123343_() - 4.0 + (double)random.m_188503_(8);
        level.m_7106_((ParticleOptions)ParticleTypes.f_175827_, d0, d1, d2, 0.0, 0.0, 0.0);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{DESTRUCTION_LEVEL}).m_61104_(new Property[]{HALF}).m_61104_(new Property[]{COLOR});
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)DESTRUCTION_LEVEL, (Comparable)Integer.valueOf(0))).m_61124_(HALF, (Comparable)DoubleBlockHalf.LOWER)).m_61124_(COLOR, (Comparable)((Object)NexusColors.valueOf(ForgeRegistries.BLOCKS.getKey((Object)this).toString().substring(19).toUpperCase())));
    }

    public void m_5707_(Level level, BlockPos pos, BlockState state, Player player) {
        if (!level.f_46443_ && player.m_7500_()) {
            Nexus.preventCreativeDropFromBottomPart(level, pos, state, player);
        }
        super.m_5707_(level, pos, state, player);
    }

    protected static void preventCreativeDropFromBottomPart(Level pLevel, BlockPos pPos, BlockState pState, Player pPlayer) {
        BlockPos blockpos;
        BlockState blockstate;
        DoubleBlockHalf doubleblockhalf = (DoubleBlockHalf)pState.m_61143_(HALF);
        if (doubleblockhalf == DoubleBlockHalf.UPPER && (blockstate = pLevel.m_8055_(blockpos = pPos.m_7495_())).m_60713_(pState.m_60734_()) && blockstate.m_61143_(HALF) == DoubleBlockHalf.LOWER) {
            BlockState blockstate1 = blockstate.m_60819_().m_192917_((Fluid)Fluids.f_76193_) ? Blocks.f_49990_.m_49966_() : Blocks.f_50016_.m_49966_();
            pLevel.m_7731_(blockpos, blockstate1, 35);
            pLevel.m_5898_(pPlayer, 2001, blockpos, Block.m_49956_((BlockState)blockstate));
        }
    }

    public boolean m_7898_(BlockState pState, LevelReader pLevel, BlockPos pPos) {
        BlockPos blockpos = pPos.m_7495_();
        BlockState blockstate = pLevel.m_8055_(blockpos);
        return pState.m_61143_(HALF) == DoubleBlockHalf.LOWER ? blockstate.m_60783_((BlockGetter)pLevel, blockpos, Direction.UP) : blockstate.m_60713_((Block)this);
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        level.m_7731_(pos.m_7494_(), (BlockState)state.m_61124_(HALF, (Comparable)DoubleBlockHalf.UPPER), 3);
    }
}

