/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.craftingtweaks.config;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.blay09.mods.balm.api.config.BalmConfigData;
import net.blay09.mods.balm.api.config.Comment;
import net.blay09.mods.balm.api.config.Config;
import net.blay09.mods.balm.api.config.ExpectedType;
import net.blay09.mods.craftingtweaks.config.CraftingTweaksMode;

@Config(value="craftingtweaks")
public class CraftingTweaksConfigData
implements BalmConfigData {
    public Common common = new Common();
    public Client client = new Client();

    public CraftingTweaksMode getCraftingTweaksMode(String modId) {
        if (this.client.disabledAddons.contains(modId)) {
            return CraftingTweaksMode.DISABLED;
        }
        return this.client.mode;
    }

    public static class Common {
        @Comment(value="Set this to false if you want the (de)compress feature to work outside of crafting GUIs (only works if installed on server while in the player inventory)")
        public boolean compressRequiresCraftingGrid = true;
        @ExpectedType(value=String.class)
        @Comment(value="A list of modid:name entries that will not be crafted by the compress key.")
        public List<String> compressDenylist = Arrays.asList("minecraft:sandstone", "minecraft:iron_trapdoor");
    }

    public static class Client {
        @Comment(value="If set to true, right-clicking the result slot in a crafting table will craft a full stack.")
        public boolean rightClickCraftsStack = true;
        @Comment(value="We both know JEI is much better. This option hides Vanilla's crafting book button instead of moving it.")
        public boolean hideVanillaCraftingGuide = false;
        @Comment(value="Use an alternative client-side balancing algorithm. It might be faster, or it might be slower, depending on the input. Try it if regular client-side balancing is causing lagspikes.")
        public boolean hyperOptimizedClientsideBalancing = false;
        @Comment(value="Set to 'DEFAULT' to enable both buttons and hotkeys. Set to 'BUTTONS' to enable buttons only. Set to 'HOTKEYS' to enable hotkeys only. Set to 'DISABLED' to disable completely.")
        public CraftingTweaksMode mode = CraftingTweaksMode.DEFAULT;
        @ExpectedType(value=String.class)
        @Comment(value="Add mod ids here of mods that you wish to disable Crafting Tweaks support for.")
        public List<String> disabledAddons = new ArrayList<String>();
    }
}

