/*
 * Decompiled with CFR 0.152.
 */
package dev.foxgirl.trimeffects;

import com.google.common.collect.ImmutableSet;
import com.mojang.serialization.DynamicOps;
import dev.foxgirl.trimeffects.Config;
import it.unimi.dsi.fastutil.objects.ObjectArraySet;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.armortrim.ArmorTrim;
import net.minecraft.world.item.armortrim.TrimMaterial;
import net.minecraft.world.item.armortrim.TrimPattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TrimEffects2 {
    public static final Logger LOGGER = LogManager.getLogger((String)"trimeffects");
    public static final TrimEffects2 INSTANCE = new TrimEffects2();
    public static final int STATUS_EFFECT_DURATION_MARKER = -75915;
    public Config config;
    @NotNull
    private final IdentifierToEffectSetMapping configEffectsMapping = new IdentifierToEffectSetMapping(){

        @Override
        protected void printWarningForMissingKey(String keyString) {
            LOGGER.warn("(TrimsEffects) Config is missing an effect for trim pattern \"{}\", consider adding it!", (Object)keyString);
        }

        @Override
        protected void printWarningForInvalidEffect(String effectString) {
            LOGGER.warn("(TrimsEffects) Config has an unknown/invalid effect \"{}\", check your spelling", (Object)effectString);
        }

        @Override
        protected Map<String, List<String>> getUnderlyingConfigValue() {
            return TrimEffects2.this.config.effects;
        }
    };
    @NotNull
    private final IdentifierToEffectSetMapping configMaterialEffectOverridesMapping = new IdentifierToEffectSetMapping(){

        @Override
        protected void printWarningForMissingKey(String keyString) {
        }

        @Override
        protected void printWarningForInvalidEffect(String effectString) {
            LOGGER.warn("(TrimsEffects) Config has an unknown/invalid effect \"{}\" in materialEffectOverrides, check your spelling", (Object)effectString);
        }

        @Override
        protected Map<String, List<String>> getUnderlyingConfigValue() {
            return TrimEffects2.this.config.materialEffectOverrides;
        }
    };
    private final Map<UUID, AbsorptionRecord> absorptionRecords = new HashMap<UUID, AbsorptionRecord>();

    private TrimEffects2() {
    }

    public void initialize(@NotNull Path directory) {
        this.config = Config.read(directory);
    }

    @NotNull
    public static RegistryAccess getRegistryManager(@NotNull Entity entity) {
        return entity.m_9236_().m_9598_();
    }

    @NotNull
    public static Registry<MobEffect> getStatusEffectRegistry(@NotNull RegistryAccess manager) {
        return manager.m_175515_(Registries.f_256929_);
    }

    public static Registry<MobEffect> getStatusEffectRegistry(@NotNull Entity entity) {
        return TrimEffects2.getStatusEffectRegistry(TrimEffects2.getRegistryManager(entity));
    }

    @NotNull
    public static <T> ResourceKey<T> getRegistryKey(@NotNull Holder<T> entry) {
        return (ResourceKey)entry.m_203543_().orElseThrow();
    }

    @NotNull
    public static <T> RegistryEntryGetter<T> toRegistryEntryGetter(@NotNull Registry<T> registry) {
        return id -> {
            Optional entry = registry.m_203636_(ResourceKey.m_135785_((ResourceKey)registry.m_123023_(), (ResourceLocation)id));
            return entry.isPresent() ? Optional.of((Holder)entry.get()) : Optional.empty();
        };
    }

    @NotNull
    public static <T> RegistryEntryGetter<T> toRegistryEntryGetter(@NotNull HolderLookup<T> wrapper) {
        return id -> {
            ResourceKey registryKey = ((HolderLookup.RegistryLookup)wrapper).m_254879_();
            ResourceKey entryKey = ResourceKey.m_135785_((ResourceKey)registryKey, (ResourceLocation)id);
            Optional entry = wrapper.m_254902_(entryKey);
            return entry.isPresent() ? Optional.of((Holder)entry.get()) : Optional.empty();
        };
    }

    @Nullable
    public static ArmorTrim getArmorTrimFromItemStack(@NotNull RegistryAccess manager, @NotNull ItemStack stack) {
        CompoundTag nbt = stack.m_41737_("Trim");
        if (nbt == null || !stack.m_204117_(ItemTags.f_265942_)) {
            return null;
        }
        return ArmorTrim.f_265985_.parse((DynamicOps)RegistryOps.m_255058_((DynamicOps)NbtOps.f_128958_, (HolderLookup.Provider)manager), (Object)nbt).result().orElse(null);
    }

    public static void setStatusEffectDuration(@NotNull MobEffectInstance instance, int duration) {
        ((DurationSetter)instance).trimeffects$setDuration(duration);
    }

    @NotNull
    private @NotNull Set<@NotNull Holder<MobEffect>> collectEffectsForPatternAndMaterial(@NotNull RegistryEntryGetter<MobEffect> registry, @NotNull ResourceKey<TrimMaterial> materialKey, @NotNull ResourceKey<TrimPattern> patternKey) {
        Set<Holder<MobEffect>> effectsOverridden = this.configMaterialEffectOverridesMapping.collectEffectsForKey(registry, materialKey.m_135782_());
        if (!effectsOverridden.isEmpty()) {
            return effectsOverridden;
        }
        return this.configEffectsMapping.collectEffectsForKey(registry, patternKey.m_135782_());
    }

    @Nullable
    public TrimDetails createTrimDetails(@NotNull RegistryEntryGetter<MobEffect> registry, @NotNull ArmorTrim trim) {
        ResourceKey patternKey;
        ResourceKey materialKey = TrimEffects2.getRegistryKey(trim.m_266210_());
        Set<Holder<MobEffect>> effects = this.collectEffectsForPatternAndMaterial(registry, materialKey, patternKey = TrimEffects2.getRegistryKey(trim.m_266429_()));
        if (effects.isEmpty()) {
            return null;
        }
        return new TrimDetails(trim, materialKey, patternKey, effects);
    }

    private boolean shouldApplyToEntity(@NotNull LivingEntity entity) {
        if (this.config.applyToMobs) {
            return true;
        }
        return entity instanceof Player;
    }

    public void onLivingEntityTick(@NotNull LivingEntity entity) {
        if (!this.shouldApplyToEntity(entity)) {
            this.removeEffectsFromTrims(entity, null);
            return;
        }
        RegistryAccess manager = TrimEffects2.getRegistryManager((Entity)entity);
        Registry<MobEffect> registry = null;
        ArrayList<TrimDetails> trims = null;
        for (ItemStack stack : entity.m_6168_()) {
            TrimDetails details;
            ArmorTrim trim = TrimEffects2.getArmorTrimFromItemStack(manager, stack);
            if (trim == null) continue;
            if (registry == null) {
                registry = TrimEffects2.getStatusEffectRegistry(manager);
            }
            if ((details = this.createTrimDetails(TrimEffects2.toRegistryEntryGetter(registry), trim)) == null) continue;
            if (trims == null) {
                trims = new ArrayList<TrimDetails>(4);
            }
            trims.add(details);
        }
        if (trims != null && !trims.isEmpty()) {
            this.updateEffectsWithTrimDetails(entity, (List<TrimDetails>)trims);
        } else {
            this.removeEffectsFromTrims(entity, null);
        }
    }

    private int getConfigMatchingEffectLevel(int index) {
        List<Integer> matchingEffectLevels = this.config.matchingEffectLevels;
        if (matchingEffectLevels.isEmpty()) {
            return -1;
        }
        if (index < 0) {
            return matchingEffectLevels.get(0);
        }
        if (index >= matchingEffectLevels.size()) {
            return matchingEffectLevels.get(matchingEffectLevels.size() - 1);
        }
        return matchingEffectLevels.get(index);
    }

    private int getConfigMaterialEffectLevel(@NotNull ResourceLocation key) {
        Map<String, Integer> materialEffectLevels = this.config.materialEffectLevels;
        if (materialEffectLevels.isEmpty()) {
            return -1;
        }
        String keyPathString = key.m_135815_();
        String keyFullString = key.toString();
        for (Map.Entry<String, Integer> entry : materialEffectLevels.entrySet()) {
            String entryKeyString = entry.getKey();
            if (!keyPathString.equalsIgnoreCase(entryKeyString) && !keyFullString.equalsIgnoreCase(entryKeyString)) continue;
            return entry.getValue();
        }
        return -1;
    }

    private List<EffectDetails> collectEffectDetails(List<TrimDetails> trims) {
        ArrayList<EffectDetails> effects = new ArrayList<EffectDetails>(trims.size());
        for (TrimDetails trimDetails : trims) {
            for (Holder<MobEffect> effect : trimDetails.effects()) {
                ResourceKey<MobEffect> effectKey = TrimEffects2.getRegistryKey(effect);
                boolean exists = false;
                for (EffectDetails effectDetails : effects) {
                    if (!effectDetails.effectKey.equals(effectKey)) continue;
                    effectDetails.trySetMaterial(trimDetails.materialKey());
                    effectDetails.incrementCount();
                    exists = true;
                    break;
                }
                if (exists) continue;
                effects.add(new EffectDetails(effect, effectKey, trimDetails.materialKey()));
            }
        }
        effects.removeIf(EffectDetails::shouldBeIgnored);
        return effects;
    }

    public static boolean shouldOmitFromTooltip(TrimDetails trimDetails) {
        return trimDetails.effects().stream().allMatch(details -> new EffectDetails((Holder<MobEffect>)details, trimDetails.materialKey()).shouldBeOmmittedFromTooltip());
    }

    private boolean isAbsorption(Holder<MobEffect> effect) {
        return MobEffects.f_19617_.equals(effect.m_203334_());
    }

    private boolean isAbsorptionStunned(LivingEntity entity, MobEffectInstance instance) {
        AbsorptionRecord absorptionRecord = this.absorptionRecords.computeIfAbsent(entity.m_20148_(), uuid -> new AbsorptionRecord());
        float currentAbsorptionAmount = entity.m_6103_();
        float previousAbsorptionAmount = absorptionRecord.previousAmount;
        absorptionRecord.previousAmount = currentAbsorptionAmount;
        if (absorptionRecord.stunTicks > 0) {
            --absorptionRecord.stunTicks;
            return true;
        }
        if (instance != null && instance.m_267577_() && currentAbsorptionAmount < previousAbsorptionAmount) {
            int stunDurationInTicks;
            absorptionRecord.stunTicks = stunDurationInTicks = (int)(this.config.absorptionStunSeconds * 20.0);
            TrimEffects2.setStatusEffectDuration(instance, stunDurationInTicks);
            return true;
        }
        return false;
    }

    private void updateEffectsWithTrimDetails(LivingEntity entity, List<TrimDetails> trims) {
        List<EffectDetails> effects = this.collectEffectDetails(trims);
        for (EffectDetails effectDetails : effects) {
            MobEffectInstance instance = entity.m_21124_((MobEffect)effectDetails.effect.m_203334_());
            if (this.isAbsorption(effectDetails.effect) && this.isAbsorptionStunned(entity, instance)) continue;
            if (instance == null) {
                entity.m_147207_(effectDetails.createStatusEffectInstance(), (Entity)entity);
                continue;
            }
            if (instance.m_19557_() == -75915 ? instance.m_19564_() == effectDetails.getAmplifier() : instance.m_19564_() >= effectDetails.getAmplifier()) continue;
            entity.m_21195_((MobEffect)effectDetails.effect.m_203334_());
            entity.m_147207_(effectDetails.createStatusEffectInstance(), (Entity)entity);
        }
        this.removeEffectsFromTrims(entity, effects);
    }

    private boolean isEffectExcluded(List<EffectDetails> excludedEffects, Holder<MobEffect> effect) {
        ResourceKey<MobEffect> effectKey = TrimEffects2.getRegistryKey(effect);
        for (EffectDetails effectDetails : excludedEffects) {
            if (!effectKey.equals(effectDetails.effectKey)) continue;
            return true;
        }
        return false;
    }

    private void removeEffectsFromTrims(LivingEntity entity, @Nullable List<EffectDetails> excludedEffects) {
        ObjectArraySet effectsToRemove = null;
        for (MobEffectInstance instance : entity.m_21220_()) {
            if (instance.m_19557_() != -75915) continue;
            Holder effect = BuiltInRegistries.f_256974_.m_263177_((Object)instance.m_19544_());
            if (excludedEffects != null && this.isEffectExcluded(excludedEffects, (Holder<MobEffect>)effect)) continue;
            if (effectsToRemove == null) {
                effectsToRemove = new ObjectArraySet(2);
            }
            effectsToRemove.add((Object)effect);
        }
        if (effectsToRemove != null) {
            for (Holder effect : effectsToRemove) {
                entity.m_21195_((MobEffect)effect.m_203334_());
            }
        }
    }

    private static abstract class IdentifierToEffectSetMapping {
        private static final ResourceLocation[] EMPTY_EFFECT_IDS = new ResourceLocation[0];
        private final Map<ResourceLocation, ResourceLocation[]> keyToEffectsCache = new HashMap<ResourceLocation, ResourceLocation[]>();
        private final Set<String> missingKeys = new HashSet<String>();
        private final Set<String> invalidEffects = new HashSet<String>();

        private IdentifierToEffectSetMapping() {
        }

        private static Holder<MobEffect>[] createStatusEffectArray(int length) {
            return new Holder[length];
        }

        private Set<Holder<MobEffect>> lookupEffectsInCache(RegistryEntryGetter<MobEffect> registry, ResourceLocation key) {
            ResourceLocation[] effectIDs = this.keyToEffectsCache.get(key);
            if (effectIDs == null) {
                return null;
            }
            int length = effectIDs.length;
            if (length == 0) {
                return ImmutableSet.of();
            }
            Object[] effects = IdentifierToEffectSetMapping.createStatusEffectArray(length);
            for (int i = 0; i < length; ++i) {
                Optional<Holder<MobEffect>> effect = registry.getEntry(effectIDs[i]);
                if (!effect.isPresent()) {
                    this.keyToEffectsCache.remove(key);
                    return null;
                }
                effects[i] = effect.get();
            }
            return new ObjectArraySet(effects);
        }

        private void storeEffectsInCache(ResourceLocation key, @Nullable Set<ResourceLocation> effectIDs) {
            this.keyToEffectsCache.put(key, effectIDs != null ? effectIDs.toArray(EMPTY_EFFECT_IDS) : EMPTY_EFFECT_IDS);
        }

        private void warnMissingKey(String keyString) {
            if (this.missingKeys.add(keyString)) {
                this.printWarningForMissingKey(keyString);
            }
        }

        private void warnInvalidEffect(String effectString) {
            if (this.invalidEffects.add(effectString)) {
                this.printWarningForInvalidEffect(effectString);
            }
        }

        protected abstract void printWarningForMissingKey(String var1);

        protected abstract void printWarningForInvalidEffect(String var1);

        protected abstract Map<String, List<String>> getUnderlyingConfigValue();

        @NotNull
        public final @NotNull Set<@NotNull Holder<MobEffect>> collectEffectsForKey(@NotNull RegistryEntryGetter<MobEffect> registry, @NotNull ResourceLocation key) {
            Set<Holder<MobEffect>> cachedEffects = this.lookupEffectsInCache(registry, key);
            if (cachedEffects != null) {
                return cachedEffects;
            }
            String keyPathString = key.m_135815_();
            String keyFullString = key.toString();
            for (Map.Entry<String, List<String>> entry : this.getUnderlyingConfigValue().entrySet()) {
                String entryKeyString = entry.getKey();
                if (!keyPathString.equalsIgnoreCase(entryKeyString) && !keyFullString.equalsIgnoreCase(entryKeyString)) continue;
                List<String> effectStrings = entry.getValue();
                if (effectStrings == null) {
                    return ImmutableSet.of();
                }
                if (effectStrings.isEmpty()) {
                    this.storeEffectsInCache(key, null);
                    return ImmutableSet.of();
                }
                int size = effectStrings.size();
                boolean invalid = false;
                ObjectArraySet effectIDs = new ObjectArraySet((Object[])new ResourceLocation[size], 0);
                Object[] effects = IdentifierToEffectSetMapping.createStatusEffectArray(size);
                for (String effectString : effectStrings) {
                    ResourceLocation effectID = ResourceLocation.m_135820_((String)effectString);
                    if (effectID == null) {
                        this.warnInvalidEffect(effectString);
                        invalid = true;
                        continue;
                    }
                    Optional<Holder<MobEffect>> effect = registry.getEntry(effectID);
                    if (effect.isEmpty()) {
                        this.warnInvalidEffect(effectString);
                        invalid = true;
                        continue;
                    }
                    if (!effectIDs.add((Object)effectID)) continue;
                    effects[effectIDs.size() - 1] = effect.get();
                }
                if (!invalid) {
                    this.storeEffectsInCache(key, (Set<ResourceLocation>)effectIDs);
                }
                return new ObjectArraySet(effects, effectIDs.size());
            }
            this.warnMissingKey(keyFullString);
            return ImmutableSet.of();
        }
    }

    @FunctionalInterface
    public static interface RegistryEntryGetter<T> {
        @NotNull
        public @NotNull Optional<@NotNull Holder<T>> getEntry(@NotNull ResourceLocation var1);
    }

    public static interface DurationSetter {
        public void trimeffects$setDuration(int var1);
    }

    public record TrimDetails(@NotNull ArmorTrim trim, @NotNull ResourceKey<TrimMaterial> materialKey, @NotNull ResourceKey<TrimPattern> patternKey, @NotNull Set<Holder<MobEffect>> effects) {
    }

    private static final class EffectDetails {
        public final Holder<MobEffect> effect;
        public final ResourceKey<MobEffect> effectKey;
        private ResourceKey<TrimMaterial> materialKey;
        private int materialLevel = -1;
        public int count;
        public int amplifier = -2;

        public EffectDetails(Holder<MobEffect> effect, ResourceKey<MobEffect> effectKey, ResourceKey<TrimMaterial> materialKey) {
            this.effect = effect;
            this.effectKey = effectKey;
            this.trySetMaterial(materialKey);
        }

        public EffectDetails(Holder<MobEffect> effect, ResourceKey<TrimMaterial> materialKey) {
            this(effect, TrimEffects2.getRegistryKey(effect), materialKey);
        }

        private static int getConfigMaterialEffectLevel(ResourceKey<TrimMaterial> materialKey) {
            return INSTANCE.getConfigMaterialEffectLevel(materialKey.m_135782_());
        }

        private int getConfigMaterialEffectLevel() {
            return this.materialKey != null ? EffectDetails.getConfigMaterialEffectLevel(this.materialKey) : -1;
        }

        private int getConfigMatchingEffectLevel() {
            return INSTANCE.getConfigMatchingEffectLevel(this.count);
        }

        private int getConfigMaterialMinimumMatching() {
            return TrimEffects2.INSTANCE.config.materialEffectLevelsMinimumMatching;
        }

        public void trySetMaterial(ResourceKey<TrimMaterial> materialKey) {
            int oldLevel = this.getConfigMaterialEffectLevel();
            int newLevel = EffectDetails.getConfigMaterialEffectLevel(materialKey);
            if (newLevel > oldLevel) {
                this.materialKey = materialKey;
                this.materialLevel = this.getConfigMaterialEffectLevel();
                this.amplifier = -2;
            }
        }

        public void incrementCount() {
            ++this.count;
            this.amplifier = -2;
        }

        public int getAmplifier() {
            if (this.amplifier >= -1) {
                return this.amplifier;
            }
            if (this.materialLevel >= 0) {
                this.amplifier = this.count + 1 >= this.getConfigMaterialMinimumMatching() ? Math.max(this.materialLevel - 1, -1) : -1;
                return this.amplifier;
            }
            int level = this.getConfigMatchingEffectLevel();
            if (level >= 0) {
                this.amplifier = Math.max(level - 1, -1);
                return this.amplifier;
            }
            this.amplifier = -1;
            return this.amplifier;
        }

        public boolean shouldBeIgnored() {
            return this.getAmplifier() < 0;
        }

        public boolean shouldBeOmmittedFromTooltip() {
            return this.materialLevel == 0;
        }

        public MobEffectInstance createStatusEffectInstance() {
            return new MobEffectInstance((MobEffect)this.effect.m_203334_(), -75915, Math.max(this.getAmplifier(), 0));
        }
    }

    private static final class AbsorptionRecord {
        private float previousAmount;
        private int stunTicks;

        private AbsorptionRecord() {
        }
    }
}

