/*
 * Decompiled with CFR 0.152.
 */
package net.reaper.vanimals.util;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.reaper.vanimals.util.EntityUtils;
import net.reaper.vanimals.util.TickUtils;

public class ParticleEffectBuilder {
    private final Level level;
    private final Entity entity;
    private final List<ParticleEffect> effects = new ArrayList<ParticleEffect>();

    public ParticleEffectBuilder(Level pLevel, Entity pEntity) {
        this.level = pLevel;
        this.entity = pEntity;
    }

    public ParticleEffectBuilder addEffect(ParticleOptions pParticleType, int pInterval, Supplier<Vec3> pPositionOffset) {
        this.effects.add(new ParticleEffect(pParticleType, pInterval, pPositionOffset));
        return this;
    }

    public void spawnParticles() {
        for (ParticleEffect effect : this.effects) {
            if (!EntityUtils.isEntityMoving(this.entity, 0.08f)) continue;
            TickUtils.doEvery(this.entity, effect.interval, () -> this.spawnParticle(effect));
        }
    }

    private void spawnParticle(ParticleEffect pEffect) {
        Vec3 position = this.entity.m_20182_().m_82549_(pEffect.positionOffset.get());
        Vec3 delta = this.entity.m_20184_();
        this.level.m_7106_(pEffect.particleType, position.f_82479_, position.f_82480_, position.f_82481_, delta.f_82479_ / 2.5, (double)0.02f, delta.f_82481_ / 2.5);
    }

    private record ParticleEffect(ParticleOptions particleType, int interval, Supplier<Vec3> positionOffset) {
    }
}

