/*
 * Decompiled with CFR 0.152.
 */
package net.reaper.vanimals.util;

import java.util.function.Predicate;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class EntityUtils {
    public static boolean checkItemsInHands(@Nullable LivingEntity pEntity, Predicate<Item> pCondition) {
        if (pEntity == null) {
            return false;
        }
        for (InteractionHand hand : InteractionHand.values()) {
            ItemStack itemInHand = pEntity.m_21120_(hand);
            if (!pCondition.test(itemInHand.m_41720_())) continue;
            return true;
        }
        return false;
    }

    public static boolean isEntityStepping(LivingEntity pEntity, float pAnimationSpeedFactor, float pScale) {
        float stepOffset = (float)Math.tan(pEntity.f_267362_.m_267756_() * pAnimationSpeedFactor - 0.2f);
        return stepOffset * stepOffset < pScale * pScale;
    }

    public static boolean isEntityMoving(@Nullable Entity pEntity, float pMinChange) {
        if (pEntity == null) {
            return false;
        }
        Vec3 delta = pEntity.m_20184_();
        return !(delta.m_82553_() > (double)(-pMinChange)) || !(delta.m_82553_() < (double)pMinChange);
    }
}

