/*
 * Decompiled with CFR 0.152.
 */
package net.reaper.vanimals.core.datagen.client;

import net.minecraft.data.PackOutput;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.data.LanguageProvider;
import net.minecraftforge.registries.ForgeRegistries;
import net.reaper.vanimals.core.datagen.client.ModSoundProvider;
import net.reaper.vanimals.core.init.VCreativeModTabs;
import net.reaper.vanimals.core.init.VEntityTypes;
import net.reaper.vanimals.core.init.VItems;
import net.reaper.vanimals.core.init.VSoundEvents;

public class ModEnglishLanguageProvider
extends LanguageProvider {
    public ModEnglishLanguageProvider(PackOutput output) {
        super(output, "vanimals", "en_us.json");
    }

    protected void addTranslations() {
        this.auto((ItemLike)VItems.BISON_FUR.get());
        this.auto((ItemLike)VItems.BISON_HORN.get());
        this.auto((ItemLike)VItems.RAW_BISON.get());
        this.auto((ItemLike)VItems.RAW_FOUREYED_FISH.get());
        this.auto((ItemLike)VItems.COOKED_BISON.get());
        this.auto((ItemLike)VItems.COOKED_FOUREYED_FISH.get());
        this.auto((ItemLike)VItems.BISON_SPAWN_EGG.get());
        this.auto((ItemLike)VItems.NAPOLEON_FISH_SPAWN_EGG.get());
        this.auto((ItemLike)VItems.FOUREYED_FISH_SPAWN_EGG.get());
        this.auto((ItemLike)VItems.FOUREYED_FISH_BUCKET.get());
        this.auto((ItemLike)VItems.APPLE_ON_A_STICK.get());
        this.auto((EntityType)VEntityTypes.BISON.get());
        this.auto((EntityType)VEntityTypes.FOUR_EYED_FISH.get());
        this.auto((EntityType)VEntityTypes.NAPOLEON_FISH.get());
        this.add((SoundEvent)VSoundEvents.BISON_IDLE.get(), "Bison ambient");
        this.add((SoundEvent)VSoundEvents.BISON_IDLE2.get(), "Bison ambient");
        this.add((SoundEvent)VSoundEvents.BISON_HURT.get(), "Bison hurt");
        this.add((SoundEvent)VSoundEvents.BISON_HURT2.get(), "Bison hurt");
        this.add((SoundEvent)VSoundEvents.BISON_ATTACK.get(), "Bison attack");
        this.add((SoundEvent)VSoundEvents.BISON_ATTACK_2.get(), "Bison attack");
        this.add((SoundEvent)VSoundEvents.BISON_ATTACK_3.get(), "Bison attack");
        this.add((SoundEvent)VSoundEvents.BISON_ROAR.get(), "Bison roar");
        this.add((SoundEvent)VSoundEvents.BISON_ROAR_2.get(), "Bison roar");
        this.add((SoundEvent)VSoundEvents.BISON_DEATH.get(), "Bison dying");
        this.add((SoundEvent)VSoundEvents.BISON_DEATH2.get(), "Bison dying");
        this.addTab("Vanimals", "Vanimals");
    }

    public void add(SoundEvent soundEvent, String translation) {
        this.add(ModSoundProvider.createSubtitle(soundEvent), translation);
        this.add("item." + ModSoundProvider.createSubtitle(soundEvent) + ".desc", translation);
    }

    public void auto(ItemLike item) {
        this.add(item.m_5456_(), ModEnglishLanguageProvider.toTitleCase(ForgeRegistries.ITEMS.getKey((Object)item.m_5456_()).m_135815_()));
    }

    public void auto(EntityType<?> type) {
        this.add(type, ModEnglishLanguageProvider.toTitleCase(ForgeRegistries.ENTITY_TYPES.getKey(type).m_135815_()));
    }

    public void addTab(String tab, String translation) {
        this.add(VCreativeModTabs.createTranslationKey(tab), translation);
    }

    public static String toTitleCase(String input) {
        StringBuilder titleCase = new StringBuilder();
        boolean nextTitleCase = true;
        for (char c : input.toCharArray()) {
            if (c == '_') {
                nextTitleCase = true;
                titleCase.append(" ");
                continue;
            }
            if (nextTitleCase) {
                c = Character.toTitleCase(c);
                nextTitleCase = false;
            } else {
                c = Character.toLowerCase(c);
            }
            titleCase.append(c);
        }
        return titleCase.toString();
    }
}

