/*
 * Decompiled with CFR 0.152.
 */
package net.reaper.vanimals.common.network.packet_builder;

import java.awt.Color;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum DataType {
    INTEGER{

        @Override
        public void encode(FriendlyByteBuf pBuf, Object pData) {
            pBuf.writeInt(((Integer)pData).intValue());
        }

        @Override
        public Object decode(FriendlyByteBuf pBuf) {
            return pBuf.readInt();
        }
    }
    ,
    STRING{

        @Override
        public void encode(FriendlyByteBuf pBuf, Object pData) {
            pBuf.m_130070_((String)pData);
        }

        @Override
        public Object decode(FriendlyByteBuf pBuf) {
            return pBuf.m_130277_();
        }
    }
    ,
    BOOLEAN{

        @Override
        public void encode(FriendlyByteBuf pBuf, Object pData) {
            pBuf.writeBoolean(((Boolean)pData).booleanValue());
        }

        @Override
        public Object decode(FriendlyByteBuf pBuf) {
            return pBuf.readBoolean();
        }
    }
    ,
    FLOAT{

        @Override
        public void encode(FriendlyByteBuf pBuf, Object pData) {
            pBuf.writeFloat(((Float)pData).floatValue());
        }

        @Override
        public Object decode(FriendlyByteBuf pBuf) {
            return Float.valueOf(pBuf.readFloat());
        }
    }
    ,
    DOUBLE{

        @Override
        public void encode(FriendlyByteBuf pBuf, Object pData) {
            pBuf.writeDouble(((Double)pData).doubleValue());
        }

        @Override
        public Object decode(FriendlyByteBuf pBuf) {
            return pBuf.readDouble();
        }
    }
    ,
    LONG{

        @Override
        public void encode(FriendlyByteBuf pBuf, Object pData) {
            pBuf.writeLong(((Long)pData).longValue());
        }

        @Override
        public Object decode(FriendlyByteBuf pBuf) {
            return pBuf.readLong();
        }
    }
    ,
    SHORT{

        @Override
        public void encode(FriendlyByteBuf pBuf, Object pData) {
            pBuf.writeShort((int)((Short)pData).shortValue());
        }

        @Override
        public Object decode(FriendlyByteBuf pBuf) {
            return pBuf.readShort();
        }
    }
    ,
    BYTE{

        @Override
        public void encode(FriendlyByteBuf pBuf, Object pData) {
            pBuf.writeByte((int)((Byte)pData).byteValue());
        }

        @Override
        public Object decode(FriendlyByteBuf pBuf) {
            return pBuf.readByte();
        }
    }
    ,
    STRING_INTEGER_MAP{

        @Override
        public void encode(FriendlyByteBuf pBuf, Object pData) {
            Map pMap = (Map)pData;
            pBuf.writeInt(pMap.size());
            for (Map.Entry pEntry : pMap.entrySet()) {
                pBuf.m_130070_((String)pEntry.getKey());
                pBuf.writeInt(((Integer)pEntry.getValue()).intValue());
            }
        }

        @Override
        public Object decode(FriendlyByteBuf pBuf) {
            int pSize = pBuf.readInt();
            HashMap<String, Integer> pMap = new HashMap<String, Integer>(pSize);
            for (int i = 0; i < pSize; ++i) {
                String pKey = pBuf.m_130277_();
                Integer pValue = pBuf.readInt();
                pMap.put(pKey, pValue);
            }
            return pMap;
        }
    }
    ,
    BLOCK_POS{

        @Override
        public void encode(FriendlyByteBuf pBuf, Object pData) {
            BlockPos pPos = (BlockPos)pData;
            pBuf.writeInt(pPos.m_123341_());
            pBuf.writeInt(pPos.m_123342_());
            pBuf.writeInt(pPos.m_123343_());
        }

        @Override
        public Object decode(FriendlyByteBuf pBuf) {
            int pX = pBuf.readInt();
            int pY = pBuf.readInt();
            int pZ = pBuf.readInt();
            return new BlockPos(pX, pY, pZ);
        }
    }
    ,
    VEC3{

        @Override
        public void encode(FriendlyByteBuf pBuf, Object pData) {
            Vec3 pVec = (Vec3)pData;
            pBuf.writeDouble(pVec.f_82479_);
            pBuf.writeDouble(pVec.f_82480_);
            pBuf.writeDouble(pVec.f_82481_);
        }

        @Override
        public Object decode(FriendlyByteBuf pBuf) {
            double pX = pBuf.readDouble();
            double pY = pBuf.readDouble();
            double pZ = pBuf.readDouble();
            return new Vec3(pX, pY, pZ);
        }
    }
    ,
    COMPOUND_TAG{

        @Override
        public void encode(FriendlyByteBuf pBuf, Object pData) {
            CompoundTag pTag = (CompoundTag)pData;
            pBuf.m_130079_(pTag);
        }

        @Override
        public Object decode(FriendlyByteBuf pBuf) {
            return pBuf.m_130260_();
        }
    }
    ,
    COLOR{

        @Override
        public void encode(FriendlyByteBuf pBuf, Object pData) {
            Color pColor = (Color)pData;
            pBuf.writeInt(pColor.getRGB());
        }

        @Override
        public Object decode(FriendlyByteBuf pBuf) {
            return new Color(pBuf.readInt());
        }
    }
    ,
    GENERIC_OBJECT{

        @Override
        public void encode(FriendlyByteBuf pBuf, Object pData) {
            try (ByteArrayOutputStream bos = new ByteArrayOutputStream();
                 ObjectOutputStream oos = new ObjectOutputStream(bos);){
                oos.writeObject(pData);
                byte[] objectBytes = bos.toByteArray();
                pBuf.writeInt(objectBytes.length);
                pBuf.writeBytes(objectBytes);
            }
            catch (IOException e) {
                throw new RuntimeException("Error encoding generic object", e);
            }
        }

        /*
         * Enabled aggressive exception aggregation
         */
        @Override
        public Object decode(FriendlyByteBuf pBuf) {
            int length = pBuf.readInt();
            byte[] objectBytes = new byte[length];
            pBuf.readBytes(objectBytes);
            try (ByteArrayInputStream bis = new ByteArrayInputStream(objectBytes);){
                Object object;
                try (ObjectInputStream ois = new ObjectInputStream(bis);){
                    object = ois.readObject();
                }
                return object;
            }
            catch (IOException | ClassNotFoundException e) {
                throw new RuntimeException("Error decoding generic object", e);
            }
        }
    }
    ,
    ITEM_STACK{

        @Override
        public void encode(FriendlyByteBuf pBuf, Object pData) {
            ItemStack pStack = (ItemStack)pData;
            pBuf.m_130055_(pStack);
        }

        @Override
        public Object decode(FriendlyByteBuf pBuf) {
            return pBuf.m_130267_();
        }
    };


    public abstract void encode(FriendlyByteBuf var1, Object var2);

    public abstract Object decode(FriendlyByteBuf var1);

    public static DataType fromOrdinal(int pOrdinal) {
        return DataType.values()[pOrdinal];
    }
}

