/*
 * Decompiled with CFR 0.152.
 */
package net.reaper.vanimals.common.network;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.network.NetworkEvent;
import net.reaper.vanimals.api.io.network.AbstractNetworkPacket;
import net.reaper.vanimals.api.io.network.PacketSide;
import net.reaper.vanimals.api.io.network.Side;
import net.reaper.vanimals.client.screen.MudskipperMenu;
import net.reaper.vanimals.client.screen.MudskipperScreen;
import net.reaper.vanimals.common.entity.water.MudskipperEntity;
import org.jetbrains.annotations.NotNull;

@PacketSide(side=Side.CLIENT)
public class OpenMudskipperScreenPacket
extends AbstractNetworkPacket<OpenMudskipperScreenPacket> {
    private int containerId;
    private int entityId;

    public OpenMudskipperScreenPacket() {
    }

    public OpenMudskipperScreenPacket(int containerId, int entityId) {
        this.containerId = containerId;
        this.entityId = entityId;
    }

    @Override
    protected void read(@NotNull FriendlyByteBuf buf) {
        this.containerId = buf.readInt();
        this.entityId = buf.readInt();
    }

    @Override
    protected void write(@NotNull FriendlyByteBuf buf) {
        buf.writeInt(this.containerId);
        buf.writeInt(this.entityId);
    }

    @Override
    protected void execute(@NotNull Supplier<NetworkEvent.Context> contextSupplier) {
        Entity entity;
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91073_ != null && (entity = mc.f_91073_.m_6815_(this.entityId)) instanceof MudskipperEntity) {
            MudskipperEntity mudskipper = (MudskipperEntity)entity;
            LocalPlayer player = mc.f_91074_;
            if (player != null) {
                MudskipperMenu menu = new MudskipperMenu(this.containerId, player.m_150109_(), (Container)new SimpleContainer(4), mudskipper);
                player.f_36096_ = menu;
                mc.m_91152_((Screen)new MudskipperScreen(menu, player.m_150109_(), mudskipper));
            }
        }
    }
}

