/*
 * Decompiled with CFR 0.152.
 */
package net.reaper.vanimals.common.entity.water;

import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.control.SmoothSwimmingLookControl;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomSwimmingGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.navigation.WaterBoundPathNavigation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Bucketable;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.reaper.vanimals.Vanimals;
import net.reaper.vanimals.common.entity.ai.behavior.DietBuilder;
import net.reaper.vanimals.common.entity.base.AbstractAnimal;
import net.reaper.vanimals.common.entity.base.AbstractWaterAnimal;
import net.reaper.vanimals.common.entity.goals.DifferentGenderBreedGoal;
import net.reaper.vanimals.common.entity.goals.WaterAnimalTemptGoal;
import net.reaper.vanimals.common.entity.goals.WildBreedGoal;
import net.reaper.vanimals.common.enums.Gender;
import net.reaper.vanimals.core.init.VEntityTypes;
import net.reaper.vanimals.core.init.VItems;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FoureyedFishEntity
extends AbstractWaterAnimal
implements Bucketable {
    private static final EntityDataAccessor<Boolean> FROM_BUCKET = SynchedEntityData.m_135353_(FoureyedFishEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> IS_MANGROVE_VARIANT = SynchedEntityData.m_135353_(FoureyedFishEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> IS_EYELESS = SynchedEntityData.m_135353_(FoureyedFishEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private int completeTime = 4000;
    private int midTime = 2000;

    public FoureyedFishEntity(EntityType<? extends AbstractWaterAnimal> pEntityType, Level pLevel) {
        super((EntityType<? extends AbstractAnimal>)pEntityType, pLevel);
        this.f_21342_ = new FourEyedFishSwimmingMoveControl(this, 90, 50, 0.2f, 1.5f, false);
        this.f_21365_ = new SmoothSwimmingLookControl((Mob)this, 10);
        this.f_21344_ = new WaterBoundPathNavigation((Mob)this, pLevel);
        this.m_21441_(BlockPathTypes.WATER, 0.0f);
        this.m_274367_(0.5f);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return WaterAnimal.m_21183_().m_22268_(Attributes.f_22276_, 6.0).m_22268_(Attributes.f_22277_, 48.0).m_22268_(Attributes.f_22279_, (double)0.2f);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(2, (Goal)new WildBreedGoal((Animal)this, entity -> this.m_20072_() && !this.m_6162_(), 300));
        this.f_21345_.m_25352_(1, (Goal)new RandomSwimmingGoal((PathfinderMob)this, 1.0, 15));
        this.f_21345_.m_25352_(2, (Goal)new AvoidEntityGoal((PathfinderMob)this, Player.class, 8.0f, 1.6, 1.4));
        this.f_21345_.m_25352_(2, (Goal)new WaterAnimalTemptGoal(this, 0.9f, true));
        this.f_21346_.m_25352_(3, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[0]));
        this.f_21345_.m_25352_(3, (Goal)new FollowParentGoal((Animal)this, (double)0.9f));
        this.f_21345_.m_25352_(1, (Goal)new PanicGoal((PathfinderMob)this, (double)1.1f));
        this.f_21345_.m_25352_(1, (Goal)new DifferentGenderBreedGoal((Animal)this, 0.9f));
    }

    @Override
    protected void setupAnimations() {
        if (this.idleAnimationTimeout <= 0) {
            this.idleAnimationTimeout = 80;
            this.idleAnimationState.m_216977_(this.f_19797_);
        } else {
            --this.idleAnimationTimeout;
        }
        if (this.flipAnimationTimeout <= 0 && !this.m_20072_()) {
            this.flipAnimationTimeout = 30;
            this.flipAnimationState.m_216977_(this.f_19797_);
        } else {
            --this.flipAnimationTimeout;
        }
        if (this.m_20072_() || this.flipAnimationTimeout <= 0) {
            this.flipAnimationState.m_216973_();
        }
    }

    protected void m_267689_(float pPartialTick) {
        float f = this.m_20089_() == Pose.STANDING ? Math.min(pPartialTick * 6.0f, 1.0f) : 0.0f;
        this.f_267362_.m_267566_(f, 0.2f);
    }

    public int m_5792_() {
        return 6;
    }

    @Override
    protected DietBuilder createDiet() {
        return new DietBuilder().addFood((ItemLike)Items.f_42591_).addFood((ItemLike)Items.f_42592_);
    }

    protected void handleAirSupply(int pAirSupply) {
        if (this.m_6084_() && !this.m_20072_()) {
            this.m_20301_(pAirSupply - 1);
            if (this.m_20146_() == -20) {
                this.m_20301_(0);
                this.m_6469_(this.m_269291_().m_269063_(), 2.0f);
            }
        } else {
            this.m_20301_(300);
        }
    }

    public void m_6075_() {
        int isX = this.m_20146_();
        super.m_6075_();
        this.handleAirSupply(isX);
    }

    @Override
    public void m_8107_() {
        super.m_8107_();
        if (this.m_6084_()) {
            if (this.isEyeless() && this.f_19797_ != this.completeTime) {
                this.m_7910_(0.02f);
                this.m_20256_(this.m_20184_().m_82520_(0.0, -0.005, 0.0));
                this.m_7292_(new MobEffectInstance(MobEffects.f_19610_));
            }
            if (this.isEyeless()) {
                if (this.f_19797_ == this.midTime) {
                    this.m_7292_(new MobEffectInstance(MobEffects.f_19605_, this.midTime));
                }
                if (this.f_19797_ == this.completeTime) {
                    this.setEyeless(false);
                    this.readyForShearing();
                }
            }
        }
    }

    @Nullable
    public FoureyedFishEntity getBreedOffspring(@NotNull ServerLevel pLevel, @NotNull AgeableMob pOtherParent) {
        FoureyedFishEntity baby = (FoureyedFishEntity)((EntityType)VEntityTypes.FOUR_EYED_FISH.get()).m_20615_((Level)pLevel);
        if (((FoureyedFishEntity)pOtherParent).isMangroveVariant()) {
            baby = (FoureyedFishEntity)((EntityType)VEntityTypes.FOUR_EYED_FISH.get()).m_20615_((Level)pLevel);
        }
        assert (baby != null);
        baby.setMangroveVariant(this.isMangroveVariant());
        baby.m_21530_();
        return baby;
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(IS_MANGROVE_VARIANT, (Object)false);
        this.f_19804_.m_135372_(IS_EYELESS, (Object)false);
        this.f_19804_.m_135372_(FROM_BUCKET, (Object)false);
    }

    @Override
    public void m_7380_(@NotNull CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128379_("FromBucket", this.m_27487_());
        pCompound.m_128379_("isMangroveVariant", this.isMangroveVariant());
        pCompound.m_128379_("isEyeless", this.isEyeless());
    }

    @Override
    public void m_7378_(@NotNull CompoundTag pCompound) {
        super.m_7378_(pCompound);
        this.m_27497_(pCompound.m_128471_("FromBucket"));
        this.setMangroveVariant(pCompound.m_128471_("isMangroveVariant"));
        this.setEyeless(pCompound.m_128471_("isEyeless"));
    }

    @Override
    protected float getFlipYPower() {
        return 0.4f;
    }

    protected SoundEvent m_7515_() {
        return SoundEvents.f_11758_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_12328_;
    }

    protected SoundEvent m_7975_(@NotNull DamageSource pDamageSource) {
        return SoundEvents.f_12330_;
    }

    @Override
    @NotNull
    protected SoundEvent getFlopSound() {
        return SoundEvents.f_12329_;
    }

    protected boolean isBucketAble() {
        return true;
    }

    public void m_6872_(@NotNull ItemStack pItemStack) {
        if (this.isBucketAble()) {
            Bucketable.m_148822_((Mob)this, (ItemStack)pItemStack);
            CompoundTag compound = pItemStack.m_41784_();
            compound.m_128405_("Age", this.m_146764_());
            compound.m_128379_("Eyeless", this.isEyeless());
            compound.m_128379_("MangroveVariant", this.isMangroveVariant());
            compound.m_128359_("Gender", this.getGender().toString());
        }
    }

    public void m_142278_(@NotNull CompoundTag pCompound) {
        if (this.isBucketAble()) {
            Bucketable.m_148825_((Mob)this, (CompoundTag)pCompound);
            if (pCompound.m_128441_("Age")) {
                this.m_146762_(pCompound.m_128451_("Age"));
            }
            if (pCompound.m_128441_("MangroveVariant")) {
                this.setMangroveVariant(pCompound.m_128471_("MangroveVariant"));
            }
            if (pCompound.m_128441_("Eyeless")) {
                this.setEyeless(pCompound.m_128471_("Eyeless"));
            }
            if (pCompound.m_128441_("Gender")) {
                this.setGender(Gender.valueOf(pCompound.m_128461_("Gender").toUpperCase()));
            }
        }
    }

    @NotNull
    public ItemStack m_28282_() {
        return new ItemStack((ItemLike)VItems.FOUREYED_FISH_BUCKET.get());
    }

    @NotNull
    public SoundEvent m_142623_() {
        return SoundEvents.f_11782_;
    }

    public boolean m_27487_() {
        return (Boolean)this.f_19804_.m_135370_(FROM_BUCKET);
    }

    public void m_27497_(boolean pFromBucket) {
        this.f_19804_.m_135381_(FROM_BUCKET, (Object)pFromBucket);
    }

    public boolean m_8023_() {
        return super.m_8023_() || this.m_27487_();
    }

    @Nonnull
    public InteractionResult m_6071_(@Nonnull Player pPlayer, @Nonnull InteractionHand pHand) {
        ItemStack itemInHand = pPlayer.m_21120_(pHand);
        if (itemInHand.m_150930_(Items.f_42574_) && !this.m_6162_() && this.readyForShearing()) {
            ItemEntity itementity = this.m_20000_((ItemLike)VItems.FOUREYED_FISH_EYE.get(), 1);
            this.m_6469_(this.m_269291_().m_269264_(), 1.0f);
            pPlayer.m_5496_(SoundEvents.f_12075_, 0.5f, 1.0f);
            this.setEyeless(true);
            if (itementity != null) {
                itementity.m_20256_(itementity.m_20184_().m_82520_((double)((this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.1f), (double)(this.f_19796_.m_188501_() * 0.05f), (double)((this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.1f)));
            }
            return InteractionResult.SUCCESS;
        }
        return Bucketable.m_148828_((Player)pPlayer, (InteractionHand)pHand, (LivingEntity)this).orElse(super.m_6071_(pPlayer, pHand));
    }

    public static boolean canSpawn(EntityType<FoureyedFishEntity> entityType, ServerLevelAccessor iServerWorld, MobSpawnType reason, BlockPos pos, RandomSource random) {
        return reason == MobSpawnType.SPAWNER || iServerWorld.m_8055_(pos).m_60819_().getFluidType() == Fluids.f_76193_.getFluidType() && iServerWorld.m_8055_(pos.m_7494_()).m_60819_().getFluidType() == Fluids.f_76193_.getFluidType() && FoureyedFishEntity.m_186209_((BlockAndTintGetter)iServerWorld, (BlockPos)pos);
    }

    @Override
    @NotNull
    public SpawnGroupData m_6518_(@NotNull ServerLevelAccessor pLevel, @NotNull DifficultyInstance pDifficulty, @NotNull MobSpawnType reason, @Nullable SpawnGroupData pSpawnData, @Nullable CompoundTag pDataTag) {
        if (reason == MobSpawnType.BUCKET && pDataTag != null) {
            this.setMangroveVariant(pDataTag.m_128471_("isMangroveVariant"));
            this.m_6863_(pDataTag.m_128471_("isBaby"));
            this.m_146762_(pDataTag.m_128451_("age"));
            this.setEyeless(pDataTag.m_128471_("isEyeless"));
            this.setGender(Gender.valueOf(pDataTag.m_128461_("Gender").toUpperCase()));
            this.m_27497_(true);
        }
        BlockPos position = this.m_20183_();
        ResourceKey biomeKey = this.m_9236_().m_204166_(position).m_203543_().orElse(null);
        Vanimals.LOGGER.info("Spawning four-eyed fish at " + position);
        if (biomeKey != null && biomeKey.m_135782_().m_135815_().contains("mangrove")) {
            this.setMangroveVariant(true);
        } else {
            this.setMangroveVariant(false);
        }
        return super.m_6518_(pLevel, pDifficulty, reason, pSpawnData, pDataTag);
    }

    public boolean isMangroveVariant() {
        return (Boolean)this.f_19804_.m_135370_(IS_MANGROVE_VARIANT);
    }

    public void setMangroveVariant(boolean mangroveVariant) {
        this.f_19804_.m_135381_(IS_MANGROVE_VARIANT, (Object)mangroveVariant);
    }

    public boolean isEyeless() {
        return (Boolean)this.f_19804_.m_135370_(IS_EYELESS);
    }

    public void setEyeless(boolean eyeless) {
        this.f_19804_.m_135381_(IS_EYELESS, (Object)eyeless);
    }

    public boolean readyForShearing() {
        return this.m_6084_() && !this.isEyeless() && !this.m_6162_();
    }

    public static class FourEyedFishSwimmingMoveControl
    extends MoveControl {
        private static final float FULL_SPEED_TURN_THRESHOLD = 10.0f;
        private static final float STOP_TURN_THRESHOLD = 60.0f;
        private final int maxTurnX;
        private final int maxTurnY;
        private final float inWaterSpeedModifier;
        private final float outsideWaterSpeedModifier;
        private final boolean applyGravity;

        public FourEyedFishSwimmingMoveControl(FoureyedFishEntity pMob, int pMaxTurnX, int pMaxTurnY, float pInWaterSpeedModifier, float pOutsideWaterSpeedModifier, boolean pApplyGravity) {
            super((Mob)pMob);
            this.maxTurnX = pMaxTurnX;
            this.maxTurnY = pMaxTurnY;
            this.inWaterSpeedModifier = pInWaterSpeedModifier;
            this.outsideWaterSpeedModifier = pOutsideWaterSpeedModifier;
            this.applyGravity = pApplyGravity;
        }

        public void m_8126_() {
            if (this.applyGravity && this.f_24974_.m_20069_()) {
                this.f_24974_.m_20256_(this.f_24974_.m_20184_().m_82520_(0.0, 0.005, 0.0));
            }
            if (this.f_24981_ == MoveControl.Operation.MOVE_TO && !this.f_24974_.m_21573_().m_26571_()) {
                double isZ;
                double isY;
                double isX = this.f_24975_ - this.f_24974_.m_20185_();
                double isAxis = isX * isX + (isY = this.f_24976_ - this.f_24974_.m_20186_()) * isY + (isZ = this.f_24977_ - this.f_24974_.m_20189_()) * isZ;
                if (isAxis < 2.500000277905201E-7) {
                    this.f_24974_.m_21564_(0.0f);
                } else {
                    float $$4 = (float)(Mth.m_14136_((double)isZ, (double)isX) * 57.2957763671875) - 90.0f;
                    this.f_24974_.m_146922_(this.m_24991_(this.f_24974_.m_146908_(), $$4, this.maxTurnY));
                    this.f_24974_.f_20883_ = this.f_24974_.m_146908_();
                    this.f_24974_.f_20885_ = this.f_24974_.m_146908_();
                    float speedMod = (float)(this.f_24978_ * this.f_24974_.m_21133_(Attributes.f_22279_));
                    if (this.f_24974_.m_20069_()) {
                        this.f_24974_.m_7910_(speedMod * this.inWaterSpeedModifier);
                        double isXZ = Math.sqrt(isX * isX + isZ * isZ);
                        if (Math.abs(isY) > (double)1.0E-5f || Math.abs(isXZ) > (double)1.0E-5f) {
                            float isYXZ = -((float)(Mth.m_14136_((double)isY, (double)isXZ) * 28.64788818359375));
                            isYXZ = Mth.m_14036_((float)Mth.m_14177_((float)isYXZ), (float)(-this.maxTurnX), (float)this.maxTurnX);
                            this.f_24974_.m_146926_(this.m_24991_(this.f_24974_.m_146909_(), isYXZ, 5.0f));
                        }
                        float $$8 = Mth.m_14089_((float)(this.f_24974_.m_146909_() * ((float)Math.PI / 180)));
                        float $$9 = Mth.m_14031_((float)(this.f_24974_.m_146909_() * ((float)Math.PI / 180)));
                        this.f_24974_.f_20902_ = $$8 * speedMod;
                        this.f_24974_.f_20901_ = -$$9 * speedMod;
                    } else {
                        float isY0 = Math.abs(Mth.m_14177_((float)(this.f_24974_.m_146908_() - $$4)));
                        float isY1 = FourEyedFishSwimmingMoveControl.getTurningSpeedFactor(isY0);
                        this.f_24974_.m_7910_(speedMod * this.outsideWaterSpeedModifier * isY1);
                    }
                }
            } else {
                this.f_24974_.m_7910_(0.0f);
                this.f_24974_.m_21570_(0.0f);
                this.f_24974_.m_21567_(0.0f);
                this.f_24974_.m_21564_(0.0f);
            }
        }

        private static float getTurningSpeedFactor(float p_249853_) {
            return 1.0f - Mth.m_14036_((float)((p_249853_ - 10.0f) / 50.0f), (float)0.0f, (float)1.0f);
        }
    }
}

