/*
 * Decompiled with CFR 0.152.
 */
package net.reaper.vanimals.common.entity.base;

import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.ai.control.SmoothSwimmingLookControl;
import net.minecraft.world.entity.ai.control.SmoothSwimmingMoveControl;
import net.minecraft.world.entity.ai.navigation.WaterBoundPathNavigation;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.fluids.FluidType;
import net.reaper.vanimals.common.entity.ai.behavior.DietBuilder;
import net.reaper.vanimals.common.entity.ai.behavior.EntityCategory;
import net.reaper.vanimals.common.entity.base.AbstractAnimal;
import net.reaper.vanimals.core.init.VTags;
import org.jetbrains.annotations.NotNull;

public class AbstractWaterAnimal
extends AbstractAnimal {
    public AnimationState flipAnimationState = new AnimationState();
    public int flipAnimationTimeout;
    public float currentRoll = 0.0f;
    public float tailRot;
    public float prevTailRot;

    public AbstractWaterAnimal(EntityType<? extends AbstractAnimal> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.f_21342_ = new SmoothSwimmingMoveControl((Mob)this, 90, 50, 0.2f, 1.0f, false);
        this.f_21365_ = new SmoothSwimmingLookControl((Mob)this, 10);
        this.f_21344_ = new WaterBoundPathNavigation((Mob)this, pLevel);
        this.m_21441_(BlockPathTypes.WATER, 0.0f);
    }

    @Override
    public EntityCategory getCategory() {
        return EntityCategory.AQUATIC;
    }

    @Override
    protected DietBuilder createDiet() {
        return null;
    }

    public void m_7023_(@NotNull Vec3 pTravelVector) {
        if (this.m_20069_() && (this.m_21515_() || this.m_20160_())) {
            this.m_19920_(this.m_6113_(), pTravelVector);
            this.m_20256_(this.m_20184_().m_82490_((double)0.9f));
            this.m_6478_(MoverType.SELF, this.m_20184_());
            this.m_267651_(false);
        } else {
            super.m_7023_(pTravelVector);
        }
    }

    public boolean m_6914_(LevelReader pLevel) {
        return pLevel.m_45784_((Entity)this);
    }

    public static boolean checkWaterAnimalSpawnRules(EntityType<? extends AbstractWaterAnimal> pAnimal, LevelAccessor pLevel, MobSpawnType pSpawnType, BlockPos pPos, RandomSource pRandom) {
        return pLevel.m_8055_(pPos.m_7495_()).m_204336_(VTags.Blocks.WATER_SPAWNABLE_BLOCKS) && AbstractWaterAnimal.m_186209_((BlockAndTintGetter)pLevel, (BlockPos)pPos);
    }

    public boolean canDrownInFluidType(FluidType type) {
        return type != ForgeMod.WATER_TYPE.get();
    }

    @Nonnull
    public MobType m_6336_() {
        return MobType.f_21644_;
    }

    public boolean m_6063_() {
        return false;
    }

    public boolean m_6040_() {
        return true;
    }

    protected void handleAirSupply(LivingEntity pEntity, int pAirSupply) {
        if (pEntity.m_6084_() && !pEntity.m_20072_()) {
            pEntity.m_20301_(pAirSupply - 1);
            if (pEntity.m_20146_() == -20) {
                pEntity.m_20301_(0);
                pEntity.m_6469_(pEntity.m_269291_().m_269063_(), 2.0f);
            }
        } else {
            pEntity.m_20301_(300);
        }
    }

    protected boolean canFlip() {
        return true;
    }

    @NotNull
    protected SoundEvent getFlopSound() {
        return SoundEvents.f_271165_;
    }

    protected float getFlipYPower() {
        return 0.2f;
    }

    protected float getMaxTailRotate() {
        return 45.0f;
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        this.handleAirSupply((LivingEntity)this, this.m_20146_());
        this.prevTailRot = this.tailRot;
        this.tailRot += (-(this.f_20883_ - this.f_20884_) - this.tailRot) * 0.15f;
        this.tailRot = Mth.m_14036_((float)this.tailRot, (float)(-this.getMaxTailRotate()), (float)this.getMaxTailRotate());
    }

    @Override
    public void m_8107_() {
        if (this.canFlip() && !this.m_20069_() && (this.m_20096_() || this.f_19863_)) {
            this.m_20256_(this.m_20184_().m_82520_((double)((this.f_19796_.m_188501_() * 2.0f - 1.0f) * 0.05f), (double)this.getFlipYPower(), (double)((this.f_19796_.m_188501_() * 2.0f - 1.0f) * 0.05f)));
            this.f_19812_ = true;
            this.m_5496_(this.getFlopSound(), this.m_6121_(), this.m_6100_());
        }
        super.m_8107_();
    }

    public static boolean checkSurfaceWaterAnimalSpawnRules(EntityType<? extends AbstractWaterAnimal> pAbstractWaterAnimal, LevelAccessor pLevel, MobSpawnType pSpawnType, BlockPos pPos, RandomSource pRandom) {
        int $$5 = pLevel.m_5736_();
        int $$6 = $$5 - 13;
        return pPos.m_123342_() >= $$6 && pPos.m_123342_() <= $$5 && pLevel.m_6425_(pPos.m_7495_()).m_205070_(FluidTags.f_13131_) && pLevel.m_8055_(pPos.m_7494_()).m_60713_(Blocks.f_49990_);
    }
}

