/*
 * Decompiled with CFR 0.152.
 */
package net.reaper.vanimals.common.entity.ai.behavior;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

public class DietBuilder {
    private final List<DietEntry> dietEntries = new ArrayList<DietEntry>();

    public List<DietEntry> getDietEntries() {
        return this.dietEntries;
    }

    public List<ItemLike> getDietItems() {
        ArrayList<ItemLike> items = new ArrayList<ItemLike>();
        for (DietEntry entry : this.dietEntries) {
            if (!(entry instanceof ItemEntry)) continue;
            ItemEntry itemEntry = (ItemEntry)entry;
            items.add(itemEntry.item());
        }
        return items;
    }

    public DietBuilder addFood(ItemLike pFoodItem) {
        this.dietEntries.add(new ItemEntry(pFoodItem));
        return this;
    }

    public DietBuilder addFoodTag(TagKey<Item> pFoodTag) {
        this.dietEntries.add(new TagEntry(pFoodTag));
        return this;
    }

    public Ingredient toIngredient() {
        Iterator<ItemLike> iterator = this.getDietItems().iterator();
        if (iterator.hasNext()) {
            ItemLike itemLike = iterator.next();
            return Ingredient.m_43929_((ItemLike[])new ItemLike[]{itemLike});
        }
        return Ingredient.f_43901_;
    }

    public static DietBuilder fromItems(ItemLike ... pItems) {
        DietBuilder dietBuilder = new DietBuilder();
        for (ItemLike item : pItems) {
            dietBuilder.addFood(item);
        }
        return dietBuilder;
    }

    public boolean isFoodInDiet(ItemLike pFoodItem) {
        for (DietEntry entry : this.dietEntries) {
            if (!entry.matches(pFoodItem)) continue;
            return true;
        }
        return false;
    }

    @FunctionalInterface
    public static interface DietEntry {
        public boolean matches(ItemLike var1);
    }

    public record ItemEntry(ItemLike item) implements DietEntry
    {
        @Override
        public boolean matches(ItemLike pFoodItem) {
            return this.item == pFoodItem;
        }
    }

    public record TagEntry(TagKey<Item> itemTag) implements DietEntry
    {
        @Override
        public boolean matches(ItemLike pFoodItem) {
            if (pFoodItem instanceof Item) {
                Item item = (Item)pFoodItem;
                return item.m_204114_().m_203656_(this.itemTag);
            }
            return false;
        }
    }
}

