/*
 * Decompiled with CFR 0.152.
 */
package net.reaper.vanimals.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.reaper.vanimals.client.model.ModLayers;
import net.reaper.vanimals.client.model.entity.AbstractBisonModel;
import net.reaper.vanimals.client.model.entity.BabyBisonModel;
import net.reaper.vanimals.client.model.entity.BisonModel;
import net.reaper.vanimals.client.renderer.entity.AgeableMobRenderer;
import net.reaper.vanimals.client.renderer.entity.layer.ModPassengerLayer;
import net.reaper.vanimals.client.renderer.entity.layer.ModSaddleLayer;
import net.reaper.vanimals.client.util.BabyTagLayer;
import net.reaper.vanimals.client.util.ICustomPlayerRidePos;
import net.reaper.vanimals.client.util.ResourceUtils;
import net.reaper.vanimals.client.util.TagLayer;
import net.reaper.vanimals.common.entity.ground.BisonEntity;
import net.reaper.vanimals.common.enums.Gender;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class BisonRenderer
extends AgeableMobRenderer<BisonEntity, AbstractBisonModel>
implements ICustomPlayerRidePos {
    public static final ResourceLocation TAGGED_LOCATION = new ResourceLocation("vanimals", "textures/entity/bison/bison_tagged_layer.png");
    public static final ResourceLocation BABY_TAGGED_LOCATION = new ResourceLocation("vanimals", "textures/entity/bison/baby_bison_tagged_layer.png");
    public static final ResourceLocation SADDLED_LOCATION = new ResourceLocation("vanimals", "textures/entity/bison/bison_saddle_layer.png");

    public BisonRenderer(EntityRendererProvider.Context context) {
        super(context, new BisonModel(context.m_174023_(ModLayers.BISON_LAYER)), new BabyBisonModel(context.m_174023_(ModLayers.BABY_BISON_LAYER)), 1.3f);
        this.m_115326_(new ModPassengerLayer(this));
        this.m_115326_(new ModSaddleLayer(this, SADDLED_LOCATION));
        this.m_115326_(new TagLayer(this, new BisonModel(context.m_174023_(ModLayers.BISON_LAYER)), TAGGED_LOCATION));
        this.m_115326_(new BabyTagLayer(this, new BabyBisonModel(context.m_174023_(ModLayers.BABY_BISON_LAYER)), BABY_TAGGED_LOCATION));
    }

    @NotNull
    public ResourceLocation getTextureLocation(BisonEntity entity) {
        if (entity.m_6162_() && entity.getGender().equals((Object)Gender.MALE)) {
            return ResourceUtils.entity("bison/bison_male_baby");
        }
        if (entity.m_6162_() && entity.getGender().equals((Object)Gender.FEMALE)) {
            return ResourceUtils.entity("bison/bison_female_baby");
        }
        if (entity.getGender().equals((Object)Gender.FEMALE)) {
            return ResourceUtils.entity("bison/bison" + (entity.getGender() == Gender.FEMALE ? "_female" : "") + (entity.m_5912_() && !entity.m_6162_() ? "_angry" : ""));
        }
        return ResourceUtils.entity("bison/bison" + (entity.getGender() == Gender.MALE ? "_male" : "") + (entity.m_5912_() && !entity.m_6162_() ? "_angry" : "") + (entity.m_6254_() ? "_saddled" : ""));
    }

    @Override
    public <T extends LivingEntity> void applyRiderPose(@NotNull LivingEntity vehicle, HumanoidModel<T> humanoidModel, @NotNull T rider) {
        humanoidModel.f_102808_.f_104204_ = Mth.m_14036_((float)humanoidModel.f_102808_.f_104204_, (float)this.rad(-35.0f), (float)this.rad(35.0f));
    }

    @Override
    public <T extends Entity> void applyRiderMatrixStack(@NotNull T vehicle, @NotNull PoseStack matrices) {
        ((AbstractBisonModel)this.m_7200_()).setMatrixStack(matrices);
        matrices.m_252880_(0.0f, 1.25f - vehicle.m_20206_(), -1.0f);
        matrices.m_252781_(Axis.f_252392_.m_252977_(180.0f));
        matrices.m_252781_(Axis.f_252495_.m_252977_(180.0f));
    }
}

