/*
 * Decompiled with CFR 0.152.
 */
package net.reaper.vanimals.client.model.entity;

import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.reaper.vanimals.client.animations.entity.FourEyedFishAnimations;
import net.reaper.vanimals.client.animations.entity.NapoleonFishAnimations;
import net.reaper.vanimals.common.entity.water.NapoleonFishEntity;
import org.jetbrains.annotations.NotNull;

public class NapoleonFishModel
extends HierarchicalModel<NapoleonFishEntity> {
    private final ModelPart napoleon;
    private final ModelPart body;
    private final ModelPart tail;
    private final ModelPart fin_tail;

    public NapoleonFishModel(ModelPart pRoot) {
        this.napoleon = pRoot.m_171324_("napoleon");
        this.body = this.napoleon.m_171324_("body");
        this.tail = this.body.m_171324_("tail");
        this.fin_tail = this.tail.m_171324_("fin_tail");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition napoleon = partdefinition.m_171599_("napoleon", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)17.0f, (float)0.0f));
        PartDefinition body = napoleon.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-3.5f, -5.7f, -9.0f, 7.0f, 13.0f, 20.0f, new CubeDeformation(0.0f)).m_171514_(74, 15).m_171488_(-3.5f, -4.7f, -9.0f, 7.0f, 11.0f, 20.0f, new CubeDeformation(0.0f)).m_171514_(54, 19).m_171488_(0.0f, 6.3f, 4.0f, 0.0f, 3.0f, 10.0f, new CubeDeformation(0.0f)).m_171514_(108, 19).m_171488_(0.0f, 5.3f, 3.0f, 0.0f, 3.0f, 10.0f, new CubeDeformation(0.0f)).m_171514_(0, 33).m_171488_(0.0f, -7.7f, -4.0f, 0.0f, 4.0f, 18.0f, new CubeDeformation(0.0f)).m_171514_(92, 28).m_171488_(0.0f, -6.7f, -4.0f, 0.0f, 4.0f, 18.0f, new CubeDeformation(0.0f)).m_171514_(58, 62).m_171488_(1.0f, 7.3f, -5.0f, 0.0f, 3.0f, 5.0f, new CubeDeformation(0.0f)).m_171514_(0, 64).m_171488_(-1.0f, 7.3f, -5.0f, 0.0f, 3.0f, 5.0f, new CubeDeformation(0.0f)).m_171514_(118, 15).m_171488_(1.0f, 6.3f, -5.0f, 0.0f, 3.0f, 5.0f, new CubeDeformation(0.0f)).m_171514_(118, 12).m_171488_(-1.0f, 6.3f, -5.0f, 0.0f, 3.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-0.3f, (float)0.0f));
        PartDefinition tail = body.m_171599_("tail", CubeListBuilder.m_171558_().m_171514_(36, 51).m_171488_(-2.0f, -2.5f, 0.0f, 4.0f, 7.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-0.2f, (float)11.0f));
        PartDefinition fin_tail = tail.m_171599_("fin_tail", CubeListBuilder.m_171558_().m_171514_(54, 0).m_171488_(0.0f, -4.5f, 0.0f, 0.0f, 11.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)4.0f));
        PartDefinition head = body.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(36, 33).m_171488_(-3.0f, -2.625f, -10.0f, 6.0f, 8.0f, 10.0f, new CubeDeformation(0.0f)).m_171514_(100, 0).m_171488_(-3.0f, -2.125f, -8.0f, 6.0f, 7.0f, 8.0f, new CubeDeformation(0.0f)).m_171514_(0, 55).m_171488_(-2.5f, -6.625f, -5.0f, 5.0f, 4.0f, 5.0f, new CubeDeformation(0.0f)).m_171514_(4, 59).m_171488_(-2.5f, -6.625f, -6.0f, 5.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(88, 0).m_171488_(-2.5f, -5.125f, -5.0f, 5.0f, 3.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.925f, (float)-9.0f));
        PartDefinition fin = body.m_171599_("fin", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)-3.8916f, (float)3.8f, (float)-5.0257f));
        PartDefinition cube_r1 = fin.m_171599_("cube_r1", CubeListBuilder.m_171558_().m_171514_(20, 55).m_171488_(0.0f, -2.5f, 0.0f, 0.0f, 5.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.3916f, (float)-1.0f, (float)0.0257f, (float)0.0f, (float)-0.1309f, (float)0.0f));
        PartDefinition fin2 = body.m_171599_("fin2", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)3.5f, (float)3.8f, (float)-5.0f));
        PartDefinition cube_r2 = fin2.m_171599_("cube_r2", CubeListBuilder.m_171558_().m_171514_(58, 51).m_171488_(0.0f, -2.5f, 0.0f, 0.0f, 5.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-1.0f, (float)0.0f, (float)0.0f, (float)0.1309f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)128, (int)128);
    }

    private void dynamicTail(@NotNull NapoleonFishEntity pEntity) {
        float targetYaw = pEntity.prevTailRot + (pEntity.tailRot - pEntity.prevTailRot) * Minecraft.m_91087_().getPartialTick();
        this.tail.f_104204_ = Mth.m_14179_((float)0.05f, (float)this.tail.f_104204_, (float)targetYaw);
        this.fin_tail.f_104204_ = Mth.m_14179_((float)0.04f, (float)this.fin_tail.f_104204_, (float)targetYaw);
    }

    protected void applyBodyAndHeadRotation(float pNetHeadYaw, float pHeadPitch) {
        pNetHeadYaw = Mth.m_14036_((float)pNetHeadYaw, (float)-360.0f, (float)360.0f);
        pHeadPitch = Mth.m_14036_((float)pHeadPitch, (float)-360.0f, (float)360.0f);
        this.napoleon.f_104203_ = pHeadPitch * ((float)Math.PI / 180);
        this.napoleon.f_104204_ = pNetHeadYaw * ((float)Math.PI / 180);
    }

    public void setupAnim(@NotNull NapoleonFishEntity pEntity, float pLimbSwing, float pLimbSwingAmount, float pAgeInTicks, float pNetHeadYaw, float pHeadPitch) {
        this.m_142109_().m_171331_().forEach(ModelPart::m_233569_);
        this.dynamicTail(pEntity);
        this.applyBodyAndHeadRotation(pNetHeadYaw, pHeadPitch);
        if (pEntity.m_6069_() && !pEntity.m_6162_()) {
            this.m_267799_(NapoleonFishAnimations.SWIM, pLimbSwing, pLimbSwingAmount, 5.0f, 3.0f);
        }
        if (pEntity.m_6069_() && pEntity.m_6162_()) {
            this.m_267799_(NapoleonFishAnimations.SWIM, pLimbSwing, pLimbSwingAmount, 3.0f, 1.0f);
        }
        if (!pEntity.m_20072_()) {
            this.m_233381_(pEntity.flipAnimationState, FourEyedFishAnimations.FLOP, pAgeInTicks);
        }
        this.m_233381_(pEntity.flipAnimationState, NapoleonFishAnimations.FLOP, pAgeInTicks);
        float targetRoll = Math.max(-0.45f, Math.min(0.45f, (pEntity.m_146908_() - pEntity.f_19859_) * 0.1f));
        pEntity.currentRoll += (targetRoll - pEntity.currentRoll) * 0.05f;
        this.napoleon.f_104205_ = pEntity.currentRoll;
    }

    @NotNull
    public ModelPart m_142109_() {
        return this.napoleon;
    }
}

