/*
 * Decompiled with CFR 0.152.
 */
package net.reaper.vanimals.client.model.entity;

import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.reaper.vanimals.client.animations.entity.MudskipperAnimations;
import net.reaper.vanimals.common.entity.water.MudskipperEntity;
import net.reaper.vanimals.util.EntityUtils;
import org.jetbrains.annotations.NotNull;

public class MudskipperModel
extends HierarchicalModel<MudskipperEntity> {
    private final ModelPart root;
    private final ModelPart mudskipper;
    private final ModelPart body;
    private final ModelPart head;
    private final ModelPart top;
    private final ModelPart tail;

    public MudskipperModel(ModelPart root) {
        this.root = root.m_171324_("root");
        this.mudskipper = this.root.m_171324_("mudskipper");
        this.body = this.mudskipper.m_171324_("body");
        this.head = this.body.m_171324_("head");
        this.top = this.body.m_171324_("top");
        this.tail = this.top.m_171324_("tail");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition root = partdefinition.m_171599_("root", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition mudskipper = root.m_171599_("mudskipper", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition body = mudskipper.m_171599_("body", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition head = body.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 12).m_171488_(-2.5f, -2.5f, -5.0f, 5.0f, 4.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-1.5f, (float)-2.0f));
        PartDefinition eye = head.m_171599_("eye", CubeListBuilder.m_171558_().m_171514_(20, 15).m_171488_(-0.5f, -1.0f, -1.0f, 1.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-0.5f, (float)-2.5f, (float)-3.0f));
        PartDefinition eye2 = head.m_171599_("eye2", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-0.5f, -1.0f, -1.0f, 1.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.5f, (float)-2.5f, (float)-3.0f));
        PartDefinition top = body.m_171599_("top", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-1.5f, -1.5333f, -0.0333f, 3.0f, 3.0f, 9.0f, new CubeDeformation(0.0f)).m_171514_(24, 5).m_171488_(0.0f, -4.5333f, -0.0333f, 0.0f, 3.0f, 4.0f, new CubeDeformation(0.0f)).m_171514_(0, 16).m_171488_(0.0f, -3.5333f, 3.9667f, 0.0f, 6.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-1.4667f, (float)-1.9667f));
        PartDefinition fin = top.m_171599_("fin", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)1.5f, (float)0.9667f, (float)-0.0333f));
        PartDefinition cube_r1 = fin.m_171599_("cube_r1", CubeListBuilder.m_171558_().m_171514_(22, 1).m_171488_(0.0f, -1.5f, 0.0f, 5.0f, 3.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)-1.4357f, (float)-0.5066f, (float)0.1032f));
        PartDefinition fin2 = top.m_171599_("fin2", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)-1.5f, (float)0.9667f, (float)-0.0333f));
        PartDefinition cube_r2 = fin2.m_171599_("cube_r2", CubeListBuilder.m_171558_().m_171514_(22, 4).m_171488_(-5.0f, -1.5f, 0.0f, 5.0f, 3.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)-1.4357f, (float)0.5066f, (float)-0.1032f));
        PartDefinition tail = top.m_171599_("tail", CubeListBuilder.m_171558_().m_171514_(20, 13).m_171488_(0.0f, -2.0f, 0.0f, 0.0f, 4.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-0.5333f, (float)8.9667f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)32, (int)32);
    }

    private void dynamicTail(@NotNull MudskipperEntity pEntity) {
        float targetYaw = pEntity.prevTailRot + (pEntity.tailRot - pEntity.prevTailRot) * Minecraft.m_91087_().getPartialTick();
        this.top.f_104204_ = Mth.m_14179_((float)0.05f, (float)this.top.f_104204_, (float)targetYaw);
        this.tail.f_104204_ = Mth.m_14179_((float)0.04f, (float)this.tail.f_104204_, (float)targetYaw);
    }

    private void applyHeadRotation(MudskipperEntity pEntity, float netHeadYaw, float headPitch) {
        if (!pEntity.m_20072_()) {
            netHeadYaw = Mth.m_14036_((float)netHeadYaw, (float)-30.0f, (float)30.0f);
            headPitch = Mth.m_14036_((float)headPitch, (float)-30.0f, (float)30.0f);
            this.head.f_104204_ = netHeadYaw * ((float)Math.PI / 180);
            this.head.f_104203_ = headPitch * ((float)Math.PI / 180);
        }
    }

    protected void applyBodyAndHeadRotation(MudskipperEntity pEntity, float pNetHeadYaw, float pHeadPitch) {
        if (pEntity.m_20072_()) {
            pNetHeadYaw = Mth.m_14036_((float)pNetHeadYaw, (float)-360.0f, (float)360.0f);
            pHeadPitch = Mth.m_14036_((float)pHeadPitch, (float)-360.0f, (float)360.0f);
            this.body.f_104203_ = pHeadPitch * ((float)Math.PI / 180);
            this.body.f_104204_ = pNetHeadYaw * ((float)Math.PI / 180);
        }
    }

    public void setupAnim(@NotNull MudskipperEntity pEntity, float pLimbSwing, float pLimbSwingAmount, float pAgeInTicks, float pNetHeadYaw, float pHeadPitch) {
        this.m_142109_().m_171331_().forEach(ModelPart::m_233569_);
        this.dynamicTail(pEntity);
        this.applyHeadRotation(pEntity, pNetHeadYaw, pHeadPitch);
        this.applyBodyAndHeadRotation(pEntity, pNetHeadYaw, pHeadPitch);
        if (!pEntity.m_20072_() && !EntityUtils.isEntityMoving((Entity)pEntity, 0.05f)) {
            this.m_233381_(pEntity.idleAnimationState, MudskipperAnimations.IDLE, pAgeInTicks);
        }
        if (pEntity.m_20072_() && !EntityUtils.isEntityMoving((Entity)pEntity, 0.05f)) {
            this.m_233381_(pEntity.idlewaterAnimationState, MudskipperAnimations.IDLE_WATER, pAgeInTicks);
        }
        if (pEntity.m_20072_() || pEntity.m_6069_() && EntityUtils.isEntityMoving((Entity)pEntity, 0.05f)) {
            this.m_267799_(MudskipperAnimations.SWIM, pLimbSwing, pLimbSwingAmount, 3.0f, 1.0f);
        }
        if (!pEntity.m_20072_()) {
            this.m_267799_(MudskipperAnimations.WALK, pLimbSwing, pLimbSwingAmount, 7.0f, 5.0f);
        }
        if (pEntity.isOnMud()) {
            this.m_233381_(pEntity.rollingAnimatonState, MudskipperAnimations.ROLL, pAgeInTicks);
        }
        if (pEntity.isSearching()) {
            this.m_233381_(pEntity.searchingAnimatonState, MudskipperAnimations.BURROW, pAgeInTicks);
        }
        if (pEntity.isDancing()) {
            this.m_233381_(pEntity.dancingAnimatonState, MudskipperAnimations.DANCE, pAgeInTicks);
        }
        if (pEntity.m_20072_()) {
            float targetRoll = Math.max(-0.45f, Math.min(0.45f, (pEntity.m_146908_() - pEntity.f_19859_) * 0.1f));
            pEntity.currentRoll += (targetRoll - pEntity.currentRoll) * 0.05f;
            this.root.f_104205_ = pEntity.currentRoll;
        }
    }

    @NotNull
    public ModelPart m_142109_() {
        return this.root;
    }
}

