/*
 * Decompiled with CFR 0.152.
 */
package net.reaper.vanimals;

import com.mojang.logging.LogUtils;
import java.util.List;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.RegistryObject;
import net.reaper.vanimals.api.io.network.NetworkCreator;
import net.reaper.vanimals.client.VClientProxy;
import net.reaper.vanimals.client.model.ModLayers;
import net.reaper.vanimals.common.VCommonProxy;
import net.reaper.vanimals.common.network.packet_builder.PacketProcessor;
import net.reaper.vanimals.core.init.VCreativeModTabs;
import net.reaper.vanimals.core.init.VEntityData;
import net.reaper.vanimals.core.init.VEntityTypes;
import net.reaper.vanimals.core.init.VItems;
import net.reaper.vanimals.core.init.VMenuTypes;
import net.reaper.vanimals.core.init.VSoundEvents;
import net.reaper.vanimals.generated.PacketAutoRegistry;
import org.slf4j.Logger;

@Mod(value="vanimals")
public class Vanimals {
    public static final String MODID = "vanimals";
    public static final Logger LOGGER = LogUtils.getLogger();
    public static final NetworkCreator NETWORK = NetworkCreator.create("vanimals", 1);
    public static VCommonProxy PROXY = (VCommonProxy)DistExecutor.safeRunForDist(() -> VClientProxy::new, () -> VCommonProxy::new);

    public Vanimals() {
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        VCreativeModTabs.CREATIVE_MODE_TABS.register(bus);
        VItems.ITEMS.register(bus);
        VEntityTypes.ENTITY_TYPES.register(bus);
        VSoundEvents.SOUND_EVENTS.register(bus);
        VMenuTypes.register(bus);
        VEntityData.DATA.register(bus);
        bus.addListener(this::onCommonSetup);
        bus.addListener(this::onClientSetup);
        bus.addListener(ModLayers::onRegisterLayerDefinitions);
        bus.addListener(this::addCreative);
        PROXY.commonInitialize();
        PacketProcessor.registerHandlers();
    }

    private void onCommonSetup(FMLCommonSetupEvent pEvent) {
        PacketAutoRegistry.registerPackets(NETWORK);
    }

    private void onClientSetup(FMLClientSetupEvent pEvent) {
        pEvent.enqueueWork(() -> PROXY.clientInitialize());
    }

    private void addCreative(BuildCreativeModeTabContentsEvent event) {
        if (event.getTabKey() == CreativeModeTabs.f_256750_) {
            List<Item> items = VItems.ITEMS.getEntries().stream().map(RegistryObject::get).toList();
            for (Item item : items) {
                event.m_246326_((ItemLike)item);
            }
        }
    }
}

