/*
 * Decompiled with CFR 0.152.
 */
package com.dragn0007.chocobos.entities;

import com.dragn0007.chocobos.entities.AbstractChocobo;
import com.dragn0007.chocobos.entities.BreedModel;
import com.dragn0007.chocobos.entities.ChocoboMarkingLayer;
import com.dragn0007.chocobos.entities.ChocoboModel;
import com.dragn0007.chocobos.entities.EntityTypes;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Wolf;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.Vec3;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class Chocobo
extends AbstractChocobo
implements GeoEntity {
    public static final EntityDataAccessor<Integer> VARIANT = SynchedEntityData.m_135353_(Chocobo.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> OVERLAY = SynchedEntityData.m_135353_(Chocobo.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> BREED = SynchedEntityData.m_135353_(Chocobo.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private final AnimatableInstanceCache geoCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public Chocobo(EntityType<? extends Chocobo> type, Level level) {
        super(type, level);
    }

    public Vec3 m_7939_() {
        return new Vec3(0.0, (double)this.m_20192_() * (double)0.8f, (double)(this.m_20205_() * 1.2f));
    }

    public static AttributeSupplier.Builder createBaseChocoboAttributes() {
        return Mob.m_21552_().m_22266_(Attributes.f_22288_).m_22268_(Attributes.f_22276_, 60.0).m_22268_(Attributes.f_22279_, (double)0.255f).m_22268_(Attributes.f_22281_, 1.0);
    }

    public void randomizeAttributes() {
        this.m_21051_(Attributes.f_22276_).m_22100_((double)this.generateRandomMaxHealth());
        this.m_21051_(Attributes.f_22279_).m_22100_(this.generateRandomSpeed());
        this.m_21051_(Attributes.f_22288_).m_22100_(this.generateRandomJumpStrength());
    }

    public void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21345_.m_25352_(4, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.7));
        this.f_21345_.m_25352_(1, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.4, true));
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(7, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 0.0f));
        this.f_21345_.m_25352_(1, (Goal)new BreedGoal((Animal)this, 1.0, AbstractChocobo.class));
        this.f_21345_.m_25352_(4, (Goal)new FollowParentGoal((Animal)this, 1.25));
        this.f_21345_.m_25352_(1, (Goal)new AvoidEntityGoal((PathfinderMob)this, LivingEntity.class, 15.0f, (double)1.8f, (double)1.8f, livingEntity -> livingEntity instanceof Wolf));
    }

    public float generateRandomMaxHealth() {
        if (this.getModelResource().equals((Object)BreedModel.ROUNSEY.resourceLocation)) {
            float baseHealth = 16.0f;
            return baseHealth + (float)this.f_19796_.m_188503_(3) + (float)this.f_19796_.m_188503_(5);
        }
        if (this.getModelResource().equals((Object)BreedModel.DESTRIER.resourceLocation)) {
            float baseHealth = 20.0f;
            return baseHealth + (float)this.f_19796_.m_188503_(3) + (float)this.f_19796_.m_188503_(5);
        }
        if (this.getModelResource().equals((Object)BreedModel.KENNEL.resourceLocation)) {
            float baseHealth = 14.0f;
            return baseHealth + (float)this.f_19796_.m_188503_(3) + (float)this.f_19796_.m_188503_(5);
        }
        return 15.0f + (float)this.f_19796_.m_188503_(4) + (float)this.f_19796_.m_188503_(5);
    }

    public double generateRandomJumpStrength() {
        double baseStrength = 0.6f;
        double multiplier = this.f_19796_.m_188500_() * 0.2 + this.f_19796_.m_188500_() * 0.2 + this.f_19796_.m_188500_() * 0.25;
        if (this.getModelResource().equals((Object)BreedModel.ROUNSEY.resourceLocation)) {
            baseStrength = 0.6f;
            return baseStrength + multiplier;
        }
        if (this.getModelResource().equals((Object)BreedModel.DESTRIER.resourceLocation)) {
            baseStrength = 0.4f;
            return baseStrength + multiplier;
        }
        if (this.getModelResource().equals((Object)BreedModel.KENNEL.resourceLocation)) {
            baseStrength = 0.5;
            return baseStrength + multiplier;
        }
        return baseStrength + this.f_19796_.m_188500_() * 0.15;
    }

    public double generateRandomSpeed() {
        double baseSpeed = 0.0;
        double multiplier = (this.f_19796_.m_188500_() * 0.1 + this.f_19796_.m_188500_() * 0.1 + this.f_19796_.m_188500_() * 0.1) * 0.3;
        if (this.getModelResource().equals((Object)BreedModel.ROUNSEY.resourceLocation)) {
            baseSpeed = 0.2f;
            return baseSpeed + multiplier;
        }
        if (this.getModelResource().equals((Object)BreedModel.DESTRIER.resourceLocation)) {
            baseSpeed = 0.15f;
            return baseSpeed + multiplier;
        }
        if (this.getModelResource().equals((Object)BreedModel.KENNEL.resourceLocation)) {
            baseSpeed = 0.15f;
            return baseSpeed + multiplier;
        }
        return baseSpeed + multiplier;
    }

    protected boolean m_245259_() {
        return false;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 2, this::predicate)});
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "emoteController", 5, this::emotePredicate)});
    }

    private <T extends GeoAnimatable> PlayState predicate(AnimationState<T> tAnimationState) {
        double z;
        double x = this.m_20185_() - this.f_19854_;
        boolean isMoving = x * x + (z = this.m_20189_() - this.f_19856_) * z > 1.0E-4;
        double movementSpeed = this.m_21172_(Attributes.f_22279_);
        double animationSpeed = Math.max(0.1, movementSpeed);
        AnimationController controller = tAnimationState.getController();
        if (this.m_30616_()) {
            controller.setAnimation(RawAnimation.begin().then("jump", Animation.LoopType.PLAY_ONCE));
            controller.setAnimationSpeed(1.0);
        } else if (isMoving) {
            if (this.m_5912_() || this.m_20160_() && this.m_21051_(Attributes.f_22279_).m_22109_(SPRINT_SPEED_MOD)) {
                controller.setAnimation(RawAnimation.begin().then("Run_Faster_R", Animation.LoopType.LOOP));
                controller.setAnimationSpeed(Math.max(0.1, 0.82 * controller.getAnimationSpeed() + animationSpeed));
            } else if (this.m_20160_() && !this.m_21051_(Attributes.f_22279_).m_22109_(WALK_SPEED_MOD) && !this.m_21051_(Attributes.f_22279_).m_22109_(SPRINT_SPEED_MOD)) {
                controller.setAnimation(RawAnimation.begin().then("Run_R", Animation.LoopType.LOOP));
                controller.setAnimationSpeed(Math.max(0.1, 0.8 * controller.getAnimationSpeed() + animationSpeed));
            } else {
                controller.setAnimation(RawAnimation.begin().then("Walk_R", Animation.LoopType.LOOP));
                controller.setAnimationSpeed(Math.max(0.1, 0.84 * controller.getAnimationSpeed() + animationSpeed));
            }
        } else {
            if (this.m_20160_()) {
                controller.setAnimation(RawAnimation.begin().then("Idle_R", Animation.LoopType.LOOP));
            } else {
                controller.setAnimation(RawAnimation.begin().then("Idle_MoreBounce_R", Animation.LoopType.LOOP));
            }
            controller.setAnimationSpeed(1.0);
        }
        return PlayState.CONTINUE;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.geoCache;
    }

    @Override
    public void playEmote(String emoteName, String loopType) {
        AnimationController controller = (AnimationController)this.getAnimatableInstanceCache().getManagerForId((long)this.m_19879_()).getAnimationControllers().get("emoteController");
        controller.forceAnimationReset();
        controller.stop();
        controller.setAnimation(RawAnimation.begin().then(emoteName, Animation.LoopType.fromString((String)loopType)));
        this.shouldEmote = true;
    }

    private <T extends GeoAnimatable> PlayState emotePredicate(AnimationState<T> tAnimationState) {
        AnimationController controller = tAnimationState.getController();
        if (tAnimationState.isMoving() || !this.shouldEmote) {
            controller.forceAnimationReset();
            controller.stop();
            this.shouldEmote = false;
            return PlayState.STOP;
        }
        return PlayState.CONTINUE;
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_6254_() && !this.m_20160_() || this.m_21523_()) {
            this.m_21573_().m_26573_();
        }
    }

    public boolean m_7482_() {
        return this.getBreed() == 0;
    }

    public void m_19956_(Entity entity, Entity.MoveFunction moveFunction) {
        if (this.m_20363_(entity)) {
            double offsetX = 0.0;
            double offsetY = 1.6;
            double offsetZ = -0.3;
            if (this.getModelResource().equals((Object)BreedModel.ROUNSEY.resourceLocation)) {
                offsetY = 1.15;
            }
            if (this.getModelResource().equals((Object)BreedModel.DESTRIER.resourceLocation)) {
                offsetY = 1.55;
            }
            if (this.getModelResource().equals((Object)BreedModel.KENNEL.resourceLocation)) {
                offsetY = 0.65;
            }
            double radYaw = Math.toRadians(this.m_146908_());
            double offsetXRotated = offsetX * Math.cos(radYaw) - offsetZ * Math.sin(radYaw);
            double offsetYRotated = offsetY;
            double offsetZRotated = offsetX * Math.sin(radYaw) + offsetZ * Math.cos(radYaw);
            double x = this.m_20185_() + offsetXRotated;
            double y = this.m_20186_() + offsetYRotated;
            double z = this.m_20189_() + offsetZRotated;
            entity.m_6034_(x, y, z);
        }
    }

    public SoundEvent m_7515_() {
        super.m_7515_();
        return SoundEvents.f_11750_;
    }

    public SoundEvent m_5592_() {
        return SoundEvents.f_11751_;
    }

    @Nullable
    public SoundEvent m_7872_() {
        return SoundEvents.f_11976_;
    }

    public SoundEvent m_7975_(DamageSource damageSource) {
        super.m_7975_(damageSource);
        return SoundEvents.f_11753_;
    }

    public SoundEvent m_7871_() {
        super.m_7871_();
        return SoundEvents.f_11753_;
    }

    public ResourceLocation getTextureResource() {
        return ChocoboModel.Variant.variantFromOrdinal((int)this.getVariant()).resourceLocation;
    }

    public ResourceLocation getOverlayLocation() {
        return ChocoboMarkingLayer.Overlay.overlayFromOrdinal((int)this.getOverlayVariant()).resourceLocation;
    }

    public ResourceLocation getModelResource() {
        return BreedModel.breedFromOrdinal((int)this.getBreed()).resourceLocation;
    }

    public int getVariant() {
        return (Integer)this.f_19804_.m_135370_(VARIANT);
    }

    public int getOverlayVariant() {
        return (Integer)this.f_19804_.m_135370_(OVERLAY);
    }

    public int getBreed() {
        return (Integer)this.f_19804_.m_135370_(BREED);
    }

    public void setVariant(int variant) {
        this.f_19804_.m_135381_(VARIANT, (Object)variant);
    }

    public void setOverlayVariant(int variant) {
        this.f_19804_.m_135381_(OVERLAY, (Object)variant);
    }

    public void setBreed(int breed) {
        this.f_19804_.m_135381_(BREED, (Object)breed);
    }

    @Override
    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        if (tag.m_128441_("Variant")) {
            this.setVariant(tag.m_128451_("Variant"));
        }
        if (tag.m_128441_("Overlay")) {
            this.setOverlayVariant(tag.m_128451_("Overlay"));
        }
        if (tag.m_128441_("Breed")) {
            this.setBreed(tag.m_128451_("Breed"));
        }
        this.m_30625_();
        if (this.m_30502_()) {
            ListTag listtag = tag.m_128437_("Items", 10);
            for (int i = 0; i < listtag.size(); ++i) {
                CompoundTag compoundtag = listtag.m_128728_(i);
                int j = compoundtag.m_128445_("Slot") & 0xFF;
                if (j < 2 || j >= this.f_30520_.m_6643_()) continue;
                this.f_30520_.m_6836_(j, ItemStack.m_41712_((CompoundTag)compoundtag));
            }
        }
        this.m_7493_();
    }

    @Override
    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128405_("Variant", this.getVariant());
        tag.m_128405_("Overlay", this.getOverlayVariant());
        tag.m_128405_("Breed", this.getBreed());
        if (this.m_30502_()) {
            ListTag listtag = new ListTag();
            for (int i = 2; i < this.f_30520_.m_6643_(); ++i) {
                ItemStack itemstack = this.f_30520_.m_8020_(i);
                if (itemstack.m_41619_()) continue;
                CompoundTag compoundtag = new CompoundTag();
                compoundtag.m_128344_("Slot", (byte)i);
                itemstack.m_41739_(compoundtag);
                listtag.add((Object)compoundtag);
            }
            tag.m_128365_("Items", (Tag)listtag);
        }
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor serverLevelAccessor, DifficultyInstance instance, MobSpawnType spawnType, @Nullable SpawnGroupData data, @Nullable CompoundTag tag) {
        if (data == null) {
            data = new AgeableMob.AgeableMobGroupData(0.2f);
        }
        Random random = new Random();
        this.setVariant(random.nextInt(ChocoboModel.Variant.values().length));
        this.setOverlayVariant(random.nextInt(ChocoboMarkingLayer.Overlay.values().length));
        this.setBreed(random.nextInt(BreedModel.values().length));
        this.randomizeAttributes();
        return super.m_6518_(serverLevelAccessor, instance, spawnType, data, tag);
    }

    @Override
    public void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(VARIANT, (Object)0);
        this.f_19804_.m_135372_(OVERLAY, (Object)0);
        this.f_19804_.m_135372_(BREED, (Object)0);
    }

    public boolean m_7848_(Animal animal) {
        if (animal == this) {
            return false;
        }
        if (!(animal instanceof Chocobo)) {
            return false;
        }
        return this.m_30628_() && ((AbstractChocobo)animal).m_30628_();
    }

    public AgeableMob m_142606_(ServerLevel serverLevel, AgeableMob ageableMob) {
        Chocobo chocobo = (Chocobo)ageableMob;
        AbstractChocobo abstractChocobo = (AbstractChocobo)((EntityType)EntityTypes.CHOCOBO_ENTITY.get()).m_20615_((Level)serverLevel);
        int i = this.f_19796_.m_188503_(9);
        int variant = i < 4 ? this.getVariant() : (i < 8 ? chocobo.getVariant() : this.f_19796_.m_188503_(ChocoboModel.Variant.values().length));
        int j = this.f_19796_.m_188503_(5);
        int overlay = j < 2 ? this.getOverlayVariant() : (j < 4 ? chocobo.getOverlayVariant() : this.f_19796_.m_188503_(ChocoboMarkingLayer.Overlay.values().length));
        int k = this.f_19796_.m_188503_(4);
        int breed = k == 0 ? this.f_19796_.m_188503_(BreedModel.values().length) : (this.f_19796_.m_188503_(2) == 0 ? this.getBreed() : chocobo.getBreed());
        ((Chocobo)abstractChocobo).setVariant(variant);
        ((Chocobo)abstractChocobo).setOverlayVariant(overlay);
        ((Chocobo)abstractChocobo).setBreed(breed);
        if (this.f_19796_.m_188503_(4) == 0) {
            int randomJumpStrength = (int)Math.max(chocobo.generateRandomJumpStrength(), (double)(this.f_19796_.m_188503_(10) + 10));
            ((Chocobo)abstractChocobo).generateRandomJumpStrength();
            int betterSpeed = (int)Math.max(chocobo.m_6113_(), (float)(this.f_19796_.m_188503_(10) + 20));
            ((Chocobo)abstractChocobo).m_7910_(betterSpeed);
            int betterHealth = (int)Math.max(chocobo.m_21223_(), (float)(this.f_19796_.m_188503_(20) + 40));
            ((Chocobo)abstractChocobo).m_21153_(betterHealth);
        } else {
            ((Chocobo)abstractChocobo).m_7910_(chocobo.m_6113_());
            ((Chocobo)abstractChocobo).m_21153_(chocobo.m_21223_());
        }
        if (k == 0) {
            chocobo.randomizeAttributes();
        }
        this.m_149508_(ageableMob, (AbstractHorse)abstractChocobo);
        return abstractChocobo;
    }
}

