/*
 * Decompiled with CFR 0.152.
 */
package com.dragn0007.chocobos.entities;

import com.dragn0007.chocobos.gui.ChocoboMenu;
import com.dragn0007.chocobos.items.ChocoboArmorItem;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.horse.AbstractChestedHorse;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.SaddleItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.WoolCarpetBlock;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;

public abstract class AbstractChocobo
extends AbstractChestedHorse {
    public static final UUID ARMOR_MODIFIER_UUID = UUID.fromString("3c50e848-b2e3-404a-9879-7550b12dd09b");
    public static final UUID SPRINT_SPEED_MOD_UUID = UUID.fromString("c9379664-01b5-4e19-a7e9-11264453bdce");
    public static final UUID WALK_SPEED_MOD_UUID = UUID.fromString("59b55c98-e39b-45e2-846c-f91f3e9ea861");
    public static final AttributeModifier SPRINT_SPEED_MOD = new AttributeModifier(SPRINT_SPEED_MOD_UUID, "Sprint speed mod", 0.3, AttributeModifier.Operation.MULTIPLY_TOTAL);
    public static final AttributeModifier WALK_SPEED_MOD = new AttributeModifier(WALK_SPEED_MOD_UUID, "Walk speed mod", -0.7, AttributeModifier.Operation.MULTIPLY_TOTAL);
    public static final EntityDataAccessor<Integer> DATA_CARPET_ID = SynchedEntityData.m_135353_(AbstractChocobo.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    protected boolean shouldEmote;
    private static final EntityDataAccessor<Boolean> DATA_ID_CHEST = SynchedEntityData.m_135353_(AbstractChocobo.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);

    public AbstractChocobo(EntityType<? extends AbstractChocobo> entityType, Level level) {
        super(entityType, level);
    }

    public abstract void playEmote(String var1, String var2);

    public void openInventory(Player player) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (this.m_30614_()) {
                NetworkHooks.openScreen((ServerPlayer)serverPlayer, (MenuProvider)new SimpleMenuProvider((containerId, inventory, p) -> new ChocoboMenu(containerId, inventory, (Container)this.f_30520_, this), this.m_5446_()), data -> {
                    data.writeInt(this.m_7506_());
                    data.writeInt(this.m_19879_());
                });
            }
        }
    }

    public boolean m_30628_() {
        return !this.m_20160_() && !this.m_20159_() && this.m_30614_() && !this.m_6162_() && this.m_21223_() >= this.m_21233_() && this.m_27593_();
    }

    public boolean m_6741_() {
        return this.m_6084_() && !this.m_6162_() && this.m_30614_();
    }

    public boolean isSaddle(ItemStack itemStack) {
        return itemStack.m_41720_() instanceof SaddleItem;
    }

    public void m_5853_(@Nullable SoundSource p_30546_) {
        this.f_30520_.m_6836_(0, new ItemStack((ItemLike)Items.f_42450_));
    }

    public boolean m_30502_() {
        return (Boolean)this.f_19804_.m_135370_(DATA_ID_CHEST);
    }

    public void m_30504_(boolean p_30505_) {
        this.f_19804_.m_135381_(DATA_ID_CHEST, (Object)p_30505_);
    }

    public boolean m_6254_() {
        return this.m_30647_(4);
    }

    public boolean m_6010_(ItemStack itemStack) {
        return itemStack.m_41720_() instanceof ChocoboArmorItem;
    }

    public double m_6048_() {
        return super.m_6048_() - 0.25;
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack itemStack = player.m_21120_(hand);
        if (itemStack.m_150930_(Items.f_42574_) && player.m_6144_() && this.m_30502_()) {
            this.m_5907_();
            this.f_30520_.m_19195_();
            this.m_30504_(false);
            this.m_7609_();
            return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
        }
        if (!this.m_6162_()) {
            if (this.m_30614_() && player.m_36341_()) {
                this.openInventory(player);
                return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
            }
            if (this.m_20160_()) {
                return super.m_6071_(player, hand);
            }
        }
        if (!itemStack.m_41619_()) {
            boolean canSaddle;
            if (this.m_6898_(itemStack)) {
                return this.m_30580_(player, itemStack);
            }
            InteractionResult interactionResult = itemStack.m_41647_(player, (LivingEntity)this, hand);
            if (interactionResult.m_19077_()) {
                return interactionResult;
            }
            if (!this.m_30614_()) {
                this.m_7564_();
                return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
            }
            if (!this.m_30502_() && itemStack.m_150930_(Blocks.f_50087_.m_5456_())) {
                this.m_30504_(true);
                this.m_7609_();
                if (!player.m_150110_().f_35937_) {
                    itemStack.m_41774_(1);
                }
                this.m_30625_();
                return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
            }
            boolean bl = canSaddle = !this.m_6162_() && !this.m_6254_() && this.isSaddle(itemStack);
            if (this.m_6010_(itemStack) || canSaddle) {
                this.openInventory(player);
                return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
            }
        }
        if (this.m_6162_()) {
            return super.m_6071_(player, hand);
        }
        this.m_6835_(player);
        return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
    }

    public void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_CARPET_ID, (Object)-1);
        this.f_19804_.m_135372_(DATA_ID_CHEST, (Object)false);
    }

    public void m_7380_(CompoundTag compoundTag) {
        super.m_7380_(compoundTag);
        if (!this.f_30520_.m_8020_(1).m_41619_()) {
            compoundTag.m_128365_("ArmorItem", (Tag)this.f_30520_.m_8020_(1).m_41739_(new CompoundTag()));
        }
        if (!this.f_30520_.m_8020_(0).m_41619_()) {
            compoundTag.m_128365_("DecorItem", (Tag)this.f_30520_.m_8020_(1).m_41739_(new CompoundTag()));
        }
        if (!this.f_30520_.m_8020_(0).m_41619_()) {
            compoundTag.m_128365_("SaddleItem", (Tag)this.f_30520_.m_8020_(0).m_41739_(new CompoundTag()));
        }
        compoundTag.m_128379_("ChestedHorse", this.m_30502_());
        if (this.m_30502_()) {
            ListTag listTag = new ListTag();
        }
    }

    public void m_7378_(CompoundTag compoundTag) {
        ItemStack itemstack;
        ItemStack itemStack;
        super.m_7378_(compoundTag);
        if (compoundTag.m_128425_("ArmorItem", 10) && !(itemStack = ItemStack.m_41712_((CompoundTag)compoundTag.m_128469_("ArmorItem"))).m_41619_() && this.m_6010_(itemStack)) {
            this.f_30520_.m_6836_(1, itemStack);
        }
        if (compoundTag.m_128425_("DecorItem", 10)) {
            this.f_30520_.m_6836_(1, ItemStack.m_41712_((CompoundTag)compoundTag.m_128469_("DecorItem")));
        }
        if (compoundTag.m_128425_("SaddleItem", 10) && (itemstack = ItemStack.m_41712_((CompoundTag)compoundTag.m_128469_("SaddleItem"))).m_150930_(Items.f_42450_)) {
            this.f_30520_.m_6836_(0, itemstack);
        }
        this.m_30504_(compoundTag.m_128471_("ChestedHorse"));
        this.m_7493_();
    }

    public void m_5877_(SoundType soundType) {
        ItemStack itemStack;
        super.m_5877_(soundType);
        this.m_5496_(SoundEvents.f_12463_, soundType.m_56773_() * 0.15f, soundType.m_56774_());
        if (this.f_19796_.m_188503_(10) == 0) {
            this.m_5496_(SoundEvents.f_11974_, soundType.m_56773_() * 0.6f, soundType.m_56774_());
        }
        if (this.m_6010_(itemStack = this.f_30520_.m_8020_(1))) {
            itemStack.onHorseArmorTick(this.m_9236_(), (Mob)this);
        }
    }

    public ItemStack getArmor() {
        return this.m_6844_(EquipmentSlot.CHEST);
    }

    public void setArmor(ItemStack itemStack) {
        this.m_8061_(EquipmentSlot.CHEST, itemStack);
        this.m_21409_(EquipmentSlot.CHEST, 0.0f);
    }

    public void setArmorEquipment(ItemStack itemStack) {
        this.setArmor(itemStack);
        if (!this.m_9236_().f_46443_) {
            ChocoboArmorItem ChocoboArmorItem2;
            int protection;
            this.m_21051_(Attributes.f_22284_).m_22120_(ARMOR_MODIFIER_UUID);
            Item item = itemStack.m_41720_();
            if (item instanceof ChocoboArmorItem && (protection = (ChocoboArmorItem2 = (ChocoboArmorItem)item).getProtection()) > 0) {
                this.m_21051_(Attributes.f_22284_).m_22118_(new AttributeModifier(ARMOR_MODIFIER_UUID, "Chocobo armor bonus", (double)protection, AttributeModifier.Operation.ADDITION));
            }
        }
    }

    public void m_7493_() {
        super.m_7493_();
        this.setArmorEquipment(this.f_30520_.m_8020_(1));
        this.m_21409_(EquipmentSlot.CHEST, 0.0f);
        if (!this.m_9236_().f_46443_) {
            super.m_7493_();
            this.setCarpet(AbstractChocobo.getDyeColor(this.f_30520_.m_8020_(1)));
        }
    }

    public void setCarpet(@Nullable DyeColor p_30772_) {
        this.f_19804_.m_135381_(DATA_CARPET_ID, (Object)(p_30772_ == null ? -1 : p_30772_.m_41060_()));
    }

    @Nullable
    public static DyeColor getDyeColor(ItemStack p_30836_) {
        Block block = Block.m_49814_((Item)p_30836_.m_41720_());
        return block instanceof WoolCarpetBlock ? ((WoolCarpetBlock)block).m_58309_() : null;
    }

    @Nullable
    public DyeColor getCarpet() {
        int i = (Integer)this.f_19804_.m_135370_(DATA_CARPET_ID);
        return i == -1 ? null : DyeColor.m_41053_((int)i);
    }

    public void m_5757_(Container container) {
        ItemStack prevArmor = this.getArmor();
        super.m_5757_(container);
        ItemStack newArmor = this.getArmor();
        if (this.f_19797_ > 20 && this.m_6010_(newArmor) && prevArmor != newArmor) {
            this.m_5496_(SoundEvents.f_11973_, 0.5f, 1.0f);
        }
    }

    public Vec3 m_7688_(LivingEntity livingEntity) {
        this.m_21051_(Attributes.f_22279_).m_22130_(SPRINT_SPEED_MOD);
        this.m_21051_(Attributes.f_22279_).m_22130_(WALK_SPEED_MOD);
        return super.m_7688_(livingEntity);
    }

    public void handleSpeedRequest(int speedMod) {
        AttributeInstance movementSpeed = this.m_21051_(Attributes.f_22279_);
        if (speedMod == -1 && movementSpeed.m_22109_(SPRINT_SPEED_MOD)) {
            movementSpeed.m_22130_(SPRINT_SPEED_MOD);
        } else if (speedMod == -1 && !movementSpeed.m_22109_(WALK_SPEED_MOD)) {
            movementSpeed.m_22118_(WALK_SPEED_MOD);
        } else if (speedMod == 1 && movementSpeed.m_22109_(WALK_SPEED_MOD)) {
            movementSpeed.m_22130_(WALK_SPEED_MOD);
        } else if (speedMod == 1 && !movementSpeed.m_22109_(SPRINT_SPEED_MOD)) {
            movementSpeed.m_22118_(SPRINT_SPEED_MOD);
        }
    }
}

