/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.kleeslabs;

import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.balm.api.event.BreakBlockEvent;
import net.blay09.mods.kleeslabs.KleeSlabs;
import net.blay09.mods.kleeslabs.converter.HorizontalSlabConverter;
import net.blay09.mods.kleeslabs.converter.SlabConverter;
import net.blay09.mods.kleeslabs.converter.VerticalSlabConverter;
import net.blay09.mods.kleeslabs.registry.SlabRegistry;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class BlockBreakHandler {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void onBreakBlock(BreakBlockEvent event) {
        Item slabItem;
        BlockState newState;
        BlockState dropState;
        BlockState state;
        SlabConverter slabConverter;
        Vec3 hitVec;
        if (Balm.getHooks().isFakePlayer(event.getPlayer())) {
            return;
        }
        if (!KleeSlabs.isPlayerKleeSlabbing(event.getPlayer())) {
            return;
        }
        BlockHitResult rayTraceResult = BlockBreakHandler.rayTrace((LivingEntity)event.getPlayer(), Balm.getHooks().getBlockReachDistance(event.getPlayer()));
        Direction hitSide = rayTraceResult.m_82434_();
        Vec3 vec3 = hitVec = rayTraceResult.m_6662_() == HitResult.Type.BLOCK ? rayTraceResult.m_82450_() : null;
        if (hitVec != null) {
            hitVec = hitVec.m_82520_((double)(-event.getPos().m_123341_()), (double)(-event.getPos().m_123342_()), (double)(-event.getPos().m_123343_()));
        }
        if ((slabConverter = SlabRegistry.getSlabConverter((state = event.getState()).m_60734_())) == null || !slabConverter.isDoubleSlab(state)) {
            return;
        }
        if (slabConverter instanceof HorizontalSlabConverter) {
            SlabType stay;
            SlabType hit;
            HorizontalSlabConverter horizontalSlabConverter = (HorizontalSlabConverter)slabConverter;
            if (hitVec != null && hitVec.f_82480_ > 0.5) {
                hit = SlabType.TOP;
                stay = SlabType.BOTTOM;
            } else {
                stay = SlabType.TOP;
                hit = SlabType.BOTTOM;
            }
            dropState = horizontalSlabConverter.getSingleSlab(event.getState(), event.getLevel(), event.getPos(), event.getPlayer(), hit);
            newState = horizontalSlabConverter.getSingleSlab(event.getState(), event.getLevel(), event.getPos(), event.getPlayer(), stay);
        } else {
            if (!(slabConverter instanceof VerticalSlabConverter)) return;
            VerticalSlabConverter verticalSlabConverter = (VerticalSlabConverter)slabConverter;
            if (hitSide.m_122434_() == Direction.Axis.Y) return;
            dropState = verticalSlabConverter.getSingleSlab(event.getState(), event.getLevel(), event.getPos(), event.getPlayer(), hitSide.m_122424_());
            newState = verticalSlabConverter.getSingleSlab(event.getState(), event.getLevel(), event.getPos(), event.getPlayer(), hitSide);
        }
        Level level = event.getLevel();
        if (!level.m_5776_() && event.getPlayer().m_36298_(dropState) && !event.getPlayer().m_150110_().f_35937_ && (slabItem = Item.m_41439_((Block)dropState.m_60734_())) != Items.f_41852_) {
            ItemStack itemStack = new ItemStack((ItemLike)slabItem);
            float scale = 0.7f;
            double xOffset = (double)(level.m_213780_().m_188501_() * scale + 1.0f) - (double)scale * 0.5;
            double yOffset = (double)(level.m_213780_().m_188501_() * scale + 1.0f) - (double)scale * 0.5;
            double zOffset = (double)(level.m_213780_().m_188501_() * scale + 1.0f) - (double)scale * 0.5;
            ItemEntity entityItem = new ItemEntity(level, (double)event.getPos().m_123341_() + xOffset, (double)event.getPos().m_123342_() + yOffset, (double)event.getPos().m_123343_() + zOffset, itemStack);
            entityItem.m_32010_(10);
            level.m_7967_((Entity)entityItem);
        }
        event.getLevel().m_7731_(event.getPos(), newState, 3);
        event.setCanceled(true);
    }

    public static BlockHitResult rayTrace(LivingEntity entity, double length) {
        Vec3 startPos = new Vec3(entity.m_20185_(), entity.m_20186_() + (double)entity.m_20192_(), entity.m_20189_());
        Vec3 endPos = startPos.m_82520_(entity.m_20154_().f_82479_ * length, entity.m_20154_().f_82480_ * length, entity.m_20154_().f_82481_ * length);
        ClipContext rayTraceContext = new ClipContext(startPos, endPos, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)entity);
        return entity.m_9236_().m_45547_(rayTraceContext);
    }
}

