/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.util.datafixer;

import com.google.common.collect.ImmutableMap;
import com.tacz.guns.api.DefaultAssets;
import com.tacz.guns.api.item.nbt.AttachmentItemDataAccessor;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;

public final class AttachmentIdFix {
    public static final Map<ResourceLocation, ResourceLocation> OLD_TO_NEW = ImmutableMap.builder().put((Object)new ResourceLocation("tacz", "muzzle_silence_knight_qd"), (Object)new ResourceLocation("tacz", "muzzle_silencer_knight_qd")).put((Object)new ResourceLocation("tacz", "muzzle_silence_mirage"), (Object)new ResourceLocation("tacz", "muzzle_silencer_mirage")).put((Object)new ResourceLocation("tacz", "muzzle_silence_phantom_s1"), (Object)new ResourceLocation("tacz", "muzzle_silencer_phantom_s1")).put((Object)new ResourceLocation("tacz", "muzzle_silence_ptilopsis"), (Object)new ResourceLocation("tacz", "muzzle_silencer_ptilopsis")).put((Object)new ResourceLocation("tacz", "muzzle_silence_ursus"), (Object)new ResourceLocation("tacz", "muzzle_silencer_ursus")).put((Object)new ResourceLocation("tacz", "muzzle_silence_vulture"), (Object)new ResourceLocation("tacz", "muzzle_silencer_vulture")).build();

    private AttachmentIdFix() {
    }

    public static boolean updateAttachmentIdInTag(CompoundTag tag) {
        ResourceLocation fixed;
        ResourceLocation old = AttachmentItemDataAccessor.getAttachmentIdFromTag(tag);
        if (!old.equals((Object)DefaultAssets.EMPTY_ATTACHMENT_ID) && !old.equals((Object)(fixed = AttachmentIdFix.updateAttachmentId(old)))) {
            tag.m_128359_("AttachmentId", fixed.toString());
            return true;
        }
        return false;
    }

    public static ResourceLocation updateAttachmentId(ResourceLocation old) {
        return OLD_TO_NEW.getOrDefault(old, old);
    }
}

