/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.mixin.client.ar;

import com.github.argon4w.acceleratedrendering.core.buffers.accelerated.builders.IAcceleratedVertexConsumer;
import com.github.argon4w.acceleratedrendering.core.buffers.accelerated.builders.IBufferGraph;
import com.github.argon4w.acceleratedrendering.core.buffers.accelerated.builders.VertexConsumerExtension;
import com.github.argon4w.acceleratedrendering.core.buffers.accelerated.renderers.IAcceleratedRenderer;
import com.github.argon4w.acceleratedrendering.core.meshes.IMesh;
import com.github.argon4w.acceleratedrendering.core.meshes.collectors.CulledMeshCollector;
import com.github.argon4w.acceleratedrendering.core.meshes.collectors.IMeshCollector;
import com.github.argon4w.acceleratedrendering.features.entities.AcceleratedEntityRenderingFeature;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.tacz.guns.client.model.bedrock.BedrockCube;
import com.tacz.guns.client.model.bedrock.BedrockPart;
import com.tacz.guns.compat.ar.ARCompat;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectList;
import java.util.Map;
import net.minecraft.util.FastColor;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={BedrockPart.class})
public class BedrockPartMixin
implements IAcceleratedRenderer<Void> {
    @Unique
    private static final PoseStack.Pose POSE = new PoseStack().m_85850_();
    @Unique
    private final Map<IBufferGraph, IMesh> meshes = new Object2ObjectOpenHashMap();
    @Shadow(remap=false)
    @Final
    public ObjectList<BedrockCube> cubes;

    @Inject(method={"compile"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    public void compileFast(PoseStack.Pose pose, VertexConsumer consumer, int texU, int texV, float red, float green, float blue, float alpha, CallbackInfo ci) {
        IAcceleratedVertexConsumer extension = VertexConsumerExtension.getAccelerated((VertexConsumer)consumer);
        if (ARCompat.shouldAccelerate() && extension.isAccelerated()) {
            ci.cancel();
            int color = FastColor.ARGB32.m_13660_((int)((int)(alpha * 255.0f)), (int)((int)(red * 255.0f)), (int)((int)(green * 255.0f)), (int)((int)(blue * 255.0f)));
            extension.doRender((IAcceleratedRenderer)this, null, pose.m_252922_(), pose.m_252943_(), texU, texV, color);
        }
    }

    @Unique
    public void render(VertexConsumer consumer, Void context, Matrix4f transform, Matrix3f normal, int light, int overlay, int color) {
        IAcceleratedVertexConsumer extension = VertexConsumerExtension.getAccelerated((VertexConsumer)consumer);
        IMesh mesh = this.meshes.get(extension);
        extension.beginTransform(transform, normal);
        if (mesh != null) {
            mesh.write(extension, color, light, overlay);
            extension.endTransform();
            return;
        }
        CulledMeshCollector culledMeshCollector = new CulledMeshCollector(extension);
        VertexConsumer meshBuilder = extension.decorate((VertexConsumer)culledMeshCollector);
        for (BedrockCube cube : this.cubes) {
            cube.compile(POSE, meshBuilder, 0, overlay, 1.0f, 1.0f, 1.0f, 1.0f);
        }
        culledMeshCollector.flush();
        mesh = AcceleratedEntityRenderingFeature.getMeshType().getBuilder().build((IMeshCollector)culledMeshCollector);
        this.meshes.put((IBufferGraph)extension, mesh);
        mesh.write(extension, color, light, overlay);
        extension.endTransform();
    }
}

