/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.client.resource;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.tacz.guns.api.client.animation.AnimationController;
import com.tacz.guns.api.client.animation.Animations;
import com.tacz.guns.api.client.animation.ObjectAnimation;
import com.tacz.guns.api.client.animation.gltf.AnimationStructure;
import com.tacz.guns.api.client.animation.statemachine.LuaAnimationStateMachine;
import com.tacz.guns.api.client.animation.statemachine.LuaStateMachineFactory;
import com.tacz.guns.api.client.other.GunModelTypeManager;
import com.tacz.guns.api.item.gun.FireMode;
import com.tacz.guns.client.animation.statemachine.GunAnimationStateContext;
import com.tacz.guns.client.model.BedrockGunModel;
import com.tacz.guns.client.resource.ClientAssetsManager;
import com.tacz.guns.client.resource.InternalAssetLoader;
import com.tacz.guns.client.resource.pojo.animation.bedrock.BedrockAnimationFile;
import com.tacz.guns.client.resource.pojo.display.LaserConfig;
import com.tacz.guns.client.resource.pojo.display.ammo.AmmoParticle;
import com.tacz.guns.client.resource.pojo.display.gun.AmmoCountStyle;
import com.tacz.guns.client.resource.pojo.display.gun.ControllableData;
import com.tacz.guns.client.resource.pojo.display.gun.DamageStyle;
import com.tacz.guns.client.resource.pojo.display.gun.DefaultAnimationType;
import com.tacz.guns.client.resource.pojo.display.gun.GunAmmo;
import com.tacz.guns.client.resource.pojo.display.gun.GunDisplay;
import com.tacz.guns.client.resource.pojo.display.gun.GunLod;
import com.tacz.guns.client.resource.pojo.display.gun.GunTransform;
import com.tacz.guns.client.resource.pojo.display.gun.LayerGunShow;
import com.tacz.guns.client.resource.pojo.display.gun.MuzzleFlash;
import com.tacz.guns.client.resource.pojo.display.gun.ShellEjection;
import com.tacz.guns.client.resource.pojo.model.BedrockModelPOJO;
import com.tacz.guns.client.resource.pojo.model.BedrockVersion;
import com.tacz.guns.sound.SoundManager;
import com.tacz.guns.util.ColorHex;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.commands.arguments.ParticleArgument;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Nullable;
import org.luaj.vm2.LuaTable;
import org.luaj.vm2.lib.jse.CoerceJavaToLua;

@OnlyIn(value=Dist.CLIENT)
public class GunDisplayInstance {
    private String thirdPersonAnimation = "empty";
    private BedrockGunModel gunModel;
    @Nullable
    private Pair<BedrockGunModel, ResourceLocation> lodModel;
    private LuaAnimationStateMachine<GunAnimationStateContext> animationStateMachine;
    @Nullable
    private LuaTable stateMachineParam;
    @Nullable
    private ResourceLocation playerAnimator3rd = new ResourceLocation("tacz", "rifle_default.player_animation");
    private boolean is3rdFixedHand = false;
    private Map<String, ResourceLocation> sounds;
    private GunTransform transform;
    private ResourceLocation modelTexture;
    private ResourceLocation slotTexture;
    private ResourceLocation hudTexture;
    @Nullable
    private ResourceLocation hudEmptyTexture;
    @Nullable
    private ShellEjection shellEjection;
    @Nullable
    private MuzzleFlash muzzleFlash;
    private LayerGunShow offhandShow;
    @Nullable
    private Int2ObjectArrayMap<LayerGunShow> hotbarShow;
    private float ironZoom;
    private float zoomModelFov;
    private boolean showCrosshair = false;
    @Nullable
    private AmmoParticle particle;
    private float @Nullable [] tracerColor = null;
    private EnumMap<FireMode, ControllableData> controllableData;
    private AmmoCountStyle ammoCountStyle = AmmoCountStyle.NORMAL;
    private DamageStyle damageStyle = DamageStyle.PER_PROJECTILE;
    @Nullable
    private LaserConfig laserConfig;

    GunDisplayInstance(GunDisplay display) {
        this.checkTextureAndModel(display);
        this.checkLod(display);
        this.checkSlotTexture(display);
        this.checkHUDTexture(display);
        this.checkAnimation(display);
        this.checkSounds(display);
        this.checkTransform(display);
        this.checkShellEjection(display);
        this.checkGunAmmo(display);
        this.checkMuzzleFlash(display);
        this.checkLayerGunShow(display);
        this.checkIronZoom(display);
        this.checkTextShow(display);
        this.checkZoomModelFov(display);
        this.showCrosshair = display.isShowCrosshair();
        this.controllableData = display.getControllableData();
        this.ammoCountStyle = display.getAmmoCountStyle();
        this.damageStyle = display.getDamageStyle();
        this.laserConfig = display.getLaserConfig();
    }

    public static GunDisplayInstance create(GunDisplay display) throws IllegalArgumentException {
        return new GunDisplayInstance(display);
    }

    private void checkIronZoom(GunDisplay display) {
        this.ironZoom = display.getIronZoom();
        if (this.ironZoom < 1.0f) {
            this.ironZoom = 1.0f;
        }
    }

    private void checkZoomModelFov(GunDisplay display) {
        this.zoomModelFov = display.getZoomModelFov();
        if (this.zoomModelFov > 70.0f) {
            this.zoomModelFov = 70.0f;
        }
    }

    private void checkTextShow(GunDisplay display) {
        HashMap textShowMap = Maps.newHashMap();
        display.getTextShows().forEach((key, value) -> {
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{key})) {
                int color = ColorHex.colorTextToRbgInt(value.getColorText());
                value.setColorInt(color);
                textShowMap.put(key, value);
            }
        });
        this.gunModel.setTextShowList(textShowMap);
    }

    private void checkTextureAndModel(GunDisplay display) {
        String modelType = display.getModelType();
        BiFunction<BedrockModelPOJO, BedrockVersion, ? extends BedrockGunModel> constructor = GunModelTypeManager.getModelInstanceConstructor(modelType);
        ResourceLocation modelLocation = display.getModelLocation();
        Preconditions.checkArgument((modelLocation != null ? 1 : 0) != 0, (Object)"display object missing model field");
        BedrockModelPOJO modelPOJO = ClientAssetsManager.INSTANCE.getBedrockModelPOJO(modelLocation);
        Preconditions.checkArgument((modelPOJO != null ? 1 : 0) != 0, (Object)"there is no corresponding model file");
        ResourceLocation textureLocation = display.getModelTexture();
        Preconditions.checkArgument((textureLocation != null ? 1 : 0) != 0, (Object)"missing default texture");
        this.modelTexture = textureLocation;
        if (BedrockVersion.isLegacyVersion(modelPOJO) && modelPOJO.getGeometryModelLegacy() != null) {
            this.gunModel = constructor.apply(modelPOJO, BedrockVersion.LEGACY);
        }
        if (BedrockVersion.isNewVersion(modelPOJO) && modelPOJO.getGeometryModelNew() != null) {
            this.gunModel = constructor.apply(modelPOJO, BedrockVersion.NEW);
        }
        Preconditions.checkArgument((this.gunModel != null ? 1 : 0) != 0, (Object)"there is no model data in the model file");
    }

    private void checkLod(GunDisplay display) {
        GunLod gunLod = display.getGunLod();
        if (gunLod != null) {
            BedrockGunModel model;
            ResourceLocation texture = gunLod.getModelTexture();
            if (gunLod.getModelLocation() == null) {
                return;
            }
            if (texture == null) {
                return;
            }
            BedrockModelPOJO modelPOJO = ClientAssetsManager.INSTANCE.getBedrockModelPOJO(gunLod.getModelLocation());
            if (modelPOJO == null) {
                return;
            }
            if (BedrockVersion.isLegacyVersion(modelPOJO) && modelPOJO.getGeometryModelLegacy() != null) {
                model = new BedrockGunModel(modelPOJO, BedrockVersion.LEGACY);
                this.lodModel = Pair.of((Object)model, (Object)texture);
            }
            if (BedrockVersion.isNewVersion(modelPOJO) && modelPOJO.getGeometryModelNew() != null) {
                model = new BedrockGunModel(modelPOJO, BedrockVersion.NEW);
                this.lodModel = Pair.of((Object)model, (Object)texture);
            }
        }
    }

    private void checkAnimation(GunDisplay display) {
        LuaTable script;
        AnimationController controller;
        ResourceLocation location = display.getAnimationLocation();
        if (location == null) {
            controller = new AnimationController(Lists.newArrayList(), this.gunModel);
        } else {
            AnimationStructure gltfAnimations = ClientAssetsManager.INSTANCE.getGltfAnimation(location);
            BedrockAnimationFile bedrockAnimationFile = ClientAssetsManager.INSTANCE.getBedrockAnimations(location);
            if (bedrockAnimationFile != null) {
                controller = Animations.createControllerFromBedrock(bedrockAnimationFile, this.gunModel);
            } else if (gltfAnimations != null) {
                controller = Animations.createControllerFromGltf(gltfAnimations, this.gunModel);
            } else {
                throw new IllegalArgumentException("animation not found: " + String.valueOf(location));
            }
            ResourceLocation defaultAnimation = display.getDefaultAnimation();
            if (defaultAnimation != null) {
                BedrockAnimationFile animationFile = ClientAssetsManager.INSTANCE.getBedrockAnimations(defaultAnimation);
                if (animationFile == null) {
                    throw new IllegalArgumentException("animation not found: " + String.valueOf(defaultAnimation));
                }
                Iterator<ObjectAnimation> animations = Animations.createAnimationFromBedrock(animationFile);
                Iterator<ObjectAnimation> iterator = animations.iterator();
                while (iterator.hasNext()) {
                    ObjectAnimation animation = iterator.next();
                    controller.providePrototypeIfAbsent(animation.name, () -> new ObjectAnimation(animation));
                }
            } else {
                DefaultAnimationType defaultAnimationType = display.getDefaultAnimationType();
                if (defaultAnimationType != null) {
                    switch (defaultAnimationType) {
                        case RIFLE: {
                            for (ObjectAnimation animation : InternalAssetLoader.getDefaultRifleAnimations()) {
                                controller.providePrototypeIfAbsent(animation.name, () -> new ObjectAnimation(animation));
                            }
                            break;
                        }
                        case PISTOL: {
                            for (ObjectAnimation animation : InternalAssetLoader.getDefaultPistolAnimations()) {
                                controller.providePrototypeIfAbsent(animation.name, () -> new ObjectAnimation(animation));
                            }
                            break;
                        }
                    }
                }
            }
        }
        ResourceLocation stateMachineLocation = display.getStateMachineLocation();
        if (stateMachineLocation == null) {
            stateMachineLocation = new ResourceLocation("tacz", "default_state_machine");
        }
        if ((script = ClientAssetsManager.INSTANCE.getScript(stateMachineLocation)) == null) {
            throw new IllegalArgumentException("statemachine not found: " + String.valueOf(stateMachineLocation));
        }
        this.animationStateMachine = new LuaStateMachineFactory().setController(controller).setLuaScripts(script).build();
        Map<String, Object> params = display.getStateMachineParam();
        if (params != null) {
            this.stateMachineParam = new LuaTable();
            for (Map.Entry<String, Object> entry : params.entrySet()) {
                this.stateMachineParam.set(entry.getKey(), CoerceJavaToLua.coerce((Object)entry.getValue()));
            }
        }
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{display.getThirdPersonAnimation()})) {
            this.thirdPersonAnimation = display.getThirdPersonAnimation();
        }
        if (display.getPlayerAnimator3rd() != null) {
            this.playerAnimator3rd = display.getPlayerAnimator3rd();
            this.is3rdFixedHand = display.is3rdFixedHand();
        }
    }

    private void checkSounds(GunDisplay display) {
        this.sounds = Maps.newHashMap();
        Map<String, ResourceLocation> soundMaps = display.getSounds();
        if (soundMaps == null || soundMaps.isEmpty()) {
            return;
        }
        soundMaps.putIfAbsent(SoundManager.DRY_FIRE_SOUND, new ResourceLocation("tacz", SoundManager.DRY_FIRE_SOUND));
        soundMaps.putIfAbsent(SoundManager.FIRE_SELECT, new ResourceLocation("tacz", SoundManager.FIRE_SELECT));
        soundMaps.putIfAbsent(SoundManager.HEAD_HIT_SOUND, new ResourceLocation("tacz", SoundManager.HEAD_HIT_SOUND));
        soundMaps.putIfAbsent(SoundManager.FLESH_HIT_SOUND, new ResourceLocation("tacz", SoundManager.FLESH_HIT_SOUND));
        soundMaps.putIfAbsent(SoundManager.KILL_SOUND, new ResourceLocation("tacz", SoundManager.KILL_SOUND));
        soundMaps.putIfAbsent(SoundManager.MELEE_BAYONET, new ResourceLocation("tacz", "melee_bayonet/melee_bayonet_01"));
        soundMaps.putIfAbsent(SoundManager.MELEE_STOCK, new ResourceLocation("tacz", "melee_stock/melee_stock_01"));
        soundMaps.putIfAbsent(SoundManager.MELEE_PUSH, new ResourceLocation("tacz", "melee_stock/melee_stock_02"));
        this.sounds.putAll(soundMaps);
    }

    private void checkTransform(GunDisplay display) {
        GunTransform readTransform = display.getTransform();
        this.transform = readTransform == null || readTransform.getScale() == null ? GunTransform.getDefault() : display.getTransform();
    }

    private void checkSlotTexture(GunDisplay display) {
        this.slotTexture = Objects.requireNonNullElseGet(display.getSlotTextureLocation(), MissingTextureAtlasSprite::m_118071_);
    }

    private void checkHUDTexture(GunDisplay display) {
        this.hudTexture = Objects.requireNonNullElseGet(display.getHudTextureLocation(), MissingTextureAtlasSprite::m_118071_);
        this.hudEmptyTexture = display.getHudEmptyTextureLocation();
    }

    private void checkShellEjection(GunDisplay display) {
        this.shellEjection = display.getShellEjection();
    }

    private void checkGunAmmo(GunDisplay display) {
        AmmoParticle particle;
        GunAmmo displayGunAmmo = display.getGunAmmo();
        if (displayGunAmmo == null) {
            return;
        }
        String tracerColorText = displayGunAmmo.getTracerColor();
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{tracerColorText})) {
            this.tracerColor = ColorHex.colorTextToRbgFloatArray(tracerColorText);
        }
        if ((particle = displayGunAmmo.getParticle()) != null) {
            try {
                String name = particle.getName();
                if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[0])) {
                    particle.setParticleOptions(ParticleArgument.m_247456_((StringReader)new StringReader(name), (HolderLookup)BuiltInRegistries.f_257034_.m_255303_()));
                    Preconditions.checkArgument((particle.getCount() > 0 ? 1 : 0) != 0, (Object)"particle count must be greater than 0");
                    Preconditions.checkArgument((particle.getLifeTime() > 0 ? 1 : 0) != 0, (Object)"particle life time must be greater than 0");
                    this.particle = particle;
                }
            }
            catch (CommandSyntaxException e) {
                e.fillInStackTrace();
            }
        }
    }

    private void checkMuzzleFlash(GunDisplay display) {
        this.muzzleFlash = display.getMuzzleFlash();
        if (this.muzzleFlash != null && this.muzzleFlash.getTexture() == null) {
            this.muzzleFlash = null;
        }
    }

    private void checkLayerGunShow(GunDisplay display) {
        Map<String, LayerGunShow> show;
        this.offhandShow = display.getOffhandShow();
        if (this.offhandShow == null) {
            this.offhandShow = new LayerGunShow();
        }
        if ((show = display.getHotbarShow()) == null || show.isEmpty()) {
            return;
        }
        this.hotbarShow = new Int2ObjectArrayMap();
        for (String key : show.keySet()) {
            try {
                this.hotbarShow.put(Integer.parseInt(key), (Object)show.get(key));
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("index number is error: " + key);
            }
        }
    }

    public BedrockGunModel getGunModel() {
        return this.gunModel;
    }

    @Nullable
    public Pair<BedrockGunModel, ResourceLocation> getLodModel() {
        return this.lodModel;
    }

    public LuaAnimationStateMachine<GunAnimationStateContext> getAnimationStateMachine() {
        return this.animationStateMachine;
    }

    @Nullable
    public LuaTable getStateMachineParam() {
        return this.stateMachineParam;
    }

    @Nullable
    public ResourceLocation getSounds(String name) {
        return this.sounds.get(name);
    }

    public GunTransform getTransform() {
        return this.transform;
    }

    public ResourceLocation getSlotTexture() {
        return this.slotTexture;
    }

    public ResourceLocation getHUDTexture() {
        return this.hudTexture;
    }

    @Nullable
    public ResourceLocation getHudEmptyTexture() {
        return this.hudEmptyTexture;
    }

    public ResourceLocation getModelTexture() {
        return this.modelTexture;
    }

    public String getThirdPersonAnimation() {
        return this.thirdPersonAnimation;
    }

    @Nullable
    public ShellEjection getShellEjection() {
        return this.shellEjection;
    }

    public float @Nullable [] getTracerColor() {
        return this.tracerColor;
    }

    @Nullable
    public AmmoParticle getParticle() {
        return this.particle;
    }

    @Nullable
    public MuzzleFlash getMuzzleFlash() {
        return this.muzzleFlash;
    }

    public LayerGunShow getOffhandShow() {
        return this.offhandShow;
    }

    @Nullable
    public Int2ObjectArrayMap<LayerGunShow> getHotbarShow() {
        return this.hotbarShow;
    }

    public float getIronZoom() {
        return this.ironZoom;
    }

    public float getZoomModelFov() {
        return this.zoomModelFov;
    }

    public boolean isShowCrosshair() {
        return this.showCrosshair;
    }

    @Nullable
    public ResourceLocation getPlayerAnimator3rd() {
        return this.playerAnimator3rd;
    }

    public boolean is3rdFixedHand() {
        return this.is3rdFixedHand;
    }

    public EnumMap<FireMode, ControllableData> getControllableData() {
        return this.controllableData;
    }

    public AmmoCountStyle getAmmoCountStyle() {
        return this.ammoCountStyle;
    }

    public DamageStyle getDamageStyle() {
        return this.damageStyle;
    }

    @Nullable
    public LaserConfig getLaserConfig() {
        return this.laserConfig;
    }
}

