/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.client.model.functional;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.tacz.guns.api.TimelessAPI;
import com.tacz.guns.api.item.IAttachment;
import com.tacz.guns.api.item.IGun;
import com.tacz.guns.client.model.bedrock.BedrockPart;
import com.tacz.guns.client.resource.GunDisplayInstance;
import com.tacz.guns.client.resource.index.ClientAttachmentIndex;
import com.tacz.guns.client.resource.pojo.display.LaserConfig;
import com.tacz.guns.compat.ar.ARCompat;
import com.tacz.guns.config.client.RenderConfig;
import com.tacz.guns.util.LaserColorUtil;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;

public class BeamRenderer {
    public static final ResourceLocation LASER_BEAM_TEXTURE = new ResourceLocation("tacz", "textures/entity/beam.png");
    private static final LaserConfig DEFAULT_LASER_CONFIG = new LaserConfig();

    public static void renderLaserBeam(ItemStack stack, PoseStack poseStack, ItemDisplayContext transformType, @Nonnull List<BedrockPart> path) {
        if (stack == null || !transformType.m_269069_() && transformType != ItemDisplayContext.THIRD_PERSON_RIGHT_HAND) {
            return;
        }
        if (ARCompat.shouldAccelerate() && BeamRenderer.renderLaserBeamAccelerated(stack, poseStack, transformType, path)) {
            return;
        }
        MultiBufferSource.BufferSource bufferSource = Minecraft.m_91087_().m_91269_().m_110104_();
        VertexConsumer builder = bufferSource.m_6299_(LaserBeamRenderState.getLaserBeam());
        poseStack.m_85836_();
        for (int i = 0; i < path.size(); ++i) {
            path.get(i).translateAndRotateAndScale(poseStack);
        }
        LaserConfig laserConfig = BeamRenderer.getLaserConfig(stack);
        int color = LaserColorUtil.getLaserColor(stack, laserConfig);
        int r = color >> 16 & 0xFF;
        int g = color >> 8 & 0xFF;
        int b = color & 0xFF;
        BeamRenderer.stringVertex(transformType.m_269069_() ? (float)(-laserConfig.getLength()) : -laserConfig.getLengthThird(), transformType.m_269069_() ? laserConfig.getWidth() : laserConfig.getWidthThird(), builder, poseStack.m_85850_(), r, g, b, (Boolean)RenderConfig.ENABLE_LASER_FADE_OUT.get());
        poseStack.m_85849_();
    }

    public static boolean renderLaserBeamAccelerated(ItemStack stack, PoseStack poseStack, ItemDisplayContext transformType, @Nonnull List<BedrockPart> path) {
        VertexConsumer builder = Minecraft.m_91087_().m_91269_().m_110104_().m_6299_(LaserBeamRenderState.getLaserBeamEntity());
        if (!ARCompat.isAccelerated(builder)) {
            return false;
        }
        poseStack.m_85836_();
        for (int i = 0; i < path.size(); ++i) {
            path.get(i).translateAndRotateAndScale(poseStack);
        }
        LaserConfig laserConfig = BeamRenderer.getLaserConfig(stack);
        ARCompat.renderLaser(builder, transformType.m_269069_() ? (float)(-laserConfig.getLength()) : -laserConfig.getLengthThird(), transformType.m_269069_() ? laserConfig.getWidth() : laserConfig.getWidthThird(), (Boolean)RenderConfig.ENABLE_LASER_FADE_OUT.get(), poseStack, 0xFF000000 | LaserColorUtil.getLaserColor(stack, laserConfig) & 0xFFFFFF);
        poseStack.m_85849_();
        return true;
    }

    private static LaserConfig getLaserConfig(ItemStack stack) {
        if (stack == null) {
            return DEFAULT_LASER_CONFIG;
        }
        Item item = stack.m_41720_();
        if (item instanceof IAttachment) {
            IAttachment iAttachment = (IAttachment)item;
            return TimelessAPI.getClientAttachmentIndex(iAttachment.getAttachmentId(stack)).map(ClientAttachmentIndex::getLaserConfig).orElse(DEFAULT_LASER_CONFIG);
        }
        if (stack.m_41720_() instanceof IGun) {
            return TimelessAPI.getGunDisplay(stack).map(GunDisplayInstance::getLaserConfig).orElse(DEFAULT_LASER_CONFIG);
        }
        return DEFAULT_LASER_CONFIG;
    }

    private static void stringVertex(float z, float width, VertexConsumer pConsumer, PoseStack.Pose pPose, int r, int g, int b, boolean fadeOut) {
        float halfWidth = width / 2.0f;
        int endAlpha = fadeOut ? 0 : 255;
        int light = LightTexture.m_109885_((int)15, (int)15);
        pConsumer.m_252986_(pPose.m_252922_(), -halfWidth, -halfWidth, 0.0f).m_6122_(r, g, b, 255).m_7421_(0.0f, 0.0f).m_85969_(light).m_5752_();
        pConsumer.m_252986_(pPose.m_252922_(), -halfWidth, halfWidth, 0.0f).m_6122_(r, g, b, 255).m_7421_(0.0f, 1.0f).m_85969_(light).m_5752_();
        pConsumer.m_252986_(pPose.m_252922_(), -halfWidth, halfWidth, z).m_6122_(r, g, b, endAlpha).m_7421_(1.0f, 1.0f).m_85969_(light).m_5752_();
        pConsumer.m_252986_(pPose.m_252922_(), -halfWidth, -halfWidth, z).m_6122_(r, g, b, endAlpha).m_7421_(1.0f, 0.0f).m_85969_(light).m_5752_();
        pConsumer.m_252986_(pPose.m_252922_(), -halfWidth, halfWidth, 0.0f).m_6122_(r, g, b, 255).m_7421_(0.0f, 0.0f).m_85969_(light).m_5752_();
        pConsumer.m_252986_(pPose.m_252922_(), halfWidth, halfWidth, 0.0f).m_6122_(r, g, b, 255).m_7421_(0.0f, 1.0f).m_85969_(light).m_5752_();
        pConsumer.m_252986_(pPose.m_252922_(), halfWidth, halfWidth, z).m_6122_(r, g, b, endAlpha).m_7421_(1.0f, 1.0f).m_85969_(light).m_5752_();
        pConsumer.m_252986_(pPose.m_252922_(), -halfWidth, halfWidth, z).m_6122_(r, g, b, endAlpha).m_7421_(1.0f, 0.0f).m_85969_(light).m_5752_();
        pConsumer.m_252986_(pPose.m_252922_(), halfWidth, halfWidth, 0.0f).m_6122_(r, g, b, 255).m_7421_(0.0f, 0.0f).m_85969_(light).m_5752_();
        pConsumer.m_252986_(pPose.m_252922_(), halfWidth, -halfWidth, 0.0f).m_6122_(r, g, b, 255).m_7421_(0.0f, 1.0f).m_85969_(light).m_5752_();
        pConsumer.m_252986_(pPose.m_252922_(), halfWidth, -halfWidth, z).m_6122_(r, g, b, endAlpha).m_7421_(1.0f, 1.0f).m_85969_(light).m_5752_();
        pConsumer.m_252986_(pPose.m_252922_(), halfWidth, halfWidth, z).m_6122_(r, g, b, endAlpha).m_7421_(1.0f, 0.0f).m_85969_(light).m_5752_();
        pConsumer.m_252986_(pPose.m_252922_(), halfWidth, -halfWidth, 0.0f).m_6122_(r, g, b, 255).m_7421_(0.0f, 1.0f).m_85969_(light).m_5752_();
        pConsumer.m_252986_(pPose.m_252922_(), -halfWidth, -halfWidth, 0.0f).m_6122_(r, g, b, 255).m_7421_(0.0f, 1.0f).m_85969_(light).m_5752_();
        pConsumer.m_252986_(pPose.m_252922_(), -halfWidth, -halfWidth, z).m_6122_(r, g, b, endAlpha).m_7421_(1.0f, 1.0f).m_85969_(light).m_5752_();
        pConsumer.m_252986_(pPose.m_252922_(), halfWidth, -halfWidth, z).m_6122_(r, g, b, endAlpha).m_7421_(1.0f, 0.0f).m_85969_(light).m_5752_();
    }

    public static class LaserBeamRenderState
    extends RenderStateShard {
        public static final RenderStateShard.TransparencyStateShard LIGHTNING_ADDITIVE_TRANSPARENCY = new RenderStateShard.TransparencyStateShard("lightning_transparency", () -> {
            RenderSystem.enableBlend();
            RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        }, () -> {
            RenderSystem.disableBlend();
            RenderSystem.defaultBlendFunc();
        });
        protected static final RenderType LASER_BEAM = RenderType.m_173215_((String)"laser_beam", (VertexFormat)DefaultVertexFormat.f_85820_, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)true, (boolean)true, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_173292_(RenderStateShard.f_173103_).m_110669_(f_110119_).m_110685_(LIGHTNING_ADDITIVE_TRANSPARENCY).m_110675_(f_110129_).m_110671_(f_110152_).m_110687_(f_110114_).m_110661_(f_110110_).m_173290_((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(LASER_BEAM_TEXTURE, false, false)).m_110691_(false));
        protected static final RenderType LASER_BEAM_ENTITY = RenderType.m_173215_((String)"laser_beam_entity", (VertexFormat)DefaultVertexFormat.f_85812_, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)true, (boolean)true, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_173292_(RenderStateShard.f_234323_).m_110669_(f_110119_).m_110685_(LIGHTNING_ADDITIVE_TRANSPARENCY).m_110675_(f_110129_).m_110671_(f_110152_).m_110677_(f_110154_).m_110687_(f_110114_).m_110661_(f_110110_).m_173290_((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(LASER_BEAM_TEXTURE, false, false)).m_110691_(false));

        public LaserBeamRenderState(String pName, Runnable pSetupState, Runnable pClearState) {
            super(pName, pSetupState, pClearState);
        }

        public static RenderType getLaserBeam() {
            return LASER_BEAM;
        }

        public static RenderType getLaserBeamEntity() {
            return LASER_BEAM_ENTITY;
        }
    }
}

