/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.client.event;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.tacz.guns.api.DefaultAssets;
import com.tacz.guns.api.TimelessAPI;
import com.tacz.guns.api.client.event.RenderItemInHandBobEvent;
import com.tacz.guns.api.client.gameplay.IClientPlayerGunOperator;
import com.tacz.guns.api.client.other.KeepingItemRenderer;
import com.tacz.guns.api.event.common.GunFireEvent;
import com.tacz.guns.api.item.IGun;
import com.tacz.guns.api.item.attachment.AttachmentType;
import com.tacz.guns.api.item.nbt.AttachmentItemDataAccessor;
import com.tacz.guns.client.animation.screen.RefitTransform;
import com.tacz.guns.client.model.BedrockAttachmentModel;
import com.tacz.guns.client.model.BedrockGunModel;
import com.tacz.guns.client.model.bedrock.BedrockPart;
import com.tacz.guns.client.model.functional.MuzzleFlashRender;
import com.tacz.guns.client.resource.index.ClientAttachmentIndex;
import com.tacz.guns.entity.EntityKineticBullet;
import com.tacz.guns.util.math.Easing;
import com.tacz.guns.util.math.MathUtil;
import com.tacz.guns.util.math.PerlinNoise;
import com.tacz.guns.util.math.SecondOrderDynamics;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, modid="tacz")
public class FirstPersonRenderGunEvent {
    private static final SecondOrderDynamics AIMING_DYNAMICS = new SecondOrderDynamics(1.2f, 1.2f, 0.5f, 0.0f);
    private static SecondOrderDynamics SWITCH_VIEW_DYNAMICS;
    private static final SecondOrderDynamics REFIT_OPENING_DYNAMICS;
    private static final SecondOrderDynamics JUMPING_DYNAMICS;
    private static final float JUMPING_Y_SWAY = -2.0f;
    private static final float JUMPING_SWAY_TIME = 0.3f;
    private static final float LANDING_SWAY_TIME = 0.15f;
    private static final PerlinNoise SHOOT_X_SWAY_NOISE;
    private static final PerlinNoise SHOOT_Y_ROTATION_NOISE;
    private static final float SHOOT_Y_SWAY = -0.1f;
    private static final float SHOOT_ANIMATION_TIME = 0.3f;
    private static float jumpingSwayProgress;
    private static boolean lastOnGround;
    private static long jumpingTimeStamp;
    private static long shootTimeStamp;
    private static Matrix4f oldAimingViewMatrix;
    private static float oldViewIndex;
    private static int currentViewIndex;

    @SubscribeEvent
    public static void cancelItemInHandViewBobbing(RenderItemInHandBobEvent.BobView event) {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ == null) {
            return;
        }
        ItemStack itemStack = KeepingItemRenderer.getRenderer().getCurrentItem();
        if (IGun.getIGunOrNull(itemStack) != null) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onGunFire(GunFireEvent event) {
        if (event.getLogicalSide().isClient()) {
            LocalPlayer player;
            LivingEntity shooter = event.getShooter();
            if (!shooter.equals((Object)(player = Minecraft.m_91087_().f_91074_))) {
                return;
            }
            ItemStack mainHandItem = player.m_21205_();
            IGun iGun = IGun.getIGunOrNull(mainHandItem);
            if (iGun == null) {
                return;
            }
            TimelessAPI.getClientGunIndex(iGun.getGunId(mainHandItem)).ifPresent(gunIndex -> {
                shootTimeStamp = System.currentTimeMillis();
                MuzzleFlashRender.onShoot();
            });
        }
    }

    private static boolean bulletFromPlayer(Entity entity) {
        if (entity instanceof EntityKineticBullet) {
            EntityKineticBullet entityBullet = (EntityKineticBullet)entity;
            return entityBullet.m_19749_() instanceof LocalPlayer;
        }
        return false;
    }

    public static void applyFirstPersonGunTransform(LocalPlayer player, ItemStack gunItemStack, PoseStack poseStack, BedrockGunModel model, float partialTicks) {
        float refitScreenOpeningProgress = REFIT_OPENING_DYNAMICS.update(RefitTransform.getOpeningProgress());
        float aimingProgress = AIMING_DYNAMICS.update(IClientPlayerGunOperator.fromLocalPlayer(player).getClientAimingProgress(partialTicks));
        FirstPersonRenderGunEvent.applyGunMovements(model, aimingProgress, partialTicks);
        FirstPersonRenderGunEvent.applyFirstPersonPositioningTransform(poseStack, model, gunItemStack, aimingProgress, refitScreenOpeningProgress);
        FirstPersonRenderGunEvent.applyAnimationConstraintTransform(poseStack, model, aimingProgress * (1.0f - refitScreenOpeningProgress));
    }

    private static void applyGunMovements(BedrockGunModel model, float aimingProgress, float partialTicks) {
        FirstPersonRenderGunEvent.applyShootSwayAndRotation(model, aimingProgress);
        FirstPersonRenderGunEvent.applyJumpingSway(model, partialTicks);
    }

    private static void applyFirstPersonPositioningTransform(PoseStack poseStack, BedrockGunModel model, ItemStack stack, float aimingProgress, float refitScreenOpeningProgress) {
        IGun iGun = IGun.getIGunOrNull(stack);
        if (iGun == null) {
            return;
        }
        Matrix4f transformMatrix = new Matrix4f();
        transformMatrix.identity();
        List<BedrockPart> idleNodePath = model.getIdleSightPath();
        List<BedrockPart> aimingNodePath = null;
        ResourceLocation scopeId = iGun.getAttachmentId(stack, AttachmentType.SCOPE);
        if (scopeId.equals((Object)DefaultAssets.EMPTY_ATTACHMENT_ID)) {
            scopeId = iGun.getBuiltInAttachmentId(stack, AttachmentType.SCOPE);
        }
        CompoundTag scopeTag = iGun.getAttachmentTag(stack, AttachmentType.SCOPE);
        int zoomNumber = AttachmentItemDataAccessor.getZoomNumberFromTag(scopeTag);
        int viewIndex = 1;
        if (DefaultAssets.isEmptyAttachmentId(scopeId)) {
            aimingNodePath = model.getIronSightPath();
        } else {
            List<BedrockPart> scopeNodePath = model.getScopePosPath();
            if (scopeNodePath != null) {
                aimingNodePath = new ArrayList<BedrockPart>(scopeNodePath);
                Optional<ClientAttachmentIndex> indexOptional = TimelessAPI.getClientAttachmentIndex(scopeId);
                if (indexOptional.isPresent()) {
                    List<BedrockPart> scopeViewPath;
                    BedrockAttachmentModel attachmentModel = indexOptional.get().getAttachmentModel();
                    int[] views = indexOptional.get().getViews();
                    viewIndex = views[zoomNumber % views.length] - 1;
                    if (attachmentModel != null && (scopeViewPath = attachmentModel.getScopeViewPath(currentViewIndex == -1 ? viewIndex : currentViewIndex)) != null) {
                        aimingNodePath.addAll(scopeViewPath);
                    }
                }
            }
        }
        Matrix4f aimingViewMatrix = FirstPersonRenderGunEvent.getPositioningNodeInverse(aimingNodePath);
        if (currentViewIndex == -1) {
            currentViewIndex = viewIndex;
            oldViewIndex = viewIndex;
            oldAimingViewMatrix = aimingViewMatrix;
            SWITCH_VIEW_DYNAMICS = new SecondOrderDynamics(0.35f, 1.2f, 0.3f, viewIndex);
        }
        float view_interpret = SWITCH_VIEW_DYNAMICS.update(viewIndex);
        float span = (float)currentViewIndex - oldViewIndex;
        float switchingProgress = (double)Math.abs(span) < 0.05 ? 1.0f : (view_interpret - oldViewIndex) / span;
        MathUtil.applyMatrixLerp(aimingViewMatrix, oldAimingViewMatrix, aimingViewMatrix, 1.0f - switchingProgress);
        if (currentViewIndex != viewIndex) {
            oldAimingViewMatrix = aimingViewMatrix;
            oldViewIndex = view_interpret;
            currentViewIndex = viewIndex;
        }
        MathUtil.applyMatrixLerp(transformMatrix, FirstPersonRenderGunEvent.getPositioningNodeInverse(idleNodePath), transformMatrix, 1.0f - refitScreenOpeningProgress);
        MathUtil.applyMatrixLerp(transformMatrix, aimingViewMatrix, transformMatrix, (1.0f - refitScreenOpeningProgress) * aimingProgress);
        float refitTransformProgress = (float)Easing.easeOutCubic(RefitTransform.getTransformProgress());
        AttachmentType oldType = RefitTransform.getOldTransformType();
        AttachmentType currentType = RefitTransform.getCurrentTransformType();
        List<BedrockPart> fromNode = model.getRefitAttachmentViewPath(oldType);
        List<BedrockPart> toNode = model.getRefitAttachmentViewPath(currentType);
        MathUtil.applyMatrixLerp(transformMatrix, FirstPersonRenderGunEvent.getPositioningNodeInverse(fromNode), transformMatrix, refitScreenOpeningProgress);
        MathUtil.applyMatrixLerp(transformMatrix, FirstPersonRenderGunEvent.getPositioningNodeInverse(toNode), transformMatrix, refitScreenOpeningProgress * refitTransformProgress);
        poseStack.m_252880_(0.0f, 1.5f, 0.0f);
        poseStack.m_252931_(transformMatrix);
        poseStack.m_252880_(0.0f, -1.5f, 0.0f);
    }

    @Nonnull
    private static Matrix4f getPositioningNodeInverse(List<BedrockPart> nodePath) {
        Matrix4f matrix4f = new Matrix4f();
        matrix4f.identity();
        if (nodePath != null) {
            for (int i = nodePath.size() - 1; i >= 0; --i) {
                BedrockPart part = nodePath.get(i);
                matrix4f.rotate((Quaternionfc)Axis.f_252495_.m_252961_(part.xRot));
                matrix4f.rotate((Quaternionfc)Axis.f_252392_.m_252961_(part.yRot));
                matrix4f.rotate((Quaternionfc)Axis.f_252393_.m_252961_(part.zRot));
                if (part.getParent() != null) {
                    matrix4f.translate(-part.x / 16.0f, -part.y / 16.0f, -part.z / 16.0f);
                    continue;
                }
                matrix4f.translate(-part.x / 16.0f, 1.5f - part.y / 16.0f, -part.z / 16.0f);
            }
        }
        return matrix4f;
    }

    private static void applyShootSwayAndRotation(BedrockGunModel model, float aimingProgress) {
        BedrockPart rootNode = model.getRootNode();
        if (rootNode != null) {
            float progress = 1.0f - (float)(System.currentTimeMillis() - shootTimeStamp) / 300.0f;
            if (progress < 0.0f) {
                progress = 0.0f;
            }
            progress = (float)Easing.easeOutCubic(progress);
            rootNode.offsetX += SHOOT_X_SWAY_NOISE.getValue() / 16.0f * progress * (1.0f - aimingProgress);
            rootNode.offsetY += 0.00625f * progress * (1.0f - aimingProgress);
            rootNode.additionalQuaternion.mul((Quaternionfc)Axis.f_252436_.m_252961_(SHOOT_Y_ROTATION_NOISE.getValue() * progress));
        }
    }

    private static void applyJumpingSway(BedrockGunModel model, float partialTicks) {
        LocalPlayer player;
        if (jumpingTimeStamp == -1L) {
            jumpingTimeStamp = System.currentTimeMillis();
        }
        if ((player = Minecraft.m_91087_().f_91074_) != null) {
            double posY = Mth.m_14139_((double)partialTicks, (double)Minecraft.m_91087_().f_91074_.f_19791_, (double)Minecraft.m_91087_().f_91074_.m_20186_());
            float velocityY = (float)(posY - Minecraft.m_91087_().f_91074_.f_19791_) / partialTicks;
            if (player.m_20096_()) {
                if (!lastOnGround) {
                    jumpingSwayProgress = velocityY / -0.1f;
                    if (jumpingSwayProgress > 1.0f) {
                        jumpingSwayProgress = 1.0f;
                    }
                    lastOnGround = true;
                } else if ((jumpingSwayProgress -= (float)(System.currentTimeMillis() - jumpingTimeStamp) / 150.0f) < 0.0f) {
                    jumpingSwayProgress = 0.0f;
                }
            } else if (lastOnGround) {
                jumpingSwayProgress = velocityY / 0.42f;
                if (jumpingSwayProgress > 1.0f) {
                    jumpingSwayProgress = 1.0f;
                }
                lastOnGround = false;
            } else if ((jumpingSwayProgress -= (float)(System.currentTimeMillis() - jumpingTimeStamp) / 300.0f) < 0.0f) {
                jumpingSwayProgress = 0.0f;
            }
        }
        jumpingTimeStamp = System.currentTimeMillis();
        float ySway = JUMPING_DYNAMICS.update(-2.0f * jumpingSwayProgress);
        BedrockPart rootNode = model.getRootNode();
        if (rootNode != null) {
            rootNode.offsetY += -ySway / 16.0f;
        }
    }

    private static void getAnimationConstraintTransform(List<BedrockPart> nodePath, @Nonnull Vector3f originTranslation, @Nonnull Vector3f animatedTranslation, @Nonnull Vector3f rotation) {
        if (nodePath == null) {
            return;
        }
        Matrix4f animeMatrix = new Matrix4f();
        Matrix4f originMatrix = new Matrix4f();
        animeMatrix.identity();
        originMatrix.identity();
        BedrockPart constrainNode = nodePath.get(nodePath.size() - 1);
        for (BedrockPart part : nodePath) {
            if (part != constrainNode) {
                animeMatrix.translate(part.offsetX, part.offsetY, part.offsetZ);
            }
            if (part.getParent() != null) {
                animeMatrix.translate(part.x / 16.0f, part.y / 16.0f, part.z / 16.0f);
            } else {
                animeMatrix.translate(part.x / 16.0f, part.y / 16.0f - 1.5f, part.z / 16.0f);
            }
            if (part != constrainNode) {
                animeMatrix.rotate((Quaternionfc)part.additionalQuaternion);
            }
            animeMatrix.rotate((Quaternionfc)Axis.f_252403_.m_252961_(part.zRot));
            animeMatrix.rotate((Quaternionfc)Axis.f_252436_.m_252961_(part.yRot));
            animeMatrix.rotate((Quaternionfc)Axis.f_252529_.m_252961_(part.xRot));
            if (part.getParent() != null) {
                originMatrix.translate(part.x / 16.0f, part.y / 16.0f, part.z / 16.0f);
            } else {
                originMatrix.translate(part.x / 16.0f, part.y / 16.0f - 1.5f, part.z / 16.0f);
            }
            originMatrix.rotate((Quaternionfc)Axis.f_252403_.m_252961_(part.zRot));
            originMatrix.rotate((Quaternionfc)Axis.f_252436_.m_252961_(part.yRot));
            originMatrix.rotate((Quaternionfc)Axis.f_252529_.m_252961_(part.xRot));
        }
        animeMatrix.getTranslation(animatedTranslation);
        originMatrix.getTranslation(originTranslation);
        Vector3f animatedRotation = MathUtil.getEulerAngles(animeMatrix);
        Vector3f originRotation = MathUtil.getEulerAngles(originMatrix);
        animatedRotation.sub((Vector3fc)originRotation);
        rotation.set(animatedRotation.x(), animatedRotation.y(), animatedRotation.z());
    }

    public static void applyAnimationConstraintTransform(PoseStack poseStack, BedrockGunModel gunModel, float weight) {
        List<BedrockPart> nodePath = gunModel.getConstraintPath();
        if (nodePath == null) {
            return;
        }
        if (gunModel.getConstraintObject() == null) {
            return;
        }
        Vector3f originTranslation = new Vector3f();
        Vector3f animatedTranslation = new Vector3f();
        Vector3f rotation = new Vector3f();
        Vector3f translationICA = gunModel.getConstraintObject().translationConstraint;
        Vector3f rotationICA = gunModel.getConstraintObject().rotationConstraint;
        FirstPersonRenderGunEvent.getAnimationConstraintTransform(nodePath, originTranslation, animatedTranslation, rotation);
        Vector3f inverseTranslation = new Vector3f((Vector3fc)originTranslation);
        inverseTranslation.sub((Vector3fc)animatedTranslation);
        inverseTranslation.mulDirection((Matrix4fc)poseStack.m_85850_().m_252922_());
        inverseTranslation.mul(translationICA.x() - 1.0f, translationICA.y() - 1.0f, 1.0f - translationICA.z());
        Vector3f inverseRotation = new Vector3f((Vector3fc)rotation);
        inverseRotation.mul(rotationICA.x() - 1.0f, rotationICA.y() - 1.0f, rotationICA.z() - 1.0f);
        poseStack.m_252880_(animatedTranslation.x(), animatedTranslation.y() + 1.5f, animatedTranslation.z());
        poseStack.m_252781_(Axis.f_252529_.m_252961_(inverseRotation.x() * weight));
        poseStack.m_252781_(Axis.f_252436_.m_252961_(inverseRotation.y() * weight));
        poseStack.m_252781_(Axis.f_252403_.m_252961_(inverseRotation.z() * weight));
        poseStack.m_252880_(-animatedTranslation.x(), -animatedTranslation.y() - 1.5f, -animatedTranslation.z());
        Matrix4f poseMatrix = poseStack.m_85850_().m_252922_();
        poseMatrix.m30(poseMatrix.m30() - inverseTranslation.x() * weight);
        poseMatrix.m31(poseMatrix.m31() - inverseTranslation.y() * weight);
        poseMatrix.m32(poseMatrix.m32() + inverseTranslation.z() * weight);
    }

    static {
        REFIT_OPENING_DYNAMICS = new SecondOrderDynamics(1.0f, 1.2f, 0.5f, 0.0f);
        JUMPING_DYNAMICS = new SecondOrderDynamics(0.28f, 1.0f, 0.65f, 0.0f);
        SHOOT_X_SWAY_NOISE = new PerlinNoise(-0.2f, 0.2f, 400L);
        SHOOT_Y_ROTATION_NOISE = new PerlinNoise(-0.0136f, 0.0136f, 100L);
        jumpingSwayProgress = 0.0f;
        lastOnGround = false;
        jumpingTimeStamp = -1L;
        shootTimeStamp = -1L;
        currentViewIndex = -1;
    }
}

