/*
 * Decompiled with CFR 0.152.
 */
package com.tom.storagemod.emi;

import com.tom.storagemod.gui.AbstractFilteredMenu;
import com.tom.storagemod.gui.AbstractFilteredScreen;
import com.tom.storagemod.gui.FilterSlot;
import com.tom.storagemod.gui.PhantomSlot;
import com.tom.storagemod.item.IItemFilter;
import dev.emi.emi.api.EmiDragDropHandler;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.Bounds;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class EmiGhostIngredientHandler
implements EmiDragDropHandler<Screen> {
    private static ItemStack getStack(EmiIngredient ing) {
        return ing.getEmiStacks().stream().map(EmiStack::getItemStack).filter(s -> !s.m_41619_()).findFirst().orElse(ItemStack.f_41583_);
    }

    public boolean dropStack(Screen screen, EmiIngredient stackIn, int x, int y) {
        if (!(screen instanceof AbstractFilteredScreen)) {
            return false;
        }
        AbstractFilteredScreen scr = (AbstractFilteredScreen)screen;
        ItemStack stack = EmiGhostIngredientHandler.getStack(stackIn);
        if (stack.m_41619_()) {
            return false;
        }
        List<DropTarget> targets = this.getTargets(scr, stack);
        for (DropTarget b : targets) {
            if (!b.getArea().contains(x, y)) continue;
            b.accept(stack);
            return true;
        }
        return false;
    }

    public void render(Screen screen, EmiIngredient dragged, GuiGraphics matrices, int mouseX, int mouseY, float delta) {
        if (!(screen instanceof AbstractFilteredScreen)) {
            return;
        }
        AbstractFilteredScreen scr = (AbstractFilteredScreen)screen;
        ItemStack stack = EmiGhostIngredientHandler.getStack(dragged);
        if (stack.m_41619_()) {
            return;
        }
        List<DropTarget> targets = this.getTargets(scr, stack);
        for (DropTarget t : targets) {
            Bounds b = t.getArea();
            matrices.m_280509_(b.x(), b.y(), b.x() + b.width(), b.y() + b.height(), -2010989773);
        }
    }

    private <I> List<DropTarget> getTargets(AbstractFilteredScreen gui, ItemStack stack) {
        ArrayList<DropTarget> targets = new ArrayList<DropTarget>();
        boolean filter = stack.m_41720_() instanceof IItemFilter;
        for (Slot slot : gui.m_6262_().f_38839_) {
            ItemStack s;
            boolean sf;
            if (slot instanceof PhantomSlot) {
                targets.add(new SlotTarget(gui, slot));
                continue;
            }
            if (filter || !(slot instanceof FilterSlot) || (sf = !(s = slot.m_7993_()).m_41619_() && s.m_41720_() instanceof IItemFilter)) continue;
            targets.add(new SlotTarget(gui, slot));
        }
        return targets;
    }

    static interface DropTarget {
        public Bounds getArea();

        public void accept(ItemStack var1);
    }

    private static class SlotTarget
    implements DropTarget {
        private Slot slot;
        private Bounds area;
        private AbstractFilteredScreen gui;

        public SlotTarget(AbstractFilteredScreen gui, Slot slot) {
            this.slot = slot;
            this.gui = gui;
            this.area = new Bounds(gui.getGuiLeft() + slot.f_40220_, gui.getGuiTop() + slot.f_40221_, 16, 16);
        }

        @Override
        public Bounds getArea() {
            return this.area;
        }

        @Override
        public void accept(ItemStack ingredient) {
            ((AbstractFilteredMenu)this.gui.m_6262_()).setPhantom(this.slot, ingredient);
        }
    }
}

