/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.render;

import com.yogpc.qp.QuarryPlus;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class Sprites {
    public static final Sprites INSTANCE = new Sprites();
    private static final List<String> spriteNames = List.of("laser_1", "laser_2", "laser_3", "laser_4", "white", "stripes_h", "stripes_v", "stripes_blue", "stripes_red", "drill", "drill_head");
    private final Map<String, TextureAtlasSprite> spriteMap = new HashMap<String, TextureAtlasSprite>();

    private Sprites() {
    }

    @SubscribeEvent
    public static void registerSprites(TextureStitchEvent.Post event) {
        if (event.getAtlas().m_118330_().equals((Object)InventoryMenu.f_39692_)) {
            spriteNames.forEach(s -> {
                ResourceLocation name = Sprites.getSpriteLocation(s);
                TextureAtlasSprite sprite = event.getAtlas().m_118316_(name);
                if (!sprite.m_245424_().m_246162_().equals((Object)name)) {
                    QuarryPlus.LOGGER.error("Failed to load sprite of {} in {}", (Object)name, (Object)event.getAtlas().m_118330_());
                }
                Sprites.INSTANCE.spriteMap.put((String)s, sprite);
            });
        }
    }

    private TextureAtlasSprite getSprite(String name) {
        return this.spriteMap.computeIfAbsent(name, s -> (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(Sprites.getSpriteLocation(s)));
    }

    @NotNull
    private static ResourceLocation getSpriteLocation(String s) {
        return new ResourceLocation("quarryplus", "entity/" + s);
    }

    public TextureAtlasSprite getMarkerBlue() {
        return this.getSprite("laser_4");
    }

    public TextureAtlasSprite getV() {
        return this.getSprite("stripes_v");
    }

    public TextureAtlasSprite getFrameH() {
        return this.getSprite("stripes_h");
    }

    public TextureAtlasSprite getBoxBlueStripe() {
        return this.getSprite("stripes_blue");
    }

    public TextureAtlasSprite getBoxRedStripe() {
        return this.getSprite("stripes_red");
    }

    public TextureAtlasSprite getDrillStripe() {
        return this.getSprite("drill");
    }

    public TextureAtlasSprite getDrillHeadStripe() {
        return this.getSprite("drill_head");
    }

    public TextureAtlasSprite getWhite() {
        return this.getSprite("white");
    }
}

