/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.custom_nether_portals.portal;

import com.leclowndu93150.custom_nether_portals.CNPBlocks;
import com.leclowndu93150.custom_nether_portals.block.HorizontalNetherPortalBlock;
import java.util.Optional;
import net.minecraft.BlockUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.level.levelgen.Heightmap;

public class HorizontalPortalForcer {
    private static final int FRAME_HEIGHT = 3;
    private static final int FRAME_WIDTH = 4;
    private static final int PORTAL_SEARCH_RADIUS = 16;
    private final ServerLevel level;

    public HorizontalPortalForcer(ServerLevel level) {
        this.level = level;
    }

    public Optional<BlockUtil.FoundRectangle> createHorizontalPortal(BlockPos pos, Direction.Axis axis) {
        int z;
        int x;
        Direction direction = Direction.m_122390_((Direction.AxisDirection)Direction.AxisDirection.POSITIVE, (Direction.Axis)axis);
        double bestDistance = -1.0;
        BlockPos bestPosition = null;
        double fallbackDistance = -1.0;
        BlockPos fallbackPosition = null;
        WorldBorder worldBorder = this.level.m_6857_();
        int maxHeight = Math.min(this.level.m_151558_(), this.level.m_141937_() + this.level.m_143344_()) - 1;
        BlockPos.MutableBlockPos mutablePos = pos.m_122032_();
        for (BlockPos.MutableBlockPos searchPos : BlockPos.m_121935_((BlockPos)pos, (int)16, (Direction)Direction.EAST, (Direction)Direction.SOUTH)) {
            int surfaceHeight = Math.min(maxHeight, this.level.m_6924_(Heightmap.Types.MOTION_BLOCKING, searchPos.m_123341_(), searchPos.m_123343_()));
            if (!worldBorder.m_61937_((BlockPos)searchPos) || !worldBorder.m_61937_((BlockPos)searchPos.m_122175_(direction, 1))) continue;
            searchPos.m_122175_(direction.m_122424_(), 1);
            for (int y = surfaceHeight; y >= this.level.m_141937_(); --y) {
                searchPos.m_142448_(y);
                if (!this.canPlaceHorizontalPortal((BlockPos)searchPos)) continue;
                int bottomY = y;
                while (y > this.level.m_141937_() && this.canPlaceHorizontalPortal((BlockPos)searchPos.m_122173_(Direction.DOWN))) {
                    --y;
                }
                if (bottomY - y > 3 || bottomY - y < 1) continue;
                searchPos.m_142448_(y + 1);
                if (!this.canHostHorizontalFrame((BlockPos)searchPos, mutablePos, direction)) continue;
                double distance = pos.m_123331_((Vec3i)searchPos);
                if (bestDistance == -1.0 || bestDistance > distance) {
                    bestDistance = distance;
                    bestPosition = searchPos.m_7949_();
                }
                if (bestDistance != -1.0 || fallbackDistance != -1.0 && !(fallbackDistance > distance)) continue;
                fallbackDistance = distance;
                fallbackPosition = searchPos.m_7949_();
            }
        }
        if (bestDistance == -1.0 && fallbackDistance != -1.0) {
            bestPosition = fallbackPosition;
            bestDistance = fallbackDistance;
        }
        if (bestDistance == -1.0) {
            int maxY = maxHeight - 9;
            int minY = Math.max(this.level.m_141937_(), 70);
            if (maxY < minY) {
                return Optional.empty();
            }
            bestPosition = new BlockPos(pos.m_123341_(), Mth.m_14045_((int)pos.m_123342_(), (int)minY, (int)maxY), pos.m_123343_()).m_7949_();
            bestPosition = worldBorder.m_187569_((double)bestPosition.m_123341_(), (double)bestPosition.m_123342_(), (double)bestPosition.m_123343_());
        }
        Direction perpendicular = direction.m_122427_();
        for (x = -1; x <= 4; ++x) {
            for (z = -1; z <= 3; ++z) {
                boolean isFrame = x == -1 || x == 4 || z == -1 || z == 3;
                mutablePos.m_122154_((Vec3i)bestPosition, x * direction.m_122429_() + z * perpendicular.m_122429_(), 0, x * direction.m_122431_() + z * perpendicular.m_122431_());
                if (isFrame) {
                    this.level.m_7731_((BlockPos)mutablePos, Blocks.f_50080_.m_49966_(), 3);
                    if (!this.level.m_8055_(mutablePos.m_7495_()).m_60795_()) continue;
                    this.level.m_7731_(mutablePos.m_7495_(), Blocks.f_50134_.m_49966_(), 3);
                    continue;
                }
                this.level.m_7731_(mutablePos.m_7494_(), Blocks.f_50016_.m_49966_(), 3);
            }
        }
        for (x = 0; x < 4; ++x) {
            for (z = 0; z < 3; ++z) {
                mutablePos.m_122154_((Vec3i)bestPosition, x * direction.m_122429_() + z * perpendicular.m_122429_(), 0, x * direction.m_122431_() + z * perpendicular.m_122431_());
                if (!this.level.m_8055_(mutablePos.m_7495_()).m_60795_()) continue;
                this.level.m_7731_(mutablePos.m_7495_(), Blocks.f_50134_.m_49966_(), 3);
            }
        }
        BlockState portalState = (BlockState)CNPBlocks.HORIZONTAL_NETHER_PORTAL.m_49966_().m_61124_(HorizontalNetherPortalBlock.AXIS, (Comparable)axis);
        for (int pass = 0; pass < 2; ++pass) {
            for (int x2 = 0; x2 < 4; ++x2) {
                for (int z2 = 0; z2 < 3; ++z2) {
                    mutablePos.m_122154_((Vec3i)bestPosition, x2 * direction.m_122429_() + z2 * perpendicular.m_122429_(), 0, x2 * direction.m_122431_() + z2 * perpendicular.m_122431_());
                    this.level.m_7731_((BlockPos)mutablePos, portalState, 18);
                }
            }
        }
        return Optional.of(new BlockUtil.FoundRectangle(bestPosition.m_7949_(), 4, 3));
    }

    private boolean canPlaceHorizontalPortal(BlockPos pos) {
        BlockState state = this.level.m_8055_(pos);
        return state.m_60795_() || state.m_247087_();
    }

    private boolean canHostHorizontalFrame(BlockPos pos, BlockPos.MutableBlockPos mutablePos, Direction direction) {
        Direction perpendicular = direction.m_122427_();
        for (int x = -1; x <= 4; ++x) {
            for (int z = -1; z <= 3; ++z) {
                mutablePos.m_122154_((Vec3i)pos, x * direction.m_122429_() + z * perpendicular.m_122429_(), -1, x * direction.m_122431_() + z * perpendicular.m_122431_());
                if (!this.level.m_8055_((BlockPos)mutablePos).m_280296_()) {
                    return false;
                }
                mutablePos.m_122175_(Direction.UP, 1);
                if (this.canPlaceHorizontalPortal((BlockPos)mutablePos)) continue;
                return false;
            }
        }
        return true;
    }
}

