/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.custom_nether_portals.mixin;

import com.leclowndu93150.custom_nether_portals.block.HorizontalNetherPortalBlock;
import com.leclowndu93150.custom_nether_portals.portal.HorizontalPortalForcer;
import java.util.Comparator;
import java.util.Optional;
import net.minecraft.BlockUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.entity.ai.village.poi.PoiRecord;
import net.minecraft.world.entity.ai.village.poi.PoiTypes;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.level.portal.PortalForcer;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={PortalForcer.class})
public class PortalForcerMixin {
    @Shadow
    @Final
    private ServerLevel f_77648_;

    @Inject(method={"findPortalAround"}, at={@At(value="HEAD")}, cancellable=true)
    private void findClosestPortalPositionWithCustomPortals(BlockPos exitPos, boolean isNether, WorldBorder worldBorder, CallbackInfoReturnable<Optional<BlockUtil.FoundRectangle>> cir) {
        PoiManager poimanager = this.f_77648_.m_8904_();
        int searchRadius = isNether ? 16 : 128;
        poimanager.m_27056_((LevelReader)this.f_77648_, exitPos, searchRadius);
        Optional<BlockUtil.FoundRectangle> result = poimanager.m_27166_(poiType -> poiType.m_203565_(PoiTypes.f_218064_), exitPos, searchRadius, PoiManager.Occupancy.ANY).map(PoiRecord::m_27257_).filter(arg_0 -> ((WorldBorder)worldBorder).m_61937_(arg_0)).filter(pos -> {
            BlockState blockState = this.f_77648_.m_8055_(pos);
            return blockState.m_61138_((Property)BlockStateProperties.f_61364_) || blockState.m_60734_() instanceof HorizontalNetherPortalBlock && blockState.m_61138_(HorizontalNetherPortalBlock.AXIS);
        }).min(Comparator.comparingDouble(pos -> pos.m_123331_((Vec3i)exitPos)).thenComparingInt(Vec3i::m_123342_)).map(pos -> {
            BlockState state = this.f_77648_.m_8055_(pos);
            Direction.Axis portalAxis = state.m_61138_((Property)BlockStateProperties.f_61364_) ? (Direction.Axis)state.m_61143_((Property)BlockStateProperties.f_61364_) : (Direction.Axis)state.m_61143_(HorizontalNetherPortalBlock.AXIS);
            return BlockUtil.m_124334_((BlockPos)pos, (Direction.Axis)portalAxis, (int)21, (Direction.Axis)Direction.Axis.Y, (int)21, testPos -> this.f_77648_.m_8055_(testPos) == state);
        });
        cir.setReturnValue(result);
    }

    @Inject(method={"createPortal"}, at={@At(value="HEAD")}, cancellable=true)
    private void createHorizontalPortal(BlockPos pos, Direction.Axis axis, CallbackInfoReturnable<Optional<BlockUtil.FoundRectangle>> cir) {
        HorizontalPortalForcer horizontalForcer;
        Optional<BlockUtil.FoundRectangle> result;
        if (pos.m_123342_() < 100 && this.f_77648_.m_213780_().m_188501_() < 0.5f && (result = (horizontalForcer = new HorizontalPortalForcer(this.f_77648_)).createHorizontalPortal(pos, axis)).isPresent()) {
            cir.setReturnValue(result);
        }
    }
}

