/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.custom_nether_portals.events;

import com.leclowndu93150.custom_nether_portals.cursedness.HorizontalPortalShape;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.FlintAndSteelItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="custom_nether_portals")
public class HorizontalPortalEventHandler {
    @SubscribeEvent
    public static void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        Optional<HorizontalPortalShape> portalShape;
        if (!(event.getItemStack().m_41720_() instanceof FlintAndSteelItem)) {
            return;
        }
        Level level = event.getLevel();
        BlockPos clickedPos = event.getPos();
        BlockState clickedState = level.m_8055_(clickedPos);
        if (!HorizontalPortalEventHandler.inPortalDimension(level)) {
            return;
        }
        if (clickedState.m_60795_() && (portalShape = HorizontalPortalShape.findEmptyPortalShape((LevelAccessor)level, clickedPos)).isPresent()) {
            level.m_5594_(event.getEntity(), clickedPos, SoundEvents.f_11942_, SoundSource.BLOCKS, 1.0f, level.m_213780_().m_188501_() * 0.4f + 0.8f);
            if (!level.m_5776_()) {
                portalShape.get().createPortalBlocks();
                Player player2 = event.getEntity();
                if (player2 instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player2;
                    event.getItemStack().m_41622_(1, (LivingEntity)serverPlayer, player -> player.m_21190_(event.getHand()));
                }
            }
            level.m_142346_((Entity)event.getEntity(), GameEvent.f_157797_, clickedPos);
            event.setCancellationResult(InteractionResult.m_19078_((boolean)level.m_5776_()));
            event.setCanceled(true);
            return;
        }
        if (clickedState.m_60713_(Blocks.f_50080_) || clickedState.m_60713_(Blocks.f_50723_)) {
            Direction clickedFace = event.getFace();
            if (clickedFace.m_122434_().m_122479_()) {
                BlockPos firePos = clickedPos.m_121945_(clickedFace);
                Optional<HorizontalPortalShape> portalShape2 = HorizontalPortalShape.findEmptyPortalShape((LevelAccessor)level, firePos);
                if (portalShape2.isPresent()) {
                    level.m_5594_(event.getEntity(), firePos, SoundEvents.f_11942_, SoundSource.BLOCKS, 1.0f, level.m_213780_().m_188501_() * 0.4f + 0.8f);
                    if (!level.m_5776_()) {
                        portalShape2.get().createPortalBlocks();
                        Player player3 = event.getEntity();
                        if (player3 instanceof ServerPlayer) {
                            ServerPlayer serverPlayer = (ServerPlayer)player3;
                            event.getItemStack().m_41622_(1, (LivingEntity)serverPlayer, player -> player.m_21190_(event.getHand()));
                        }
                    }
                    level.m_142346_((Entity)event.getEntity(), GameEvent.f_157797_, firePos);
                    event.setCancellationResult(InteractionResult.m_19078_((boolean)level.m_5776_()));
                    event.setCanceled(true);
                    return;
                }
            } else {
                for (Direction direction : Direction.Plane.HORIZONTAL) {
                    Optional<HorizontalPortalShape> portalShape3;
                    BlockPos firePos = clickedPos.m_121945_(direction);
                    if (!level.m_8055_(firePos).m_60795_() || !BaseFireBlock.m_49255_((Level)level, (BlockPos)firePos, (Direction)direction) || !(portalShape3 = HorizontalPortalShape.findEmptyPortalShape((LevelAccessor)level, firePos)).isPresent()) continue;
                    level.m_5594_(event.getEntity(), firePos, SoundEvents.f_11942_, SoundSource.BLOCKS, 1.0f, level.m_213780_().m_188501_() * 0.4f + 0.8f);
                    if (!level.m_5776_()) {
                        portalShape3.get().createPortalBlocks();
                        Player player4 = event.getEntity();
                        if (player4 instanceof ServerPlayer) {
                            ServerPlayer serverPlayer = (ServerPlayer)player4;
                            event.getItemStack().m_41622_(1, (LivingEntity)serverPlayer, player -> player.m_21190_(event.getHand()));
                        }
                    }
                    level.m_142346_((Entity)event.getEntity(), GameEvent.f_157797_, firePos);
                    event.setCancellationResult(InteractionResult.m_19078_((boolean)level.m_5776_()));
                    event.setCanceled(true);
                    return;
                }
            }
        }
    }

    @SubscribeEvent
    public static void onBlockPlace(BlockEvent.EntityPlaceEvent event) {
        if (!(event.getPlacedBlock().m_60734_() instanceof BaseFireBlock)) {
            return;
        }
        Level level = (Level)event.getLevel();
        BlockPos pos = event.getPos();
        if (!HorizontalPortalEventHandler.inPortalDimension(level)) {
            return;
        }
        Optional<HorizontalPortalShape> horizontal = HorizontalPortalShape.findEmptyPortalShape((LevelAccessor)level, pos);
        if (horizontal.isPresent() && !level.m_5776_()) {
            horizontal.get().createPortalBlocks();
        }
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
        for (Direction searchDirection : Direction.values()) {
            BlockState adjacentState = level.m_8055_((BlockPos)mutablePos.m_122190_((Vec3i)pos).m_122173_(searchDirection));
            if (adjacentState.m_60713_(Blocks.f_50723_)) break;
        }
    }

    private static boolean inPortalDimension(Level level) {
        return level.m_46472_() == Level.f_46428_ || level.m_46472_() == Level.f_46429_;
    }
}

