/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.custom_nether_portals.cursedness;

import com.leclowndu93150.custom_nether_portals.CNPBlocks;
import com.leclowndu93150.custom_nether_portals.block.HorizontalNetherPortalBlock;
import com.leclowndu93150.custom_nether_portals.utils.HashSetQueue;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;

public class HorizontalPortalShape {
    private static final int MIN_SIZE = 1;
    public static final int MAX_SIZE = 21;
    private static final BlockBehaviour.StatePredicate FRAME = (state, level, pos) -> state.m_60713_(Blocks.f_50080_) || state.m_60713_(Blocks.f_50723_);
    private final LevelAccessor level;
    private final BlockPos firePos;
    private Direction.Axis axis = Direction.Axis.X;
    private int numPortalBlocks = 0;
    private boolean valid = false;
    private final HashSet<BlockPos> validPortalPositions = new HashSet();
    private final HashSet<BlockPos> framePositions = new HashSet();

    public static Optional<HorizontalPortalShape> findEmptyPortalShape(LevelAccessor level, BlockPos firePos) {
        return HorizontalPortalShape.findPortalShape(level, firePos, shape -> shape.isValid() && shape.numPortalBlocks == 0);
    }

    public static Optional<HorizontalPortalShape> findPortalShape(LevelAccessor level, BlockPos firePos, Predicate<HorizontalPortalShape> predicate) {
        HorizontalPortalShape shape = new HorizontalPortalShape(level, firePos);
        return predicate.test(shape) ? Optional.of(shape) : Optional.empty();
    }

    public HorizontalPortalShape(LevelAccessor level, BlockPos firePos) {
        this.level = level;
        this.firePos = firePos;
        this.valid = this.checkAreaForPortalValidity();
    }

    private boolean checkAreaForPortalValidity() {
        this.validPortalPositions.clear();
        this.framePositions.clear();
        HashSetQueue<BlockPos> positionsToCheck = new HashSetQueue<BlockPos>();
        HashSet<BlockPos> visitedPositions = new HashSet<BlockPos>();
        List<Direction> horizontalDirections = List.of(Direction.NORTH, Direction.SOUTH, Direction.EAST, Direction.WEST);
        positionsToCheck.push(this.firePos);
        while (!positionsToCheck.isEmpty()) {
            BlockPos pos = (BlockPos)positionsToCheck.pop();
            if (visitedPositions.contains(pos)) continue;
            visitedPositions.add(pos);
            BlockState state = this.level.m_8055_(pos);
            if (HorizontalPortalShape.isValidPortalBlock(state) && pos.m_123342_() == this.firePos.m_123342_()) {
                this.validPortalPositions.add(pos);
                if (this.validPortalPositions.size() > 441) {
                    return false;
                }
                if (state.m_60713_(Blocks.f_50142_) || state.m_60734_() instanceof HorizontalNetherPortalBlock) {
                    ++this.numPortalBlocks;
                }
                for (Direction dir : horizontalDirections) {
                    BlockPos neighborPos = pos.m_121945_(dir);
                    if (visitedPositions.contains(neighborPos)) continue;
                    positionsToCheck.push(neighborPos);
                }
                continue;
            }
            if (FRAME.m_61035_(state, (BlockGetter)this.level, pos) && pos.m_123342_() == this.firePos.m_123342_()) {
                this.framePositions.add(pos);
                continue;
            }
            if (pos.m_123342_() == this.firePos.m_123342_() && HorizontalPortalShape.isValidPortalBlock(state)) continue;
            return false;
        }
        if (!this.hasCompleteFrame()) {
            return false;
        }
        this.determineAxis();
        return this.validPortalPositions.size() >= 1;
    }

    private boolean hasCompleteFrame() {
        for (BlockPos portalPos : this.validPortalPositions) {
            for (Direction dir : Direction.Plane.HORIZONTAL) {
                BlockPos checkPos = portalPos.m_121945_(dir);
                if (this.validPortalPositions.contains(checkPos) || this.framePositions.contains(checkPos)) continue;
                return false;
            }
        }
        return true;
    }

    private void determineAxis() {
        int minX = Integer.MAX_VALUE;
        int maxX = Integer.MIN_VALUE;
        int minZ = Integer.MAX_VALUE;
        int maxZ = Integer.MIN_VALUE;
        for (BlockPos pos : this.validPortalPositions) {
            minX = Math.min(minX, pos.m_123341_());
            maxX = Math.max(maxX, pos.m_123341_());
            minZ = Math.min(minZ, pos.m_123343_());
            maxZ = Math.max(maxZ, pos.m_123343_());
        }
        int xSpan = maxX - minX + 1;
        int zSpan = maxZ - minZ + 1;
        this.axis = xSpan >= zSpan ? Direction.Axis.X : Direction.Axis.Z;
    }

    private static boolean isValidPortalBlock(BlockState state) {
        return state.m_60795_() || state.m_204336_(BlockTags.f_13076_) || state.m_60713_(Blocks.f_50142_) || state.m_60734_() instanceof HorizontalNetherPortalBlock || state.m_60713_(Blocks.f_50723_) || state.m_247087_();
    }

    public boolean isValid() {
        return this.valid;
    }

    public void createPortalBlocks() {
        if (!this.valid || CNPBlocks.HORIZONTAL_NETHER_PORTAL == null) {
            return;
        }
        BlockState portalState = (BlockState)CNPBlocks.HORIZONTAL_NETHER_PORTAL.m_49966_().m_61124_(HorizontalNetherPortalBlock.AXIS, (Comparable)this.axis);
        this.validPortalPositions.forEach(pos -> this.level.m_7731_(pos, portalState, 18));
    }

    public boolean isComplete() {
        return this.valid && this.validPortalPositions.size() == this.numPortalBlocks;
    }
}

