/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.merequester.client.abstraction;

import appeng.api.behaviors.ContainerItemStrategies;
import appeng.api.behaviors.EmptyingAction;
import appeng.api.stacks.GenericStack;
import appeng.client.gui.AEBaseScreen;
import appeng.client.gui.style.PaletteColor;
import appeng.client.gui.style.ScreenStyle;
import appeng.client.gui.widgets.Scrollbar;
import appeng.core.localization.ButtonToolTips;
import appeng.core.localization.Tooltips;
import appeng.core.sync.BasePacket;
import appeng.core.sync.network.NetworkHandler;
import appeng.core.sync.packets.InventoryActionPacket;
import appeng.helpers.InventoryAction;
import com.almostreliable.merequester.MERequester;
import com.almostreliable.merequester.Utils;
import com.almostreliable.merequester.client.RequestSlot;
import com.almostreliable.merequester.client.abstraction.RequestDisplay;
import com.almostreliable.merequester.client.abstraction.RequesterReference;
import com.almostreliable.merequester.client.widgets.RequestWidget;
import com.almostreliable.merequester.mixin.accessors.WidgetContainerMixin;
import com.almostreliable.merequester.requester.Requests;
import com.almostreliable.merequester.requester.abstraction.AbstractRequesterMenu;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import javax.annotation.OverridingMethodsMustInvokeSuper;
import net.minecraft.class_1661;
import net.minecraft.class_1713;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_364;
import net.minecraft.class_768;

public abstract class AbstractRequesterScreen<M extends AbstractRequesterMenu>
extends AEBaseScreen<M>
implements RequestDisplay {
    protected static final int GUI_WIDTH = 195;
    private static final int GUI_PADDING_X = 8;
    private static final int GUI_PADDING_Y = 6;
    protected static final int GUI_HEADER_HEIGHT = 19;
    protected static final int GUI_FOOTER_HEIGHT = 98;
    private static final int TEXT_MARGIN_X = 2;
    private static final int TEXT_MAX_WIDTH = 156;
    protected static final int ROW_HEIGHT = 19;
    protected static final int MIN_ROW_COUNT = 3;
    private static final class_768 HEADER_BBOX = new class_768(0, 0, 195, 19);
    private static final class_768 TEXT_BBOX = new class_768(0, 19, 195, 19);
    private static final class_768 REQUEST_BBOX = new class_768(0, 38, 195, 19);
    private final class_2960 texture;
    protected final ArrayList<Object> lines = new ArrayList();
    private final Scrollbar scrollbar;
    private final List<RequestWidget> requestWidgets = new ArrayList<RequestWidget>();
    protected boolean refreshList;
    protected int rowAmount;

    protected AbstractRequesterScreen(M menu, class_1661 playerInventory, class_2561 name, ScreenStyle style, class_2960 texture) {
        super(menu, playerInventory, name, style);
        this.texture = texture;
        this.scrollbar = this.widgets.addScrollBar("scrollbar");
        this.field_2792 = 195;
    }

    @Override
    public void addSubWidget(String id, class_339 widget, Map<String, class_339> subWidgets) {
        if (widget.method_25370()) {
            widget.method_25365(false);
        }
        widget.method_46421(widget.method_46426() + this.field_2776);
        widget.method_46419(widget.method_46427() + this.field_2800);
        subWidgets.put(id, widget);
        Utils.cast(this.widgets, WidgetContainerMixin.class).merequester$getWidgets().put(id, widget);
        this.method_37063((class_364)widget);
    }

    @Override
    @Nullable
    public Requests.Request getTargetRequest(int listIndex) {
        Requests.Request request;
        if (listIndex >= this.lines.size()) {
            return null;
        }
        Object lineElement = this.lines.get(this.scrollbar.getCurrentScroll() + listIndex);
        return lineElement instanceof Requests.Request ? (request = (Requests.Request)lineElement) : null;
    }

    @Override
    @Nullable
    public List<class_2561> getEmptyingTooltip(RequestSlot slot, class_1799 carried) {
        EmptyingAction emptyingAction = this.getEmptyingAction((class_1735)slot, carried);
        if (emptyingAction == null) {
            return null;
        }
        return Tooltips.getEmptyingTooltip((ButtonToolTips)ButtonToolTips.SetAction, (class_1799)carried, (EmptyingAction)emptyingAction);
    }

    public void updateFromMenu(boolean clearData, long requesterId, class_2487 data) {
        if (clearData) {
            this.clear();
            this.refreshList();
            return;
        }
        String name = data.method_10558("unique_name");
        long sortBy = data.method_10537("sort_by");
        Requests requests = this.getById(requesterId, name, sortBy).getRequests();
        for (int i = 0; i < requests.size(); ++i) {
            String requestIndex = String.valueOf(i);
            if (!data.method_10545(requestIndex)) continue;
            requests.get(i).deserialize(data.method_10562(requestIndex));
        }
        if (this.refreshList) {
            this.refreshList();
        }
    }

    @OverridingMethodsMustInvokeSuper
    protected void method_25426() {
        this.field_2779 = 117 + this.rowAmount * 19;
        this.requestWidgets.forEach(w -> w.preInit(Utils.cast(this.widgets, WidgetContainerMixin.class).merequester$getWidgets()));
        super.method_25426();
        this.requestWidgets.clear();
        for (int i = 0; i < this.rowAmount; ++i) {
            RequestWidget requestWidget = new RequestWidget(this, i, 8, (i + 1) * 19, this.style);
            requestWidget.postInit();
            this.requestWidgets.add(requestWidget);
        }
        this.resetScrollbar();
    }

    @Nullable
    protected EmptyingAction getEmptyingAction(class_1735 slot, class_1799 carried) {
        if (slot instanceof RequestSlot) {
            RequestSlot requestSlot = (RequestSlot)slot;
            EmptyingAction emptyingAction = ContainerItemStrategies.getEmptyingAction((class_1799)carried);
            if (emptyingAction == null) {
                return null;
            }
            class_1799 wrappedStack = GenericStack.wrapInItemStack((GenericStack)new GenericStack(emptyingAction.what(), 1L));
            if (!requestSlot.getInventory().isItemValid(requestSlot.getSlot(), wrappedStack)) {
                return null;
            }
            return emptyingAction;
        }
        return super.getEmptyingAction(slot, carried);
    }

    public void drawFG(class_332 guiGraphics, int pX, int pY, int mX, int mY) {
        ((AbstractRequesterMenu)this.field_2797).field_7761.removeIf(RequestSlot.class::isInstance);
        int textColor = this.style.getColor(PaletteColor.DEFAULT_TEXT_COLOR).toARGB();
        if (this.lines.isEmpty()) {
            String text = Utils.translateAsString("gui", "no_requesters");
            int textWidth = this.field_22793.method_1727(text);
            guiGraphics.method_51433(this.field_22793, text, (int)((float)(195 - textWidth) / 2.0f - 10.0f), 25, textColor, false);
            this.requestWidgets.forEach(RequestWidget::hide);
            return;
        }
        int scrollLevel = this.scrollbar.getCurrentScroll();
        for (int i = 0; i < this.rowAmount; ++i) {
            if (scrollLevel + i >= this.lines.size()) {
                this.requestWidgets.get(i).hide();
                continue;
            }
            Object lineElement = this.lines.get(scrollLevel + i);
            if (lineElement instanceof Requests.Request) {
                Requests.Request request = (Requests.Request)lineElement;
                ((AbstractRequesterMenu)this.field_2797).field_7761.add((Object)this.createSlot(i, request));
                this.requestWidgets.get(i).applyRequest(request);
                continue;
            }
            if (lineElement instanceof String) {
                String name;
                String text = name = (String)lineElement;
                int rows = this.getByName(name).size();
                if (rows > 1) {
                    text = Utils.f("{} ({})", text, rows);
                }
                text = this.field_22793.method_27524(text, 156, true);
                guiGraphics.method_51433(this.field_22793, text, 10, 25 + i * 19, textColor, false);
                this.requestWidgets.get(i).hide();
                continue;
            }
            MERequester.LOGGER.debug("Unknown line element: {}", lineElement);
        }
    }

    protected void method_2383(@Nullable class_1735 slot, int slotIndex, int mouseButton, class_1713 clickType) {
        if (!(slot instanceof RequestSlot)) {
            super.method_2383(slot, slotIndex, mouseButton, clickType);
            return;
        }
        RequestSlot requestSlot = (RequestSlot)slot;
        if (requestSlot.isLocked()) {
            return;
        }
        if (mouseButton == 1 && this.getEmptyingAction(slot, ((AbstractRequesterMenu)this.field_2797).method_34255()) != null) {
            InventoryActionPacket packet = new InventoryActionPacket(InventoryAction.EMPTY_ITEM, requestSlot.getSlot(), requestSlot.getRequesterReference().getRequesterId());
            NetworkHandler.instance().sendToServer((BasePacket)packet);
            return;
        }
        InventoryAction action = null;
        switch (clickType) {
            case field_7790: {
                action = mouseButton == 1 ? InventoryAction.SPLIT_OR_PLACE_SINGLE : InventoryAction.PICKUP_OR_SET_DOWN;
                break;
            }
            case field_7794: {
                action = mouseButton == 1 ? InventoryAction.PICKUP_SINGLE : InventoryAction.SHIFT_CLICK;
                break;
            }
            case field_7796: {
                if (!this.getPlayer().method_31549().field_7477) break;
                action = InventoryAction.CREATIVE_DUPLICATE;
                break;
            }
        }
        if (action != null) {
            InventoryActionPacket packet = new InventoryActionPacket(action, requestSlot.getSlot(), requestSlot.getRequesterReference().getRequesterId());
            NetworkHandler.instance().sendToServer((BasePacket)packet);
        }
    }

    public void drawBG(class_332 guiGraphics, int pX, int pY, int mX, int mY, float partial) {
        this.blit(guiGraphics, pX, pY, HEADER_BBOX);
        int scrollLevel = this.scrollbar.getCurrentScroll();
        int currentY = pY + 19;
        this.blit(guiGraphics, pX, currentY + this.rowAmount * 19, this.getFooterBounds());
        for (int i = 0; i < this.rowAmount; ++i) {
            boolean isRequestElement = false;
            if (scrollLevel + i < this.lines.size()) {
                Object lineElement = this.lines.get(scrollLevel + i);
                isRequestElement = lineElement instanceof Requests.Request;
            }
            this.blit(guiGraphics, pX, currentY, isRequestElement ? REQUEST_BBOX : TEXT_BBOX);
            currentY += 19;
        }
    }

    protected void resetScrollbar() {
        this.scrollbar.setHeight(this.rowAmount * 19 + 1);
        this.scrollbar.setRange(0, this.lines.size() - this.rowAmount, 2);
    }

    protected abstract void clear();

    protected abstract void refreshList();

    protected abstract Set<RequesterReference> getByName(String var1);

    protected abstract RequesterReference getById(long var1, String var3, long var4);

    private void blit(class_332 guiGraphics, int pX, int pY, class_768 srcRect) {
        guiGraphics.method_25302(this.texture, pX, pY, srcRect.method_3321(), srcRect.method_3322(), srcRect.method_3319(), srcRect.method_3320());
    }

    private RequestSlot createSlot(int index, Requests.Request request) {
        RequestSlot slot = new RequestSlot(this, (RequesterReference)request.getRequesterReference(), request.getIndex(), 27, (index + 1) * 19 + 1);
        slot.setHideAmount(true);
        slot.setLocked(request.getClientStatus().locksRequest());
        return slot;
    }

    protected abstract class_768 getFooterBounds();
}

