/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.util;

import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import net.fabricmc.fabric.api.transfer.v1.item.InventoryStorage;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StoragePreconditions;
import net.fabricmc.fabric.api.transfer.v1.storage.TransferVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.base.CombinedStorage;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleSlotStorage;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import org.jetbrains.annotations.Nullable;

public class StorageUtil2 {
    @Nullable
    public static Storage<ItemVariant> wrapInventory(@Nullable Storage<ItemVariant> foundStorage) {
        if (foundStorage instanceof InventoryStorage) {
            InventoryStorage wrapper = (InventoryStorage)foundStorage;
            return new SmarterInventoryStorage(wrapper.getSlots());
        }
        return foundStorage;
    }

    public static <T> Iterator<T> singletonIterator(final T it) {
        return new Iterator<T>(){
            boolean hasNext = true;

            @Override
            public boolean hasNext() {
                return this.hasNext;
            }

            @Override
            public T next() {
                if (!this.hasNext) {
                    throw new NoSuchElementException();
                }
                this.hasNext = false;
                return it;
            }
        };
    }

    private static class SmarterInventoryStorage
    extends CombinedStorage<ItemVariant, SingleSlotStorage<ItemVariant>> {
        public SmarterInventoryStorage(List<SingleSlotStorage<ItemVariant>> parts) {
            super(parts);
        }

        public long insert(ItemVariant resource, long maxAmount, TransactionContext transaction) {
            StoragePreconditions.notBlankNotNegative((TransferVariant)resource, (long)maxAmount);
            long amount = 0L;
            for (int iter = 0; iter < 2; ++iter) {
                for (SingleSlotStorage part : this.parts) {
                    if (iter != 1 && part.isResourceBlank()) continue;
                    amount += part.insert((Object)resource, maxAmount - amount, transaction);
                }
            }
            return amount;
        }
    }
}

