/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.textures.coloramp;

import aztech.modern_industrialization.textures.TextureHelper;
import aztech.modern_industrialization.textures.coloramp.IColoramp;
import java.awt.Color;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public class DepletedColoramp
implements IColoramp {
    private final IColoramp coloramp;

    public DepletedColoramp(IColoramp coloramp) {
        this.coloramp = coloramp;
    }

    @Override
    public int getRGB(double luminance) {
        float[] hsbval = new float[3];
        int rgb = this.coloramp.getRGB(luminance);
        Color.RGBtoHSB(TextureHelper.getRrgb(rgb), TextureHelper.getGrgb(rgb), TextureHelper.getBrgb(rgb), hsbval);
        return 0xFFFFFF & Color.HSBtoRGB(hsbval[0], 0.2f * hsbval[0], 0.5f * hsbval[2]);
    }

    @Override
    public int getMeanRGB() {
        float[] hsbval = new float[3];
        int rgb = this.coloramp.getMeanRGB();
        Color.RGBtoHSB(TextureHelper.getRrgb(rgb), TextureHelper.getGrgb(rgb), TextureHelper.getBrgb(rgb), hsbval);
        return 0xFFFFFF & Color.HSBtoRGB(hsbval[0], 0.2f * hsbval[0], 0.5f * hsbval[2]);
    }
}

