/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.textures;

import aztech.modern_industrialization.textures.IORunnable;
import aztech.modern_industrialization.textures.MCMetaInfo;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import java.io.IOException;
import java.io.InputStream;
import java.util.Optional;
import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.BiConsumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1011;
import net.minecraft.class_156;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_5912;

@Environment(value=EnvType.CLIENT)
public class TextureManager {
    private final class_5912 rm;
    private final BiConsumer<class_1011, String> textureWriter;
    private final BiConsumer<JsonElement, String> mcMetaWriter;
    private final Queue<IORunnable> endRunnables = new ConcurrentLinkedQueue<IORunnable>();
    private final Gson GSON = new Gson();

    public TextureManager(class_5912 rm, BiConsumer<class_1011, String> textureWriter, BiConsumer<JsonElement, String> mcMetaWriter) {
        this.rm = rm;
        this.textureWriter = textureWriter;
        this.mcMetaWriter = mcMetaWriter;
    }

    public boolean hasAsset(String asset) {
        return this.rm.method_14486(new class_2960(asset)).isPresent();
    }

    public class_1011 getAssetAsTexture(String textureId) throws IOException {
        Optional resource = this.rm.method_14486(new class_2960(textureId));
        if (resource.isPresent()) {
            try (InputStream stream = ((class_3298)resource.get()).method_14482();){
                class_1011 class_10112 = class_1011.method_4309((InputStream)stream);
                return class_10112;
            }
        }
        throw new IOException("Couldn't find texture " + textureId);
    }

    public void addTexture(String textureId, class_1011 image) throws IOException {
        this.addTexture(textureId, image, false);
    }

    public void addTexture(String textureId, class_1011 image, boolean closeImage) throws IOException {
        block15: {
            if (!textureId.contains(":textures/")) {
                throw new IllegalArgumentException("Invalid texture location: " + textureId);
            }
            String overrideId = textureId.replace(":textures/", ":datagen_texture_overrides/");
            Optional overrideResource = this.rm.method_14486(new class_2960(overrideId));
            if (overrideResource.isPresent()) {
                try (InputStream stream = ((class_3298)overrideResource.get()).method_14482();
                     class_1011 overrideImage = class_1011.method_4309((InputStream)stream);){
                    this.textureWriter.accept(overrideImage, textureId);
                    break block15;
                }
            }
            this.textureWriter.accept(image, textureId);
        }
        if (closeImage) {
            image.close();
        }
    }

    public void addMcMeta(String path, MCMetaInfo info) {
        this.mcMetaWriter.accept(this.GSON.toJsonTree((Object)info), path);
    }

    public void runAtEnd(IORunnable runnable) {
        this.endRunnables.add(runnable);
    }

    public CompletableFuture<?> doEndWork() {
        CompletableFuture<Void> ret = CompletableFuture.allOf((CompletableFuture[])this.endRunnables.stream().map(r -> CompletableFuture.runAsync(r::safeRun, class_156.method_18349())).toArray(CompletableFuture[]::new));
        this.endRunnables.clear();
        return ret;
    }
}

