/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.textures;

import aztech.modern_industrialization.textures.coloramp.IColoramp;
import java.awt.Color;
import java.util.Arrays;
import java.util.List;
import java.util.function.BiFunction;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1011;

@Environment(value=EnvType.CLIENT)
public class TextureHelper {
    public static void colorize(class_1011 image, IColoramp colorramp) {
        for (int i = 0; i < image.method_4307(); ++i) {
            for (int j = 0; j < image.method_4323(); ++j) {
                int color = image.method_4315(i, j);
                double l = TextureHelper.getLuminance(color);
                int rgb = colorramp.getRGB(l);
                int r = TextureHelper.getRrgb(rgb);
                int g = TextureHelper.getGrgb(rgb);
                int b = TextureHelper.getBrgb(rgb);
                image.method_4305(i, j, TextureHelper.fromArgb(TextureHelper.getA(color), r, g, b));
            }
        }
    }

    public static void setAlpha(class_1011 image, int alpha) {
        for (int i = 0; i < image.method_4307(); ++i) {
            for (int j = 0; j < image.method_4323(); ++j) {
                int color = image.method_4315(i, j);
                int r = TextureHelper.getR(color);
                int g = TextureHelper.getG(color);
                int b = TextureHelper.getB(color);
                image.method_4305(i, j, TextureHelper.fromArgb(alpha, r, g, b));
            }
        }
    }

    public static void increaseBrightness(class_1011 image, float minBrightness) {
        for (int i = 0; i < image.method_4307(); ++i) {
            for (int j = 0; j < image.method_4323(); ++j) {
                int color = image.method_4315(i, j);
                double l = TextureHelper.getLuminance(color);
                int r = TextureHelper.getR(color);
                int g = TextureHelper.getG(color);
                int b = TextureHelper.getB(color);
                int rgb = TextureHelper.inecreaseBrightness(TextureHelper.toRGB(r, g, b), minBrightness);
                r = TextureHelper.getRrgb(rgb);
                g = TextureHelper.getGrgb(rgb);
                b = TextureHelper.getBrgb(rgb);
                image.method_4305(i, j, TextureHelper.fromArgb(TextureHelper.getA(color), r, g, b));
            }
        }
    }

    public static double getLuminance(int color) {
        return (0.2126 * (double)TextureHelper.getR(color) + 0.7152 * (double)TextureHelper.getG(color) + 0.0722 * (double)TextureHelper.getB(color)) / 255.0;
    }

    public static int mixRGB(int rgb1, int rgb2, double fact) {
        int r1 = TextureHelper.getRrgb(rgb1);
        int r2 = TextureHelper.getRrgb(rgb2);
        int g1 = TextureHelper.getGrgb(rgb1);
        int g2 = TextureHelper.getGrgb(rgb2);
        int b1 = TextureHelper.getBrgb(rgb1);
        int b2 = TextureHelper.getBrgb(rgb2);
        return TextureHelper.toRGB((int)(fact * (double)r1 + (1.0 - fact) * (double)r2), (int)(fact * (double)g1 + (1.0 - fact) * (double)g2), (int)(fact * (double)b1 + (1.0 - fact) * (double)b2));
    }

    public static int setHue(int rgb, float hue) {
        float[] hsbval = new float[3];
        Color.RGBtoHSB(TextureHelper.getRrgb(rgb), TextureHelper.getGrgb(rgb), TextureHelper.getBrgb(rgb), hsbval);
        return 0xFFFFFF & Color.HSBtoRGB(hue, hsbval[1], hsbval[2]);
    }

    public static int setSaturation(int rgb, float sat) {
        float[] hsbval = new float[3];
        Color.RGBtoHSB(TextureHelper.getRrgb(rgb), TextureHelper.getGrgb(rgb), TextureHelper.getBrgb(rgb), hsbval);
        return 0xFFFFFF & Color.HSBtoRGB(hsbval[0], sat, hsbval[2]);
    }

    public static int inecreaseBrightness(int rgb, float minBrightness) {
        float[] hsbval = new float[3];
        Color.RGBtoHSB(TextureHelper.getRrgb(rgb), TextureHelper.getGrgb(rgb), TextureHelper.getBrgb(rgb), hsbval);
        return 0xFFFFFF & Color.HSBtoRGB(hsbval[0], hsbval[1], minBrightness + (1.0f - minBrightness) * hsbval[2]);
    }

    public static int toRGB(int r, int g, int b) {
        return (r << 16) + (g << 8) + b;
    }

    public static int getRrgb(int rgb) {
        return rgb >> 16 & 0xFF;
    }

    public static int getGrgb(int rgb) {
        return rgb >> 8 & 0xFF;
    }

    public static int getBrgb(int rgb) {
        return rgb & 0xFF;
    }

    public static void adjustDimensions(List<class_1011> images) {
        int maxWidth = 0;
        int maxHeight = 0;
        for (class_1011 image : images) {
            maxWidth = Math.max(maxWidth, image.method_4307());
            maxHeight = Math.max(maxHeight, image.method_4323());
        }
        for (int imageIndex = 0; imageIndex < images.size(); ++imageIndex) {
            class_1011 image;
            image = images.get(imageIndex);
            if (maxWidth % image.method_4307() != 0 || maxHeight % image.method_4323() != 0) {
                String error = String.format("Mismatched dimensions, can't adjust. Max: (%d, %d). Current image: (%d, %d).", maxWidth, maxHeight, image.method_4307(), image.method_4323());
                throw new IllegalArgumentException(error);
            }
            int wFactor = maxWidth / image.method_4307();
            int hFactor = maxHeight / image.method_4323();
            if (wFactor == 1 && hFactor == 1) continue;
            class_1011 newImage = new class_1011(maxWidth, maxHeight, false);
            for (int i = 0; i < maxWidth; ++i) {
                for (int j = 0; j < maxHeight; ++j) {
                    newImage.method_4305(i, j, image.method_4315(i / wFactor, j / hFactor));
                }
            }
            images.set(imageIndex, newImage);
        }
    }

    public static class_1011 blend(class_1011 originalSource, class_1011 originalTop) {
        List<class_1011> images = Arrays.asList(originalSource, originalTop);
        TextureHelper.adjustDimensions(images);
        class_1011 source = images.get(0);
        class_1011 top = images.get(1);
        class_1011 output = new class_1011(source.method_4307(), source.method_4323(), false);
        for (int i = 0; i < source.method_4307(); ++i) {
            for (int j = 0; j < source.method_4323(); ++j) {
                int sourceColor = source.method_4315(i, j);
                int topColor = top.method_4315(i, j);
                double alphaSource = (double)TextureHelper.getA(sourceColor) / 255.0;
                double alphaTop = (double)TextureHelper.getA(topColor) / 255.0;
                double alphaOut = alphaTop + alphaSource * (1.0 - alphaTop);
                BiFunction<Integer, Integer, Integer> mergeAlpha = (sourceValue, topValue) -> (int)(((double)topValue.intValue() * alphaTop + (double)sourceValue.intValue() * alphaSource * (1.0 - alphaTop)) / alphaOut);
                output.method_4305(i, j, TextureHelper.fromArgb((int)(alphaOut * 255.0), mergeAlpha.apply(TextureHelper.getR(sourceColor), TextureHelper.getR(topColor)), mergeAlpha.apply(TextureHelper.getG(sourceColor), TextureHelper.getG(topColor)), mergeAlpha.apply(TextureHelper.getB(sourceColor), TextureHelper.getB(topColor))));
            }
        }
        return output;
    }

    public static class_1011 tripleTexture(class_1011 im1, class_1011 im2, class_1011 im3) {
        return TextureHelper.tripleTexture(im1, im2, im3, 2, 2);
    }

    public static class_1011 tripleTexture(class_1011 im1, class_1011 im2, class_1011 im3, int up, int down) {
        class_1011 lowerIngot = new class_1011(im1.method_4307(), im1.method_4323(), true);
        lowerIngot.method_4317(im1);
        int shiftDown = lowerIngot.method_4323() * up / 16;
        for (int x = 0; x < lowerIngot.method_4307(); ++x) {
            int y = lowerIngot.method_4323();
            while (y-- > 0) {
                if (y >= shiftDown) {
                    lowerIngot.method_4305(x, y, lowerIngot.method_4315(x, y - shiftDown));
                    continue;
                }
                lowerIngot.method_4305(x, y, 0);
            }
        }
        class_1011 upperIngot = new class_1011(im3.method_4307(), im3.method_4323(), true);
        upperIngot.method_4317(im3);
        int shiftUp = upperIngot.method_4323() * down / 16;
        for (int x = 0; x < upperIngot.method_4307(); ++x) {
            for (int y = 0; y < upperIngot.method_4323(); ++y) {
                if (y + shiftUp < upperIngot.method_4323()) {
                    upperIngot.method_4305(x, y, upperIngot.method_4315(x, y + shiftUp));
                    continue;
                }
                upperIngot.method_4305(x, y, 0);
            }
        }
        lowerIngot = TextureHelper.blend(lowerIngot, im2);
        lowerIngot = TextureHelper.blend(lowerIngot, upperIngot);
        upperIngot.close();
        return lowerIngot;
    }

    public static void doubleIngot(class_1011 image) {
        class_1011 lowerIngot = new class_1011(image.method_4307(), image.method_4323(), true);
        lowerIngot.method_4317(image);
        int shiftDown = lowerIngot.method_4323() * 2 / 16;
        for (int x = 0; x < lowerIngot.method_4307(); ++x) {
            int y = lowerIngot.method_4323();
            while (y-- > 0) {
                if (y >= shiftDown) {
                    lowerIngot.method_4305(x, y, lowerIngot.method_4315(x, y - shiftDown));
                    continue;
                }
                lowerIngot.method_4305(x, y, 0);
            }
        }
        class_1011 upperIngot = new class_1011(image.method_4307(), image.method_4323(), true);
        upperIngot.method_4317(image);
        int shiftUp = upperIngot.method_4323() * 2 / 16;
        for (int x = 0; x < upperIngot.method_4307(); ++x) {
            for (int y = 0; y < upperIngot.method_4323(); ++y) {
                if (y + shiftUp < upperIngot.method_4323()) {
                    upperIngot.method_4305(x, y, upperIngot.method_4315(x, y + shiftUp));
                    continue;
                }
                upperIngot.method_4305(x, y, 0);
            }
        }
        lowerIngot = TextureHelper.blend(lowerIngot, upperIngot);
        image.method_4317(lowerIngot);
        lowerIngot.close();
        upperIngot.close();
    }

    public static int getA(int color) {
        return color >> 24 & 0xFF;
    }

    public static int getR(int color) {
        return color & 0xFF;
    }

    public static int getG(int color) {
        return color >> 8 & 0xFF;
    }

    public static int getB(int color) {
        return color >> 16 & 0xFF;
    }

    public static int fromArgb(int a, double r, double g, double b) {
        return TextureHelper.fromArgb(a, (int)r, (int)g, (int)b);
    }

    public static int fromArgb(int a, int r, int g, int b) {
        return a << 24 | b << 16 | g << 8 | r;
    }

    public static void flip(class_1011 image) {
        int j;
        int i;
        int width = image.method_4307();
        int height = image.method_4323();
        int[][] flipped = new int[width][height];
        for (i = 0; i < width; ++i) {
            for (j = 0; j < height; ++j) {
                flipped[i][height - j - 1] = image.method_4315(i, j);
            }
        }
        for (i = 0; i < width; ++i) {
            for (j = 0; j < height; ++j) {
                image.method_4305(i, j, flipped[i][j]);
            }
        }
    }

    public static class_1011 copy(class_1011 image) {
        class_1011 copy = new class_1011(image.method_4307(), image.method_4323(), true);
        copy.method_4317(image);
        return copy;
    }

    public static int getOverlayTextColor(int rgb) {
        double luminance = TextureHelper.getLuminance(rgb);
        if (luminance < 0.5) {
            return 0xFFFFFF;
        }
        return 0;
    }
}

