/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.pipes.electricity;

import aztech.modern_industrialization.api.energy.CableTier;
import aztech.modern_industrialization.api.energy.EnergyApi;
import aztech.modern_industrialization.api.energy.MIEnergyStorage;
import aztech.modern_industrialization.pipes.api.PipeEndpointType;
import aztech.modern_industrialization.pipes.api.PipeNetwork;
import aztech.modern_industrialization.pipes.api.PipeNetworkNode;
import aztech.modern_industrialization.pipes.electricity.ElectricityNetwork;
import aztech.modern_industrialization.pipes.impl.PipeBlockEntity;
import aztech.modern_industrialization.util.NbtHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.fabricmc.fabric.api.lookup.v1.block.BlockApiCache;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_3218;
import org.jetbrains.annotations.NotNull;

public class ElectricityNetworkNode
extends PipeNetworkNode {
    private List<class_2350> connections = new ArrayList<class_2350>();
    private final List<BlockApiCache<MIEnergyStorage, @NotNull class_2350>> caches = new ArrayList<BlockApiCache<MIEnergyStorage, class_2350>>();
    long eu = 0L;

    public void appendAttributes(class_3218 world, class_2338 pos, CableTier cableTier, List<MIEnergyStorage> storages) {
        if (this.caches.size() != this.connections.size()) {
            this.caches.clear();
            for (class_2350 direction : this.connections) {
                this.caches.add((BlockApiCache<MIEnergyStorage, class_2350>)BlockApiCache.create(EnergyApi.SIDED, (class_3218)world, (class_2338)pos.method_10093(direction)));
            }
        }
        for (int i = 0; i < this.connections.size(); ++i) {
            class_2350 targetDir = this.connections.get(i).method_10153();
            MIEnergyStorage storage = (MIEnergyStorage)this.caches.get(i).find((Object)targetDir);
            if (storage == null || !storage.canConnect(cableTier)) continue;
            storages.add(storage);
        }
    }

    @Override
    public void buildInitialConnections(class_1937 world, class_2338 pos) {
        for (class_2350 direction : class_2350.values()) {
            if (!this.canConnect(world, pos, direction)) continue;
            this.connections.add(direction);
        }
    }

    @Override
    public void updateConnections(class_1937 world, class_2338 pos) {
        int i = 0;
        while (i < this.connections.size()) {
            if (this.canConnect(world, pos, this.connections.get(i))) {
                ++i;
                continue;
            }
            this.connections.remove(i);
            this.caches.clear();
        }
    }

    @Override
    public PipeEndpointType[] getConnections(class_2338 pos) {
        PipeEndpointType[] connections = new PipeEndpointType[6];
        for (class_2350 direction : this.network.manager.getNodeLinks(pos)) {
            connections[direction.method_10146()] = PipeEndpointType.PIPE;
        }
        for (class_2350 connection : this.connections) {
            connections[connection.method_10146()] = PipeEndpointType.BLOCK;
        }
        return connections;
    }

    @Override
    public void removeConnection(class_1937 world, class_2338 pos, class_2350 direction) {
        for (int i = 0; i < this.connections.size(); ++i) {
            if (this.connections.get(i) != direction) continue;
            this.connections.remove(i);
            this.caches.clear();
            return;
        }
    }

    @Override
    public void addConnection(PipeBlockEntity pipe, class_1657 player, class_1937 world, class_2338 pos, class_2350 direction) {
        for (class_2350 connection : this.connections) {
            if (connection != direction) continue;
            return;
        }
        if (this.canConnect(world, pos, direction)) {
            this.connections.add(direction);
            this.caches.clear();
        }
    }

    @Override
    public class_2487 toTag(class_2487 tag) {
        tag.method_10567("connections", NbtHelper.encodeDirections(this.connections));
        tag.method_10544("eu", this.eu);
        return tag;
    }

    @Override
    public void fromTag(class_2487 tag) {
        this.connections = new ArrayList<class_2350>(Arrays.asList(NbtHelper.decodeDirections(tag.method_10571("connections"))));
        this.caches.clear();
        this.eu = tag.method_10537("eu");
    }

    private boolean canConnect(class_1937 world, class_2338 pos, class_2350 direction) {
        MIEnergyStorage storage = (MIEnergyStorage)EnergyApi.SIDED.find(world, pos.method_10093(direction), (Object)direction.method_10153());
        return storage != null && (storage.supportsInsertion() || storage.supportsExtraction());
    }

    private long getMaxTransfer() {
        return ((ElectricityNetwork)this.network).tier.getMaxTransfer();
    }

    public InGameInfo collectNetworkInfo() {
        long stored = 0L;
        long capacity = 0L;
        for (PipeNetwork.PosNode posNode : this.network.iterateTickingNodes()) {
            ElectricityNetworkNode node = (ElectricityNetworkNode)posNode.getNode();
            stored += node.eu;
            capacity += this.getMaxTransfer();
        }
        return new InGameInfo(stored, capacity, ((ElectricityNetwork)this.network).stats.getValue(), this.getMaxTransfer());
    }

    public record InGameInfo(long stored, long capacity, long transfer, long maxTransfer) {
    }
}

