/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.materials.part;

import aztech.modern_industrialization.MIBlock;
import aztech.modern_industrialization.MIItem;
import aztech.modern_industrialization.datagen.tag.TagsToGenerate;
import aztech.modern_industrialization.definition.BlockDefinition;
import aztech.modern_industrialization.items.SortOrder;
import aztech.modern_industrialization.materials.MaterialBuilder;
import aztech.modern_industrialization.materials.part.MIParts;
import aztech.modern_industrialization.materials.part.MaterialItemPart;
import aztech.modern_industrialization.materials.part.MaterialItemPartImpl;
import aztech.modern_industrialization.materials.part.PartEnglishNameFormatter;
import aztech.modern_industrialization.materials.part.PartItemPathFormatter;
import aztech.modern_industrialization.materials.part.PartKey;
import aztech.modern_industrialization.materials.part.PartKeyProvider;
import aztech.modern_industrialization.materials.part.TextureGenParams;
import aztech.modern_industrialization.util.TagHelper;
import net.minecraft.class_1792;
import net.minecraft.class_2248;
import net.minecraft.class_4946;
import net.minecraft.class_4970;

public class PartTemplate
implements PartKeyProvider {
    private final PartEnglishNameFormatter englishNameFormatter;
    private final PartKey partKey;
    private final Register register;
    private final TextureGenParams textureGenParams;
    private final PartItemPathFormatter itemPathFormatter;

    public PartTemplate(PartEnglishNameFormatter englishNameFormatter, String key) {
        this(englishNameFormatter, key, (partContext, part, itemPath, itemId, itemTag, englishName) -> {
            class_1792 item = PartTemplate.createSimpleItem(englishName, itemPath, partContext, part);
            PartTemplate.setupTag(partContext, part, itemTag, item);
        }, new TextureGenParams.SimpleRecoloredItem());
    }

    public PartTemplate(PartEnglishNameFormatter englishNameFormatter, PartKey key) {
        this(englishNameFormatter, key, (partContext, part, itemPath, itemId, itemTag, englishName) -> {
            class_1792 item = PartTemplate.createSimpleItem(englishName, itemPath, partContext, part);
            PartTemplate.setupTag(partContext, part, itemTag, item);
        }, new TextureGenParams.SimpleRecoloredItem(), new PartItemPathFormatter.Default());
    }

    public PartTemplate(String englishName, String key) {
        this((PartEnglishNameFormatter)new PartEnglishNameFormatter.Default(englishName), key);
    }

    public PartTemplate(String englishName, PartKey key) {
        this((PartEnglishNameFormatter)new PartEnglishNameFormatter.Default(englishName), key);
    }

    private PartTemplate(PartEnglishNameFormatter englishNameFormatter, String key, Register register, TextureGenParams textureGenParams) {
        this(englishNameFormatter, new PartKey(key), register, textureGenParams, new PartItemPathFormatter.Default());
    }

    private PartTemplate(PartEnglishNameFormatter englishNameFormatter, PartKey key, Register register, TextureGenParams textureGenParams, PartItemPathFormatter itemPathFormatter) {
        this.partKey = key;
        this.englishNameFormatter = englishNameFormatter;
        this.register = register;
        this.textureGenParams = textureGenParams;
        this.itemPathFormatter = itemPathFormatter;
    }

    public static class_1792 createSimpleItem(String englishName, String itemPath, MaterialBuilder.PartContext partContext, PartKey part) {
        return MIItem.item(englishName, itemPath, SortOrder.MATERIALS.and((Comparable)((Object)partContext.getMaterialName())).and(part)).method_8389();
    }

    private static void setupTag(MaterialBuilder.PartContext context, PartKey part, String itemTag, class_1792 item) {
        for (PartKey partTagged : MIParts.TAGGED_PARTS) {
            if (!partTagged.equals(part)) continue;
            String generatedTag = itemTag.replaceFirst("#", "");
            TagsToGenerate.generateTag(generatedTag, item, PartTemplate.getTagEnglishName(context, itemTag));
            MIParts.CategoryTag categoryTag = MIParts.CATEGORY_TAGS.get(partTagged.key());
            if (categoryTag == null) continue;
            TagsToGenerate.addTagToTag(generatedTag, categoryTag.tag(), categoryTag.englishName());
        }
    }

    private static String getTagEnglishName(MaterialBuilder.PartContext context, String tag) {
        String path = tag.split(":")[1];
        path = path.replace(context.getMaterialName(), context.getMaterialEnglishName());
        path = path.replace('_', ' ');
        StringBuilder sb = new StringBuilder();
        boolean capitalize = true;
        for (char c : path.toCharArray()) {
            if (c == ' ') {
                sb.append(c);
                capitalize = true;
                continue;
            }
            if (capitalize) {
                sb.append(Character.toUpperCase(c));
                capitalize = false;
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public PartTemplate asBlock(SortOrder sortOrder, TextureGenParams textureGenParams, float hardness, float resistance, int miningLevel, boolean doAllowSpawn) {
        Register blockRegister = (partContext, part, itemPath, itemId, itemTag, itemEnglishName) -> {
            class_4970.class_2251 blockParams = MIBlock.BlockDefinitionParams.defaultStone().clearTags().addMoreTags(TagHelper.getMiningLevelTag(miningLevel)).sortOrder(sortOrder.and((Comparable)((Object)partContext.getMaterialName()))).method_36557(hardness).method_36558(resistance);
            if (!doAllowSpawn) {
                blockParams.method_26235((p1, p2, p3, p4) -> false);
            }
            BlockDefinition<class_2248> blockDefinition = MIBlock.block(itemEnglishName, itemPath, blockParams);
            PartTemplate.setupTag(partContext, part, itemTag, blockDefinition.method_8389());
        };
        return new PartTemplate(this.englishNameFormatter, this.partKey, blockRegister, textureGenParams, this.itemPathFormatter);
    }

    public PartTemplate asBlock(SortOrder sortOrder, TextureGenParams textureGenParams, float hardness, float resistance, int miningLevel) {
        return this.asBlock(sortOrder, textureGenParams, hardness, resistance, miningLevel, true);
    }

    public PartTemplate asColumnBlock(SortOrder sortOrder) {
        Register columnBlockRegister = (partContext, part, itemPath, itemId, itemTag, itemEnglishName) -> {
            BlockDefinition<class_2248> blockDefinition = MIBlock.block(itemEnglishName, itemPath, MIBlock.BlockDefinitionParams.defaultStone().clearTags().addMoreTags(TagHelper.getMiningLevelTag(1)).sortOrder(sortOrder.and((Comparable)((Object)partContext.getMaterialName()))).withModel(class_4946.field_23038).method_36557(5.0f).method_36558(6.0f));
            PartTemplate.setupTag(partContext, part, itemTag, blockDefinition.method_8389());
        };
        return new PartTemplate(this.englishNameFormatter, this.partKey, columnBlockRegister, new TextureGenParams.ColumnBlock(), this.itemPathFormatter);
    }

    public PartTemplate withoutTextureRegister() {
        return this.withTexture(new TextureGenParams.NoTexture());
    }

    public PartTemplate asBlock(SortOrder sortOrder, TextureGenParams textureGenParams) {
        return this.asBlock(sortOrder, textureGenParams, 5.0f, 6.0f, 1);
    }

    public PartTemplate withRegister(Register register) {
        return new PartTemplate(this.englishNameFormatter, this.partKey, register, this.textureGenParams, this.itemPathFormatter);
    }

    public PartTemplate withTexture(TextureGenParams textureGenParams) {
        return new PartTemplate(this.englishNameFormatter, this.partKey, this.register, textureGenParams, this.itemPathFormatter);
    }

    public PartTemplate withOverlay(PartKey normal, String overlay) {
        return this.withTexture(new TextureGenParams.SimpleRecoloredItem(normal, overlay));
    }

    public PartTemplate withOverlay(PartKeyProvider normal, String overlay) {
        return this.withOverlay(normal.key(), overlay);
    }

    public PartTemplate withCustomPath(String itemPath, String itemTag) {
        return new PartTemplate(this.englishNameFormatter, this.partKey, this.register, this.textureGenParams, new PartItemPathFormatter.Overridden(itemPath, itemTag));
    }

    public PartTemplate withCustomPath(String itemPath) {
        return this.withCustomPath(itemPath, itemPath);
    }

    public TextureGenParams getTextureGenParams() {
        return this.textureGenParams;
    }

    public MaterialItemPart create(String material, String materialEnglishName) {
        String itemPath = this.itemPathFormatter.getPartItemPath(material, this.partKey);
        String itemId = this.itemPathFormatter.getPartItemId(material, this.partKey);
        String itemTag = this.itemPathFormatter.getPartItemTag(material, this.partKey);
        String itemEnglishName = this.englishNameFormatter.format(materialEnglishName);
        return new MaterialItemPartImpl(this.partKey, itemTag, itemId, ctx -> this.register.register((MaterialBuilder.PartContext)ctx, this.partKey, itemPath, itemId, itemTag, itemEnglishName), this.textureGenParams, true);
    }

    @Override
    public PartKey key() {
        return this.partKey;
    }

    @FunctionalInterface
    public static interface Register {
        public void register(MaterialBuilder.PartContext var1, PartKey var2, String var3, String var4, String var5, String var6);
    }
}

