/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.machines.recipe.condition;

import aztech.modern_industrialization.MIText;
import aztech.modern_industrialization.machines.recipe.MachineRecipe;
import aztech.modern_industrialization.machines.recipe.condition.MachineProcessCondition;
import aztech.modern_industrialization.machines.recipe.condition.RelativePosition;
import com.google.gson.JsonObject;
import java.util.List;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_7923;

public class AdjacentBlockProcessCondition
implements MachineProcessCondition {
    public static final Serde SERIALIZER = new Serde();
    private final class_2248 block;
    private final RelativePosition relativePosition;

    public AdjacentBlockProcessCondition(class_2248 block, String relativePosition) {
        this.block = block;
        this.relativePosition = switch (relativePosition) {
            case "below" -> RelativePosition.BELOW;
            case "behind" -> RelativePosition.BEHIND;
            default -> throw new IllegalArgumentException("Invalid position: " + relativePosition);
        };
    }

    @Override
    public boolean canProcessRecipe(MachineProcessCondition.Context context, MachineRecipe recipe) {
        class_2338 checkPos = switch (this.relativePosition) {
            default -> throw new IncompatibleClassChangeError();
            case RelativePosition.BELOW -> context.getBlockEntity().method_11016().method_10074();
            case RelativePosition.BEHIND -> {
                class_2350 direction = context.getBlockEntity().orientation.facingDirection;
                yield context.getBlockEntity().method_11016().method_10093(direction.method_10153());
            }
        };
        return context.getLevel().method_8320(checkPos).method_27852(this.block);
    }

    @Override
    public void appendDescription(List<class_2561> list) {
        MIText text = switch (this.relativePosition) {
            default -> throw new IncompatibleClassChangeError();
            case RelativePosition.BELOW -> MIText.RequiresBlockBelow;
            case RelativePosition.BEHIND -> MIText.RequiresBlockBehind;
        };
        list.add((class_2561)text.text(this.block.method_9518()));
    }

    @Override
    public MachineProcessCondition.Serializer<?> getSerializer() {
        return SERIALIZER;
    }

    private static class Serde
    implements MachineProcessCondition.Serializer<AdjacentBlockProcessCondition> {
        private Serde() {
        }

        @Override
        public AdjacentBlockProcessCondition fromJson(JsonObject json) {
            class_2960 blockId = new class_2960(class_3518.method_15265((JsonObject)json, (String)"block"));
            class_2248 block = (class_2248)class_7923.field_41175.method_17966(blockId).orElseThrow(() -> new IllegalArgumentException("Invalid block: " + blockId));
            String pos = class_3518.method_15265((JsonObject)json, (String)"position");
            return new AdjacentBlockProcessCondition(block, pos);
        }

        @Override
        public JsonObject toJson(AdjacentBlockProcessCondition condition, boolean syncToClient) {
            JsonObject obj = new JsonObject();
            obj.addProperty("block", class_7923.field_41175.method_10221((Object)condition.block).toString());
            obj.addProperty("position", condition.relativePosition.toString());
            return obj;
        }
    }
}

