/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.items.diesel_tools;

import aztech.modern_industrialization.MIText;
import aztech.modern_industrialization.api.FluidFuelRegistry;
import aztech.modern_industrialization.fluid.MIFluid;
import aztech.modern_industrialization.items.DynamicEnchantmentItem;
import aztech.modern_industrialization.items.DynamicToolItem;
import aztech.modern_industrialization.items.FluidFuelItemHelper;
import aztech.modern_industrialization.items.ItemHelper;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.Reference2IntArrayMap;
import it.unimi.dsi.fastutil.objects.Reference2IntMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.fabricmc.fabric.api.mininglevel.v1.MiningLevelManager;
import net.fabricmc.fabric.api.tag.convention.v1.ConventionalItemTags;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1657;
import net.minecraft.class_1743;
import net.minecraft.class_1792;
import net.minecraft.class_1794;
import net.minecraft.class_1799;
import net.minecraft.class_1814;
import net.minecraft.class_1821;
import net.minecraft.class_1832;
import net.minecraft.class_1836;
import net.minecraft.class_1838;
import net.minecraft.class_1887;
import net.minecraft.class_1893;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2465;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3489;
import net.minecraft.class_3611;
import net.minecraft.class_5147;
import net.minecraft.class_5150;
import net.minecraft.class_5712;

public class DieselToolItem
extends class_1792
implements class_5150,
DynamicEnchantmentItem,
DynamicToolItem {
    public static final int CAPACITY = 324000;
    private final double damage;

    public DieselToolItem(class_1792.class_1793 settings, double damage) {
        super(settings.method_7889(1).method_7894(class_1814.field_8907));
        this.damage = damage;
    }

    public boolean method_7870(class_1799 stack) {
        return false;
    }

    public boolean method_7879(class_1799 stack, class_1937 world, class_2680 state, class_2338 pos, class_1309 miner) {
        if (state.method_26214((class_1922)world, pos) != 0.0f) {
            FluidFuelItemHelper.decrement(stack);
        }
        return true;
    }

    public boolean method_7873(class_1799 stack, class_1309 target, class_1309 attacker) {
        FluidFuelItemHelper.decrement(stack);
        return true;
    }

    public boolean isSuitableFor(class_1799 stack, class_2680 state) {
        int requiredLevel = MiningLevelManager.getRequiredMiningLevel((class_2680)state);
        return requiredLevel <= 4 && FluidFuelItemHelper.getAmount(stack) > 0L && this.isSupportedBlock(stack, state);
    }

    public float method_7865(class_1799 stack, class_2680 state) {
        if (this.isSupportedBlock(stack, state)) {
            return this.getMiningSpeedMultiplier(stack);
        }
        return 1.0f;
    }

    private float getMiningSpeedMultiplier(class_1799 stack) {
        FluidVariant fluid;
        int burnTicks;
        long amount = FluidFuelItemHelper.getAmount(stack);
        if (amount > 0L && (burnTicks = FluidFuelRegistry.getEu((fluid = FluidFuelItemHelper.getFluid(stack)).getFluid())) > 0) {
            return 1.0f + (float)burnTicks / 8.0f;
        }
        return 1.0f;
    }

    public Multimap<class_1320, class_1322> getAttributeModifiers(class_1799 stack, class_1304 slot) {
        if (slot == class_1304.field_6173 && FluidFuelItemHelper.getAmount(stack) > 0L) {
            return ItemHelper.createToolModifiers(this.damage * (double)FluidFuelRegistry.getEu(FluidFuelItemHelper.getFluid(stack).getFluid()) / 600.0);
        }
        return ImmutableMultimap.of();
    }

    public void method_7851(class_1799 stack, class_1937 world, List<class_2561> tooltip, class_1836 context) {
        FluidFuelItemHelper.appendTooltip(stack, tooltip, 324000L);
    }

    public boolean method_31567(class_1799 stack) {
        return true;
    }

    public int method_31569(class_1799 stack) {
        return (int)Math.round(this.getDurabilityBarProgress(stack) * 13.0);
    }

    public int method_31571(class_1799 stack) {
        class_3611 fluid = FluidFuelItemHelper.getFluid(stack).getFluid();
        if (fluid instanceof MIFluid) {
            MIFluid cf = (MIFluid)fluid;
            return cf.color;
        }
        return 0;
    }

    public double getDurabilityBarProgress(class_1799 stack) {
        return (double)FluidFuelItemHelper.getAmount(stack) / 324000.0;
    }

    private static boolean isFortune(class_1799 stack) {
        class_2487 tag = stack.method_7969();
        return tag != null && tag.method_10577("fortune");
    }

    private static void setFortune(class_1799 stack, boolean fortune) {
        if (fortune) {
            stack.method_7948().method_10556("fortune", true);
        } else {
            stack.method_7983("fortune");
        }
    }

    public class_1271<class_1799> method_7836(class_1937 world, class_1657 user, class_1268 hand) {
        if (hand == class_1268.field_5808 && user.method_5715()) {
            class_1799 stack;
            DieselToolItem.setFortune(stack, !DieselToolItem.isFortune(stack = user.method_5998(hand)));
            if (!world.field_9236) {
                user.method_7353((class_2561)(DieselToolItem.isFortune(stack) ? MIText.ToolSwitchedFortune.text() : MIText.ToolSwitchedSilkTouch.text()), true);
            }
            return class_1271.method_29237((Object)stack, (boolean)world.field_9236);
        }
        return super.method_7836(world, user, hand);
    }

    public class_1269 method_7884(class_1838 context) {
        class_1799 stack = context.method_8041();
        class_1937 w = context.method_8045();
        class_2338 pos = context.method_8037();
        class_2680 state = w.method_8320(pos);
        class_1657 player = context.method_8036();
        if (FluidFuelItemHelper.getAmount(stack) > 0L) {
            Pair pair;
            class_2680 newState;
            class_2248 newBlock;
            if (stack.method_31573(class_3489.field_42612) && (newBlock = StrippingAccess.getStrippedBlocks().get(state.method_26204())) != null) {
                w.method_8396(player, pos, class_3417.field_14675, class_3419.field_15245, 1.0f, 1.0f);
                if (!w.field_9236) {
                    w.method_8652(pos, (class_2680)newBlock.method_9564().method_11657((class_2769)class_2465.field_11459, (Comparable)((class_2350.class_2351)state.method_11654((class_2769)class_2465.field_11459))), 11);
                    FluidFuelItemHelper.decrement(stack);
                }
                return class_1269.method_29236((boolean)w.field_9236);
            }
            if (stack.method_31573(class_3489.field_42615) && (newState = PathingAccess.getPathStates().get(state.method_26204())) != null) {
                w.method_8396(player, pos, class_3417.field_14616, class_3419.field_15245, 1.0f, 1.0f);
                if (!w.field_9236) {
                    w.method_8652(pos, newState, 11);
                    FluidFuelItemHelper.decrement(stack);
                }
                return class_1269.method_29236((boolean)w.field_9236);
            }
            if (stack.method_31573(class_3489.field_42613) && (pair = (Pair)class_1794.field_8023.get(state.method_26204())) != null) {
                Predicate predicate = (Predicate)pair.getFirst();
                Consumer consumer = (Consumer)pair.getSecond();
                if (predicate.test(context)) {
                    w.method_8396(player, pos, class_3417.field_14846, class_3419.field_15245, 1.0f, 1.0f);
                    if (!w.field_9236) {
                        consumer.accept(context);
                        if (player != null) {
                            FluidFuelItemHelper.decrement(stack);
                        }
                    }
                    return class_1269.method_29236((boolean)w.field_9236);
                }
            }
        }
        return super.method_7884(context);
    }

    @Override
    public Reference2IntMap<class_1887> getEnchantments(class_1799 stack) {
        Reference2IntArrayMap map = new Reference2IntArrayMap();
        if (FluidFuelItemHelper.getAmount(stack) > 0L) {
            if (!DieselToolItem.isFortune(stack)) {
                map.put((Object)class_1893.field_9099, class_1893.field_9099.method_8183());
            } else {
                map.put((Object)class_1893.field_9130, class_1893.field_9130.method_8183());
            }
        }
        return map;
    }

    public class_1269 method_7847(class_1799 stack, class_1657 player, class_1309 interactionTarget, class_1268 usedHand) {
        int defaultMb = 100;
        float speedMultiplier = this.getMiningSpeedMultiplier(stack);
        int costMb = (int)(100.0f / speedMultiplier);
        if (FluidFuelItemHelper.getAmount(stack) >= (long)costMb && stack.method_31573(ConventionalItemTags.SHEARS) && interactionTarget instanceof class_5147) {
            class_5147 shearable = (class_5147)interactionTarget;
            if (!interactionTarget.method_37908().field_9236 && shearable.method_27072()) {
                shearable.method_6636(class_3419.field_15248);
                interactionTarget.method_32875(class_5712.field_28730, (class_1297)player);
                return class_1269.field_5812;
            }
            return class_1269.field_21466;
        }
        return class_1269.field_5811;
    }

    private static class StrippingAccess
    extends class_1743 {
        private StrippingAccess(class_1832 material, float attackDamage, float attackSpeed, class_1792.class_1793 settings) {
            super(material, attackDamage, attackSpeed, settings);
        }

        public static Map<class_2248, class_2248> getStrippedBlocks() {
            return field_7898;
        }
    }

    private static class PathingAccess
    extends class_1821 {
        private PathingAccess(class_1832 material, float attackDamage, float attackSpeed, class_1792.class_1793 settings) {
            super(material, attackDamage, attackSpeed, settings);
        }

        public static Map<class_2248, class_2680> getPathStates() {
            return field_8912;
        }
    }
}

