/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.inventory;

import aztech.modern_industrialization.inventory.ConfigurableFluidStack;
import aztech.modern_industrialization.inventory.ConfigurableInventoryPackets;
import aztech.modern_industrialization.inventory.ConfigurableItemStack;
import aztech.modern_industrialization.inventory.MIInventory;
import aztech.modern_industrialization.inventory.SlotGroup;
import aztech.modern_industrialization.util.Simulation;
import io.netty.buffer.Unpooled;
import java.util.IdentityHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.fabric.api.transfer.v1.context.ContainerItemContext;
import net.fabricmc.fabric.api.transfer.v1.item.PlayerInventoryStorage;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleSlotStorage;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1713;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3917;

public abstract class ConfigurableScreenHandler
extends class_1703 {
    private static final int PLAYER_SLOTS = 36;
    public boolean lockingMode = false;
    protected class_1661 playerInventory;
    protected MIInventory inventory;
    private List<ConfigurableItemStack> trackedItems;
    private List<ConfigurableFluidStack> trackedFluids;
    private final Map<class_1735, SlotGroup> slotGroups = new IdentityHashMap<class_1735, SlotGroup>();
    private final Set<SlotGroup> slotGroupIndices = new LinkedHashSet<SlotGroup>();

    protected ConfigurableScreenHandler(class_3917<?> type, int syncId, class_1661 playerInventory, MIInventory inventory) {
        super(type, syncId);
        this.playerInventory = playerInventory;
        this.inventory = inventory;
        if (playerInventory.field_7546 instanceof class_3222) {
            this.trackedItems = ConfigurableItemStack.copyList(inventory.getItemStacks());
            this.trackedFluids = ConfigurableFluidStack.copyList(inventory.getFluidStacks());
        }
    }

    protected class_1735 addSlot(class_1735 slot, SlotGroup slotGroup) {
        this.slotGroups.put(slot, slotGroup);
        this.slotGroupIndices.add(slotGroup);
        return super.method_7621(slot);
    }

    public void method_7623() {
        class_1657 class_16572 = this.playerInventory.field_7546;
        if (class_16572 instanceof class_3222) {
            class_2540 buf;
            int i;
            class_3222 player = (class_3222)class_16572;
            for (i = 0; i < this.trackedItems.size(); ++i) {
                if (this.trackedItems.get(i).equals(this.inventory.getItemStacks().get(i))) continue;
                this.trackedItems.set(i, new ConfigurableItemStack(this.inventory.getItemStacks().get(i)));
                buf = new class_2540(Unpooled.buffer());
                buf.writeInt(this.field_7763);
                buf.writeInt(i);
                buf.method_10794(this.trackedItems.get(i).toNbt());
                ServerPlayNetworking.send((class_3222)player, (class_2960)ConfigurableInventoryPackets.UPDATE_ITEM_SLOT, (class_2540)buf);
            }
            for (i = 0; i < this.trackedFluids.size(); ++i) {
                if (this.trackedFluids.get(i).equals(this.inventory.getFluidStacks().get(i))) continue;
                this.trackedFluids.set(i, new ConfigurableFluidStack(this.inventory.getFluidStacks().get(i)));
                buf = new class_2540(Unpooled.buffer());
                buf.writeInt(this.field_7763);
                buf.writeInt(i);
                buf.method_10794(this.trackedFluids.get(i).toNbt());
                ServerPlayNetworking.send((class_3222)player, (class_2960)ConfigurableInventoryPackets.UPDATE_FLUID_SLOT, (class_2540)buf);
            }
        }
        super.method_7623();
    }

    public void method_7593(int i, int j, class_1713 actionType, class_1657 player) {
        if (i >= 0) {
            class_1735 slot = (class_1735)this.field_7761.get(i);
            if (slot instanceof ConfigurableFluidStack.ConfigurableFluidSlot) {
                ConfigurableFluidStack.ConfigurableFluidSlot fluidSlot = (ConfigurableFluidStack.ConfigurableFluidSlot)slot;
                if (actionType != class_1713.field_7790) {
                    return;
                }
                ConfigurableFluidStack fluidStack = fluidSlot.getConfStack();
                if (this.lockingMode) {
                    fluidStack.togglePlayerLock();
                } else {
                    fluidSlot.playerInteract(ContainerItemContext.ofPlayerCursor((class_1657)player, (class_1703)this), player, true);
                }
                return;
            }
            if (slot instanceof ConfigurableItemStack.ConfigurableItemSlot) {
                ConfigurableItemStack.ConfigurableItemSlot itemSlot = (ConfigurableItemStack.ConfigurableItemSlot)slot;
                if (this.lockingMode) {
                    switch (actionType) {
                        case field_7790: {
                            ConfigurableItemStack itemStack = itemSlot.getConfStack();
                            itemStack.togglePlayerLock(this.method_34255().method_7909());
                            break;
                        }
                        case field_7794: {
                            this.insertItem(itemSlot, 0, 36, true);
                            if (!slot.method_7677().method_7960()) break;
                            itemSlot.getConfStack().playerLock(class_1802.field_8162, Simulation.ACT);
                        }
                    }
                    return;
                }
            }
        }
        super.method_7593(i, j, actionType, player);
    }

    public final class_1799 method_7601(class_1657 player, int slotIndex) {
        this.handleShiftClick(player, slotIndex);
        return class_1799.field_8037;
    }

    protected void handleShiftClick(class_1657 player, int slotIndex) {
        class_1735 slot = (class_1735)this.field_7761.get(slotIndex);
        if (slot.method_7681() && slot.method_7674(player)) {
            if (slotIndex < 36) {
                PlayerInventoryStorage playerInvStorage = PlayerInventoryStorage.of((class_1657)player);
                ContainerItemContext ctx = ContainerItemContext.ofPlayerSlot((class_1657)player, (SingleSlotStorage)playerInvStorage.getSlot(slot.method_34266()));
                for (class_1735 maybeFluidSlot : this.field_7761) {
                    ConfigurableFluidStack.ConfigurableFluidSlot fluidSlot;
                    if (!(maybeFluidSlot instanceof ConfigurableFluidStack.ConfigurableFluidSlot) || !(fluidSlot = (ConfigurableFluidStack.ConfigurableFluidSlot)maybeFluidSlot).playerInteract(ctx, player, false)) continue;
                    return;
                }
                for (SlotGroup group : this.slotGroupIndices) {
                    if (!this.insertItem(slot, 36, this.field_7761.size(), false, s -> this.slotGroups.get(s) == group)) continue;
                    return;
                }
                if (slotIndex < 27) {
                    this.insertItem(slot, 27, 36, false);
                } else {
                    this.insertItem(slot, 0, 27, false);
                }
            } else {
                this.insertItem(slot, 0, 36, true);
            }
        }
    }

    @Deprecated
    protected boolean method_7616(class_1799 stack, int startIndex, int endIndex, boolean fromLast) {
        throw new UnsupportedOperationException("Don't use this shit, use the one below instead.");
    }

    protected boolean insertItem(class_1735 sourceSlot, int startIndex, int endIndex, boolean fromLast) {
        return this.insertItem(sourceSlot, startIndex, endIndex, fromLast, s -> true);
    }

    protected boolean insertItem(class_1735 sourceSlot, int startIndex, int endIndex, boolean fromLast, Predicate<class_1735> filter) {
        boolean insertedSomething = false;
        for (int iter = 0; iter < 2; ++iter) {
            int i;
            boolean allowEmptySlots = iter == 1;
            int n = i = fromLast ? endIndex - 1 : startIndex;
            while (0 <= i && i < endIndex && !sourceSlot.method_7677().method_7960()) {
                int maxInsert;
                class_1735 targetSlot = this.method_7611(i);
                class_1799 sourceStack = sourceSlot.method_7677();
                class_1799 targetStack = targetSlot.method_7677();
                if (filter.test(targetSlot) && targetSlot.method_7680(sourceStack) && (allowEmptySlots && targetStack.method_7960() || class_1799.method_31577((class_1799)targetStack, (class_1799)sourceStack)) && (maxInsert = targetSlot.method_7676(sourceStack) - targetStack.method_7947()) > 0) {
                    class_1799 newTargetStack = sourceStack.method_7971(maxInsert);
                    newTargetStack.method_7933(targetStack.method_7947());
                    targetSlot.method_7673(newTargetStack);
                    sourceSlot.method_7668();
                    insertedSomething = true;
                }
                if (fromLast) {
                    --i;
                    continue;
                }
                ++i;
            }
        }
        return insertedSomething;
    }

    public boolean hasUnlockedSlot() {
        for (class_1735 slot : this.field_7761) {
            if (slot instanceof ConfigurableItemStack.ConfigurableItemSlot) {
                ConfigurableItemStack.ConfigurableItemSlot cis = (ConfigurableItemStack.ConfigurableItemSlot)slot;
                if (!cis.getConfStack().playerLocked && cis.getConfStack().playerLockable) {
                    return true;
                }
            }
            if (!(slot instanceof ConfigurableFluidStack.ConfigurableFluidSlot)) continue;
            ConfigurableFluidStack.ConfigurableFluidSlot cfs = (ConfigurableFluidStack.ConfigurableFluidSlot)slot;
            if (cfs.getConfStack().playerLocked || !cfs.getConfStack().playerLockable) continue;
            return true;
        }
        return false;
    }

    public void lockAll(boolean lock) {
        for (class_1735 slot : this.field_7761) {
            if (slot instanceof ConfigurableItemStack.ConfigurableItemSlot) {
                ConfigurableItemStack.ConfigurableItemSlot cis = (ConfigurableItemStack.ConfigurableItemSlot)slot;
                if (cis.getConfStack().playerLocked != lock) {
                    cis.getConfStack().togglePlayerLock();
                }
            }
            if (!(slot instanceof ConfigurableFluidStack.ConfigurableFluidSlot)) continue;
            ConfigurableFluidStack.ConfigurableFluidSlot cfs = (ConfigurableFluidStack.ConfigurableFluidSlot)slot;
            if (cfs.getConfStack().playerLocked == lock) continue;
            cfs.getConfStack().togglePlayerLock();
        }
    }
}

