/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.definition;

import aztech.modern_industrialization.MIItem;
import aztech.modern_industrialization.definition.Definition;
import aztech.modern_industrialization.definition.FluidLike;
import aztech.modern_industrialization.definition.FluidTexture;
import aztech.modern_industrialization.definition.ItemDefinition;
import aztech.modern_industrialization.fluid.MIBucketItem;
import aztech.modern_industrialization.fluid.MIFluid;
import aztech.modern_industrialization.fluid.MIFluidBlock;
import aztech.modern_industrialization.items.SortOrder;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariantAttributeHandler;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariantAttributes;
import net.minecraft.class_1755;
import net.minecraft.class_1792;
import net.minecraft.class_3611;

public class FluidDefinition
extends Definition
implements FluidLike {
    public static final int LOW_OPACITY = 180;
    public static final int FULL_OPACITY = 255;
    public static final int NEAR_OPACITY = 240;
    public static final int MEDIUM_OPACITY = 230;
    public final MIFluidBlock fluidBlock;
    public final MIFluid fluid;
    private final FluidVariant variant;
    public final int color;
    public final int opacity;
    public final boolean isGas;
    public final FluidTexture fluidTexture;
    public final ItemDefinition<MIBucketItem> bucketItemDefinition;

    public FluidDefinition(String englishName, String id, int color, int opacity, FluidTexture texture, boolean isGas) {
        super(englishName, id);
        this.color = color;
        this.isGas = isGas;
        this.fluidBlock = new MIFluidBlock(color);
        this.fluid = new MIFluid(this.fluidBlock, color);
        this.bucketItemDefinition = MIItem.item(englishName + " Bucket", id + "_bucket", s -> new MIBucketItem(this.fluid, (class_1792.class_1793)s), SortOrder.BUCKETS);
        this.fluid.setBucketItem(this.bucketItemDefinition.method_8389());
        this.variant = FluidVariant.of((class_3611)this.fluid);
        this.fluidTexture = texture;
        this.opacity = opacity;
        if (isGas) {
            FluidVariantAttributes.register((class_3611)this.fluid, (FluidVariantAttributeHandler)new FluidVariantAttributeHandler(){

                public boolean isLighterThanAir(FluidVariant variant) {
                    return true;
                }
            });
        }
    }

    @Override
    public String getTranslationKey() {
        return "block.modern_industrialization." + this.getId().method_12832();
    }

    @Override
    public class_3611 asFluid() {
        return this.fluid;
    }

    public class_1755 getBucket() {
        return this.bucketItemDefinition.method_8389();
    }

    public FluidVariant variant() {
        return this.variant;
    }
}

