/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.compat.viewer.impl.jei;

import aztech.modern_industrialization.compat.viewer.impl.ViewerUtil;
import aztech.modern_industrialization.util.FluidHelper;
import aztech.modern_industrialization.util.RenderHelper;
import java.util.List;
import mezz.jei.api.fabric.constants.FabricTypes;
import mezz.jei.api.fabric.ingredients.fluids.IJeiFluidIngredient;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.RecipeIngredientRole;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.transfer.v1.client.fluid.FluidVariantRendering;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.minecraft.class_1836;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_3611;

@Environment(value=EnvType.CLIENT)
class JeiSlotUtil {
    private JeiSlotUtil() {
    }

    public static void customizeTooltip(IRecipeSlotBuilder slot, float probability) {
        slot.addTooltipCallback((recipeSlotView, tooltip) -> {
            recipeSlotView.getDisplayedIngredient((IIngredientType)FabricTypes.FLUID_STACK).ifPresent(fluidIngredient -> tooltip.add(1, FluidHelper.getFluidAmount(fluidIngredient.getAmount())));
            boolean input = recipeSlotView.getRole() == RecipeIngredientRole.INPUT;
            class_2561 probabilityLine = ViewerUtil.getProbabilityTooltip(probability, input);
            if (probabilityLine != null) {
                tooltip.add(probabilityLine);
            }
        });
    }

    public static void overrideFluidRenderer(IRecipeSlotBuilder slot) {
        slot.setCustomRenderer((IIngredientType)FabricTypes.FLUID_STACK, (IIngredientRenderer)new IIngredientRenderer<IJeiFluidIngredient>(){

            public void render(class_332 guiGraphics, IJeiFluidIngredient ingredient) {
                RenderHelper.drawFluidInGui(guiGraphics, this.getVariant(ingredient), 0, 0);
            }

            public List<class_2561> getTooltip(IJeiFluidIngredient ingredient, class_1836 tooltipFlag) {
                return FluidVariantRendering.getTooltip((FluidVariant)this.getVariant(ingredient), (class_1836)tooltipFlag);
            }

            private FluidVariant getVariant(IJeiFluidIngredient ingredient) {
                return FluidVariant.of((class_3611)ingredient.getFluid(), (class_2487)ingredient.getTag().orElse(null));
            }
        });
    }
}

