/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.compat.ftbteams;

import aztech.modern_industrialization.compat.ftbteams.FTBTeamsFacade;
import dev.ftb.mods.ftbteams.api.FTBTeamsAPI;
import dev.ftb.mods.ftbteams.api.Team;
import dev.ftb.mods.ftbteams.api.event.TeamEvent;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;

public class FTBTeamsFacadeImpl
implements FTBTeamsFacade {
    private final Map<UUID, Iterable<UUID>> cachedPlayersInTeam = new HashMap<UUID, Iterable<UUID>>();

    public FTBTeamsFacadeImpl() {
        TeamEvent.PLAYER_CHANGED.register(event -> this.cachedPlayersInTeam.clear());
        ServerLifecycleEvents.SERVER_STOPPED.register(server -> this.cachedPlayersInTeam.clear());
    }

    @Override
    public Iterable<UUID> getOtherPlayersInTeam(UUID playerUuid) {
        return this.cachedPlayersInTeam.computeIfAbsent(playerUuid, uuid -> {
            Optional team = FTBTeamsAPI.api().getManager().getTeamForPlayerID(uuid);
            if (team.isEmpty()) {
                return List.of();
            }
            HashSet keys = new HashSet(((Team)team.get()).getMembers());
            keys.remove(uuid);
            return keys;
        });
    }
}

