/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.api.energy;

import aztech.modern_industrialization.MIBlockKeys;
import aztech.modern_industrialization.compat.kubejs.KubeJSProxy;
import aztech.modern_industrialization.machines.models.MachineCasing;
import aztech.modern_industrialization.machines.models.MachineCasings;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import net.fabricmc.fabric.api.transfer.v1.storage.StoragePreconditions;
import net.minecraft.class_2248;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CableTier
implements Comparable<CableTier> {
    public static CableTier LV = new CableTier("lv", "LV", "Low Voltage", 32L, null);
    public static CableTier MV = new CableTier("mv", "MV", "Medium Voltage", 128L, MIBlockKeys.ADVANCED_MACHINE_HULL);
    public static CableTier HV = new CableTier("hv", "HV", "High Voltage", 1024L, MIBlockKeys.TURBO_MACHINE_HULL);
    public static CableTier EV = new CableTier("ev", "EV", "Extreme Voltage", 8192L, MIBlockKeys.HIGHLY_ADVANCED_MACHINE_HULL);
    public static CableTier SUPERCONDUCTOR = new CableTier("superconductor", "Superconductor", "Superconductor", 128000000L, MIBlockKeys.QUANTUM_MACHINE_HULL);
    public final String name;
    public final String shortEnglishName;
    public final String longEnglishName;
    public final long eu;
    @Nullable
    public final class_2960 itemKey;
    public final boolean builtin;
    public final MachineCasing casing;
    private static final Map<String, CableTier> tiers = new HashMap<String, CableTier>();

    public CableTier(String name, String shortEnglishName, String longEnglishName, long eu, class_2960 itemKey, boolean builtin) {
        StoragePreconditions.notNegative((long)eu);
        this.name = name;
        this.shortEnglishName = shortEnglishName;
        this.longEnglishName = longEnglishName;
        this.eu = eu;
        this.itemKey = itemKey;
        this.casing = MachineCasings.create(name);
        this.builtin = builtin;
    }

    private CableTier(String name, String shortEnglishName, String longEnglishName, long eu, @Nullable class_5321<class_2248> key) {
        this(name, shortEnglishName, longEnglishName, eu, key == null ? null : key.method_29177(), true);
    }

    public String shortEnglishKey() {
        return "cable_tier_short.modern_industrialization." + this.name;
    }

    public class_5250 shortEnglishName() {
        return class_2561.method_43471((String)this.shortEnglishKey());
    }

    public String longEnglishKey() {
        return "cable_tier_long.modern_industrialization." + this.name;
    }

    public class_5250 longEnglishName() {
        return class_2561.method_43471((String)this.longEnglishKey());
    }

    public long getMaxTransfer() {
        return this.eu * 8L;
    }

    public long getEu() {
        return this.eu;
    }

    @Override
    public int compareTo(@NotNull CableTier other) {
        return Long.compare(this.eu, other.eu);
    }

    public String toString() {
        return this.name;
    }

    public static void addTier(CableTier tier) {
        for (CableTier existingTier : tiers.values()) {
            if (existingTier.name.equals(tier.name)) {
                throw new IllegalArgumentException("Tier " + tier + " already exists!");
            }
            if (existingTier.eu == tier.eu) {
                throw new IllegalArgumentException("A tier with eu " + tier.eu + " already exists!");
            }
            if (!Objects.equals(existingTier.itemKey, tier.itemKey)) continue;
            throw new IllegalArgumentException("A tier with block key " + tier.itemKey + " already exists!");
        }
        tiers.put(tier.name, tier);
    }

    public static CableTier getTier(String name) {
        CableTier existing = tiers.get(name);
        if (existing == null) {
            throw new NoSuchElementException("No such cable tier: " + name);
        }
        return existing;
    }

    public static List<CableTier> allTiers() {
        return tiers.values().stream().sorted().toList();
    }

    static {
        CableTier.addTier(LV);
        CableTier.addTier(MV);
        CableTier.addTier(HV);
        CableTier.addTier(EV);
        CableTier.addTier(SUPERCONDUCTOR);
        KubeJSProxy.instance.fireCableTiersEvent();
    }
}

