/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.test;

import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1838;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_3965;
import net.minecraft.class_4512;
import net.minecraft.class_4513;
import net.minecraft.class_4516;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.common.block.ForceRelayBlock;
import vazkii.botania.common.block.block_entity.BotaniaBlockEntities;
import vazkii.botania.common.block.block_entity.mana.ManaSpreaderBlockEntity;
import vazkii.botania.common.item.BotaniaItems;
import vazkii.botania.common.item.lens.LensItem;

public class TestingUtil {
    public static final String EMPTY_STRUCTURE = "fabric-gametest-api-v1:empty";

    @Contract(value="_,_,_ -> fail")
    public static void throwPositionedAssertion(class_4516 helper, class_2338 relativePos, Supplier<String> msg) {
        throw new class_4513(msg.get(), helper.method_36052(relativePos), relativePos, helper.method_36045());
    }

    @Contract(value="false,_ -> fail")
    public static void assertThat(boolean value, Supplier<String> message) {
        if (!value) {
            throw new class_4512(message.get());
        }
    }

    @Contract(value="_,_,false,_ -> fail")
    public static void assertAt(class_4516 helper, class_2338 relativePos, boolean value, Supplier<String> message) {
        if (!value) {
            TestingUtil.throwPositionedAssertion(helper, relativePos, message);
        }
    }

    public static void assertEquals(@Nullable Object a, @Nullable Object b) {
        TestingUtil.assertEquals(a, b, () -> "Expected " + String.valueOf(a) + " to equal " + String.valueOf(b));
    }

    public static void assertEquals(@Nullable Object a, @Nullable Object b, Supplier<String> message) {
        TestingUtil.assertThat(Objects.equals(a, b), message);
    }

    public static void assertEqualsAt(class_4516 helper, class_2338 relativePos, @Nullable Object a, @Nullable Object b) {
        TestingUtil.assertEqualsAt(helper, relativePos, a, b, () -> "Expected " + String.valueOf(a) + " to equal " + String.valueOf(b));
    }

    public static void assertEqualsAt(class_4516 helper, class_2338 relativePos, @Nullable Object a, @Nullable Object b, Supplier<String> message) {
        TestingUtil.assertAt(helper, relativePos, Objects.equals(a, b), message);
    }

    public static <T extends class_2586> T assertBlockEntity(class_4516 helper, class_2338 relativePos, class_2591<T> type) {
        class_2586 be = helper.method_36014(relativePos);
        TestingUtil.assertAt(helper, relativePos, be != null, () -> "Expected BlockEntity of type " + String.valueOf(class_7923.field_41181.method_10221((Object)type)) + " but found no BlockEntity");
        TestingUtil.assertAt(helper, relativePos, be.method_11017() == type, () -> "Expected BlockEntity of type " + String.valueOf(class_7923.field_41181.method_10221((Object)type)) + " but found " + String.valueOf(class_7923.field_41181.method_10221((Object)be.method_11017())));
        return (T)be;
    }

    public static <T extends class_2586> T assertBlockEntity(class_4516 helper, class_2338 relativePos, Class<T> classs) {
        class_2586 be = helper.method_36014(relativePos);
        TestingUtil.assertAt(helper, relativePos, be != null, () -> "Expected BlockEntity of class " + classs.getSimpleName() + " but found no BlockEntity");
        TestingUtil.assertAt(helper, relativePos, classs.isAssignableFrom(be.getClass()), () -> "Expected BlockEntity to be an instance of " + classs.getSimpleName() + " but found " + be.getClass().getSimpleName());
        return (T)((class_2586)classs.cast(be));
    }

    public static class_2586 assertAnyBlockEntity(class_4516 helper, class_2338 relativePos) {
        class_2586 be = helper.method_36014(relativePos);
        TestingUtil.assertAt(helper, relativePos, be != null, () -> "Expected any BlockEntity but found nothing");
        return be;
    }

    public static void useItemOn(class_4516 helper, class_1657 player, class_1268 hand, class_2338 pos) {
        class_2338 absolutePos = helper.method_36052(pos);
        class_3965 result = new class_3965(class_243.method_24953((class_2382)absolutePos), class_2350.field_11043, absolutePos, true);
        class_1799 stack = player.method_5998(hand);
        class_1838 useOnContext = new class_1838(player, hand, result);
        stack.method_7981(useOnContext);
    }

    public static void bindWithWandOfTheForest(class_4516 helper, class_2338 first, class_2338 second) {
        class_1657 player = helper.method_36021();
        player.method_6122(class_1268.field_5808, new class_1799((class_1935)BotaniaItems.twigWand));
        player.method_5660(true);
        player.method_33574(class_243.method_24953((class_2382)first));
        TestingUtil.useItemOn(helper, player, class_1268.field_5808, first);
        player.method_33574(class_243.method_24953((class_2382)second));
        TestingUtil.useItemOn(helper, player, class_1268.field_5808, second);
    }

    public static void bindForceRelayTarget(class_4516 helper, class_2338 relayPos, class_2338 targetPos) {
        ForceRelayBlock.WorldData data = ForceRelayBlock.WorldData.get((class_1937)helper.method_35943());
        data.mapping.put(helper.method_36052(relayPos), helper.method_36052(targetPos));
    }

    @Nullable
    public static class_2338 getBoundForceRelayTarget(class_4516 helper, class_2338 relayPos) {
        ForceRelayBlock.WorldData data = ForceRelayBlock.WorldData.get((class_1937)helper.method_35943());
        return data.mapping.get(helper.method_36052(relayPos));
    }

    public static void setUpSpreaderAndCompositeLens(class_4516 helper, class_1792 firstLensType, class_1792 secondLensType, class_2338 spreaderPos, class_2338 spreaderTargetPos) {
        class_1799 firstLensStack = new class_1799((class_1935)firstLensType);
        class_1799 secondLensStack = new class_1799((class_1935)secondLensType);
        class_1799 compositeLens = ((LensItem)firstLensStack.method_7909()).setCompositeLens(firstLensStack, secondLensStack);
        ManaSpreaderBlockEntity spreaderEntity = TestingUtil.assertBlockEntity(helper, spreaderPos, BotaniaBlockEntities.SPREADER);
        spreaderEntity.getItemHandler().method_5447(0, compositeLens);
        TestingUtil.bindWithWandOfTheForest(helper, spreaderPos, spreaderTargetPos);
    }
}

