/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.world;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_156;
import net.minecraft.class_18;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_3218;
import org.jetbrains.annotations.NotNull;
import vazkii.botania.common.world.IslandPos;
import vazkii.botania.xplat.BotaniaConfig;

public class SkyblockSavedData
extends class_18 {
    private static final String NAME = "gog_skyblock_islands";
    private static final int OFFSET = 1;
    public final BiMap<IslandPos, UUID> skyblocks;
    private final Spiral spiral;

    public SkyblockSavedData(class_2487 nbt) {
        HashBiMap map = HashBiMap.create();
        for (class_2520 inbt : nbt.method_10554("Islands", 10)) {
            class_2487 tag = (class_2487)inbt;
            map.put((Object)IslandPos.fromTag(tag), (Object)tag.method_25926("Player"));
        }
        this.skyblocks = map;
        this.spiral = nbt.method_10573("SpiralState", 11) ? Spiral.fromArray(nbt.method_10561("SpiralState")) : new Spiral();
    }

    public static SkyblockSavedData get(class_3218 world) {
        return (SkyblockSavedData)world.method_17983().method_17924(SkyblockSavedData::new, () -> new SkyblockSavedData(new class_2487()), NAME);
    }

    public IslandPos getSpawn() {
        if (this.skyblocks.containsValue((Object)class_156.field_25140)) {
            return (IslandPos)this.skyblocks.inverse().get((Object)class_156.field_25140);
        }
        IslandPos pos = new IslandPos(1, 1);
        this.skyblocks.put((Object)pos, (Object)class_156.field_25140);
        this.method_80();
        return pos;
    }

    public IslandPos create(UUID playerId) {
        int[] pos;
        IslandPos islandPos;
        int scale = BotaniaConfig.common().gogIslandScaleMultiplier();
        while (this.skyblocks.containsKey((Object)(islandPos = new IslandPos((pos = this.spiral.next())[0] * scale + 1, pos[1] * scale + 1)))) {
        }
        this.skyblocks.put((Object)islandPos, (Object)playerId);
        this.method_80();
        return islandPos;
    }

    @NotNull
    public class_2487 method_75(@NotNull class_2487 nbt) {
        class_2499 list = new class_2499();
        for (Map.Entry entry : this.skyblocks.entrySet()) {
            class_2487 entryTag = ((IslandPos)entry.getKey()).toTag();
            entryTag.method_25927("Player", (UUID)entry.getValue());
            list.add((Object)entryTag);
        }
        nbt.method_10539("SpiralState", this.spiral.toIntArray());
        nbt.method_10566("Islands", (class_2520)list);
        return nbt;
    }

    private static class Spiral {
        private int x = 0;
        private int y = 0;
        private int dx = 0;
        private int dy = -1;

        Spiral() {
        }

        Spiral(int x, int y, int dx, int dy) {
            this.x = x;
            this.y = y;
            this.dx = dx;
            this.dy = dy;
        }

        int[] next() {
            if (this.x == this.y || this.x < 0 && this.x == -this.y || this.x > 0 && this.x == 1 - this.y) {
                int t = this.dx;
                this.dx = -this.dy;
                this.dy = t;
            }
            this.x += this.dx;
            this.y += this.dy;
            return new int[]{this.x, this.y};
        }

        int[] toIntArray() {
            return new int[]{this.x, this.y, this.dx, this.dy};
        }

        static Spiral fromArray(int[] ints) {
            return new Spiral(ints[0], ints[1], ints[2], ints[3]);
        }
    }
}

