/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.flower.generating;

import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import vazkii.botania.api.block_entity.GeneratingFlowerBlockEntity;
import vazkii.botania.api.block_entity.RadiusDescriptor;
import vazkii.botania.common.block.BotaniaFlowerBlocks;
import vazkii.botania.common.lib.BotaniaTags;

public class RafflowsiaBlockEntity
extends GeneratingFlowerBlockEntity {
    public static final String TAG_LAST_FLOWERS = "lastFlowers";
    public static final String TAG_LAST_FLOWER_TIMES = "lastFlowerTimes";
    public static final String TAG_STREAK_LENGTH = "streakLength";
    private final List<class_2960> lastFlowers = new LinkedList<class_2960>();
    private int streakLength = -1;
    private int lastFlowerCount = 0;
    private static final int RANGE = 5;
    private static final int[] STREAK_OUTPUTS = new int[]{2000, 2100, 2200, 2300, 3280, 4033, 4657, 5150, 6622, 7860, 10418, 12600, 14769, 16671, 19000, 25400, 33471, 40900, 47579, 53600, 59057, 64264, 69217, 74483, 79352, 83869, 88059, 92129, 96669, 100940, 105239, 112044, 118442, 124612, 130583, 136228, 141703, 178442, 213959, 247725, 279956, 313671, 345833, 377227, 437689, 495526, 553702, 638554};

    public RafflowsiaBlockEntity(class_2338 pos, class_2680 state) {
        super(BotaniaFlowerBlocks.RAFFLOWSIA, pos, state);
    }

    private int getMaxStreak() {
        return STREAK_OUTPUTS.length - 1;
    }

    private int getValueForStreak(int index) {
        if (index != 0) {
            this.lastFlowerCount = 0;
        }
        return STREAK_OUTPUTS[index] / ++this.lastFlowerCount;
    }

    private int processFlower(class_2248 flower) {
        class_2960 flowerKey = class_7923.field_41175.method_10221((Object)flower);
        ListIterator<class_2960> it = this.lastFlowers.listIterator();
        while (it.hasNext()) {
            int index = it.nextIndex();
            class_2960 streakFlower = it.next();
            if (!streakFlower.equals((Object)flowerKey)) continue;
            it.remove();
            this.lastFlowers.add(0, streakFlower);
            return index;
        }
        this.lastFlowers.add(0, flowerKey);
        if (this.lastFlowers.size() >= this.getMaxStreak()) {
            this.lastFlowers.remove(this.lastFlowers.size() - 1);
        }
        return this.getMaxStreak();
    }

    @Override
    public void tickFlower() {
        super.tickFlower();
        int mana = 2100;
        if (this.getMaxMana() - this.getMana() >= mana && !this.method_10997().field_9236 && this.ticksExisted % 40 == 0) {
            for (int i = 0; i < 11; ++i) {
                for (int j = 0; j < 11; ++j) {
                    for (int k = 0; k < 11; ++k) {
                        class_2338 pos = this.getEffectivePos().method_10069(i - 5, j - 5, k - 5);
                        class_2680 state = this.method_10997().method_8320(pos);
                        if (!state.method_26164(BotaniaTags.Blocks.SPECIAL_FLOWERS) || state.method_27852(BotaniaFlowerBlocks.rafflowsia)) continue;
                        this.streakLength = Math.min(this.streakLength + 1, this.processFlower(state.method_26204()));
                        this.method_10997().method_22352(pos, false);
                        this.addMana(this.getValueForStreak(this.streakLength));
                        this.sync();
                        return;
                    }
                }
            }
        }
    }

    @Override
    public void writeToPacketNBT(class_2487 cmp) {
        super.writeToPacketNBT(cmp);
        class_2499 flowerList = new class_2499();
        for (class_2960 flower : this.lastFlowers) {
            flowerList.add((Object)class_2519.method_23256((String)flower.toString()));
        }
        cmp.method_10566(TAG_LAST_FLOWERS, (class_2520)flowerList);
        cmp.method_10569(TAG_LAST_FLOWER_TIMES, this.lastFlowerCount);
        cmp.method_10569(TAG_STREAK_LENGTH, this.streakLength);
    }

    @Override
    public void readFromPacketNBT(class_2487 cmp) {
        super.readFromPacketNBT(cmp);
        this.lastFlowers.clear();
        class_2499 flowerList = cmp.method_10554(TAG_LAST_FLOWERS, 8);
        for (int i = 0; i < flowerList.size(); ++i) {
            class_2960 blockID = class_2960.method_12829((String)flowerList.method_10608(i));
            if (blockID == null) continue;
            this.lastFlowers.add(blockID);
        }
        this.lastFlowerCount = cmp.method_10550(TAG_LAST_FLOWER_TIMES);
        this.streakLength = cmp.method_10550(TAG_STREAK_LENGTH);
    }

    @Override
    public RadiusDescriptor getRadius() {
        return RadiusDescriptor.Rectangle.square(this.getEffectivePos(), 5);
    }

    @Override
    public int getColor() {
        return 5254262;
    }

    @Override
    public int getMaxMana() {
        return STREAK_OUTPUTS[STREAK_OUTPUTS.length - 1];
    }
}

