/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.ai.pathing;

import java.util.Objects;
import mod.azure.azurelib.ai.pathing.AzurePathFinder;
import net.minecraft.class_10;
import net.minecraft.class_11;
import net.minecraft.class_1297;
import net.minecraft.class_13;
import net.minecraft.class_1308;
import net.minecraft.class_14;
import net.minecraft.class_1409;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_3481;
import net.minecraft.class_3532;
import net.minecraft.class_7;
import net.minecraft.class_9;
import org.jetbrains.annotations.Nullable;

public class AzureNavigation
extends class_1409 {
    @Nullable
    protected class_2338 pathToPosition;
    static final float EPSILON = 1.0E-8f;

    public AzureNavigation(class_1308 entity, class_1937 world) {
        super(entity, world);
    }

    protected class_13 method_6336(int maxVisitedNodes) {
        this.field_6678 = new class_14();
        this.field_6678.method_15(true);
        return new AzurePathFinder(this.field_6678, maxVisitedNodes);
    }

    public void hardStop() {
        this.field_6681 = null;
        this.pathToPosition = null;
    }

    protected void method_6359() {
        super.method_6359();
        for (int i = 0; i < this.field_6681.method_38(); ++i) {
            class_9 node = this.field_6681.method_40(i);
            class_9 node2 = i + 1 < this.field_6681.method_38() ? this.field_6681.method_40(i + 1) : null;
            class_2680 blockState = this.field_6677.method_8320(new class_2338(node.field_40, node.field_39, node.field_38));
            if (!blockState.method_26164(class_3481.field_15459)) continue;
            this.field_6681.method_33(i, node.method_26(node.field_40, node.field_39 + 1, node.field_38));
            if (node2 == null || node.field_39 < node2.field_39) continue;
            this.field_6681.method_33(i + 1, node.method_26(node2.field_40, node.field_39 + 1, node2.field_38));
        }
    }

    protected void method_6339() {
        class_11 path = Objects.requireNonNull(this.field_6681);
        class_243 entityPos = this.method_6347();
        int pathLength = path.method_38();
        for (int i = path.method_39(); i < path.method_38(); ++i) {
            if ((double)path.method_40((int)i).field_39 == Math.floor(entityPos.field_1351)) continue;
            pathLength = i;
            break;
        }
        class_243 base = entityPos.method_1031((double)(-this.field_6684.method_17681() * 0.5f), 0.0, (double)(-this.field_6684.method_17681() * 0.5f));
        class_243 max = base.method_1031((double)this.field_6684.method_17681(), (double)this.field_6684.method_17682(), (double)this.field_6684.method_17681());
        if (this.tryShortcut(path, new class_243(this.field_6684.method_23317(), this.field_6684.method_23318(), this.field_6684.method_23321()), pathLength, base, max) && (this.isAt(path, 0.5f) || this.atElevationChange(path) && this.isAt(path, this.field_6684.method_17681() * 0.5f))) {
            this.field_6684.method_5988().method_19615(path.method_49((class_1297)this.field_6684));
            path.method_42(path.method_39() + 1);
        }
        this.method_6346(entityPos);
    }

    public class_11 method_6348(class_2338 blockPos, int i) {
        this.pathToPosition = blockPos;
        return super.method_6348(blockPos, i);
    }

    public class_11 method_6349(class_1297 entity, int i) {
        this.pathToPosition = entity.method_24515();
        return super.method_6349(entity, i);
    }

    public boolean method_6335(class_1297 entity, double d) {
        class_11 path = this.method_6349(entity, 0);
        if (path != null) {
            return this.method_6334(path, d);
        }
        this.pathToPosition = entity.method_24515();
        this.field_6668 = d;
        return true;
    }

    public float getMinimumWidth() {
        return Math.max(this.field_6684.method_17681(), 1.0f);
    }

    public void method_6360() {
        super.method_6360();
        if (this.method_6357()) {
            if (this.pathToPosition != null) {
                if (this.pathToPosition.method_19769((class_2374)this.field_6684.method_19538(), (double)this.getMinimumWidth()) || this.field_6684.method_23318() > (double)this.pathToPosition.method_10264() && class_2338.method_49637((double)this.pathToPosition.method_10263(), (double)this.field_6684.method_23318(), (double)this.pathToPosition.method_10260()).method_19769((class_2374)this.field_6684.method_19538(), (double)this.getMinimumWidth())) {
                    this.pathToPosition = null;
                } else {
                    this.field_6684.method_5962().method_6239((double)this.pathToPosition.method_10263(), (double)this.pathToPosition.method_10264(), (double)this.pathToPosition.method_10260(), this.field_6668);
                }
            }
            return;
        }
        if (this.method_6355() != null) {
            this.field_6684.method_5988().method_20248((double)this.method_6355().method_10263(), (double)this.method_6355().method_10264(), (double)this.method_6355().method_10260());
        }
    }

    private boolean isAt(class_11 path, float threshold) {
        class_243 pathPos = path.method_49((class_1297)this.field_6684);
        return class_3532.method_15379((float)((float)(this.field_6684.method_23317() - pathPos.field_1352))) < threshold && class_3532.method_15379((float)((float)(this.field_6684.method_23321() - pathPos.field_1350))) < threshold && Math.abs(this.field_6684.method_23318() - pathPos.field_1351) < 1.0;
    }

    private boolean atElevationChange(class_11 path) {
        int curr = path.method_39();
        int end = Math.min(path.method_38(), curr + class_3532.method_15386((float)(this.field_6684.method_17681() * 0.5f)) + 1);
        int currY = path.method_40((int)curr).field_39;
        for (int i = curr + 1; i < end; ++i) {
            if (path.method_40((int)i).field_39 == currY) continue;
            return true;
        }
        return false;
    }

    private boolean tryShortcut(class_11 path, class_243 entityPos, int pathLength, class_243 base, class_243 max) {
        int i = pathLength;
        while (--i > path.method_39()) {
            class_243 vec = path.method_47((class_1297)this.field_6684, i).method_1020(entityPos);
            if (!this.sweep(vec, base, max)) continue;
            path.method_42(i);
            return false;
        }
        return true;
    }

    private boolean sweep(class_243 vec, class_243 base, class_243 max) {
        float t = 0.0f;
        float max_t = (float)vec.method_1033();
        if (max_t < 1.0E-8f) {
            return true;
        }
        float[] tr = new float[3];
        int[] ldi = new int[3];
        int[] tri = new int[3];
        int[] step = new int[3];
        float[] tDelta = new float[3];
        float[] tNext = new float[3];
        float[] normed = new float[3];
        for (int i = 0; i < 3; ++i) {
            float value = AzureNavigation.element(vec, i);
            boolean dir = value >= 0.0f;
            step[i] = dir ? 1 : -1;
            float lead = AzureNavigation.element(dir ? max : base, i);
            tr[i] = AzureNavigation.element(dir ? base : max, i);
            ldi[i] = AzureNavigation.leadEdgeToInt(lead, step[i]);
            tri[i] = AzureNavigation.trailEdgeToInt(tr[i], step[i]);
            normed[i] = value / max_t;
            tDelta[i] = class_3532.method_15379((float)(max_t / value));
            float dist = dir ? (float)(ldi[i] + 1) - lead : lead - (float)ldi[i];
            tNext[i] = tDelta[i] < Float.POSITIVE_INFINITY ? tDelta[i] * dist : Float.POSITIVE_INFINITY;
        }
        class_2338.class_2339 pos = new class_2338.class_2339();
        do {
            int axis = tNext[0] < tNext[1] ? (tNext[0] < tNext[2] ? 0 : 2) : (tNext[1] < tNext[2] ? 1 : 2);
            float dt = tNext[axis] - t;
            t = tNext[axis];
            int n = axis;
            ldi[n] = ldi[n] + step[axis];
            int n2 = axis;
            tNext[n2] = tNext[n2] + tDelta[axis];
            for (int i = 0; i < 3; ++i) {
                int n3 = i;
                tr[n3] = tr[n3] + dt * normed[i];
                tri[i] = AzureNavigation.trailEdgeToInt(tr[i], step[i]);
            }
            int stepx = step[0];
            int x0 = axis == 0 ? ldi[0] : tri[0];
            int x1 = ldi[0] + stepx;
            int stepy = step[1];
            int y0 = axis == 1 ? ldi[1] : tri[1];
            int y1 = ldi[1] + stepy;
            int stepz = step[2];
            int z0 = axis == 2 ? ldi[2] : tri[2];
            int z1 = ldi[2] + stepz;
            for (int x = x0; x != x1; x += stepx) {
                for (int z = z0; z != z1; z += stepz) {
                    for (int y = y0; y != y1; y += stepy) {
                        class_2680 block = this.field_6677.method_8320((class_2338)pos.method_10103(x, y, z));
                        if (block.method_26171((class_1922)this.field_6677, (class_2338)pos, class_10.field_50)) continue;
                        return false;
                    }
                    class_7 below = this.field_6678.method_25((class_1922)this.field_6677, x, y0 - 1, z, this.field_6684);
                    if (below == class_7.field_18 || below == class_7.field_14 || below == class_7.field_7) {
                        return false;
                    }
                    class_7 in = this.field_6678.method_25((class_1922)this.field_6677, x, y0, z, this.field_6684);
                    float priority = this.field_6684.method_5944(in);
                    if (priority < 0.0f || priority >= 8.0f) {
                        return false;
                    }
                    if (in != class_7.field_3 && in != class_7.field_9 && in != class_7.field_17) continue;
                    return false;
                }
            }
        } while (t <= max_t);
        return true;
    }

    static int leadEdgeToInt(float coord, int step) {
        return class_3532.method_15375((float)(coord - (float)step * 1.0E-8f));
    }

    static int trailEdgeToInt(float coord, int step) {
        return class_3532.method_15375((float)(coord + (float)step * 1.0E-8f));
    }

    static float element(class_243 v, int i) {
        switch (i) {
            case 0: {
                return (float)v.field_1352;
            }
            case 1: {
                return (float)v.field_1351;
            }
            case 2: {
                return (float)v.field_1350;
            }
        }
        return 0.0f;
    }
}

